/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.mixin.render;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.util.IEntityRendererInvoker;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.entity.ClientMannequin;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.PlayerModelType;
import net.minecraft.world.entity.player.PlayerSkin;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={EntityRenderDispatcher.class})
public abstract class MixinEntityRenderManager
implements IEntityRendererInvoker {
    @Shadow
    private Map<PlayerModelType, AvatarRenderer<ClientMannequin>> mannequinRenderers;
    @Shadow
    private Map<PlayerModelType, AvatarRenderer<AbstractClientPlayer>> playerRenderers;

    @Shadow
    public abstract <T extends Entity> EntityRenderer<? super T, ?> getRenderer(T var1);

    @Override
    public <E extends Entity> EntityRenderer<? super E, ?> litematica_getEntityRendererNullSafe(E entity) {
        PlayerSkin skin = DefaultPlayerSkin.get((UUID)entity.getUUID());
        if (entity instanceof ClientMannequin) {
            ClientMannequin cme = (ClientMannequin)entity;
            cme.tick();
            skin = cme.getSkin() != null ? cme.getSkin() : skin;
            return this.litematica_getMannequinRendererBySkin(skin);
        }
        if (entity instanceof LocalPlayer) {
            LocalPlayer cpe = (LocalPlayer)entity;
            skin = cpe.getSkin() != null ? cpe.getSkin() : skin;
            return this.litematica_getPlayerRendererBySkin(skin);
        }
        return this.getRenderer(entity);
    }

    @Override
    public <E extends Entity> EntityRenderState litematica_getRenderStateNullSafe(E entity, float tickProgress) {
        EntityRenderer<E, ?> renderer = this.litematica_getEntityRendererNullSafe(entity);
        if (renderer == null) {
            renderer = this.getRenderer(entity);
        }
        if (renderer != null) {
            try {
                return renderer.createRenderState(entity, tickProgress);
            }
            catch (Exception err) {
                Litematica.LOGGER.error("litematica_getRenderState: Exception getting Entity Render State; {}", (Object)err.getLocalizedMessage());
            }
        }
        return null;
    }

    @Unique
    private <E extends Entity> EntityRenderer<? super E, ?> litematica_getPlayerRendererBySkin(PlayerSkin skin) {
        if (this.playerRenderers.containsKey(skin.model())) {
            return (EntityRenderer)this.playerRenderers.get(skin.model());
        }
        if (this.playerRenderers.containsKey(PlayerModelType.WIDE)) {
            return (EntityRenderer)this.playerRenderers.get(PlayerModelType.WIDE);
        }
        return null;
    }

    @Unique
    private <E extends Entity> EntityRenderer<? super E, ?> litematica_getMannequinRendererBySkin(PlayerSkin skin) {
        if (this.mannequinRenderers.containsKey(skin.model())) {
            return (EntityRenderer)this.mannequinRenderers.get(skin.model());
        }
        if (this.mannequinRenderers.containsKey(PlayerModelType.WIDE)) {
            return (EntityRenderer)this.mannequinRenderers.get(PlayerModelType.WIDE);
        }
        return null;
    }
}

