/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FallbackPaneBlock
extends CrossCollisionBlock {
    public static final MapCodec<FallbackPaneBlock> CODEC = FallbackPaneBlock.simpleCodec(FallbackPaneBlock::new);

    public MapCodec<? extends FallbackPaneBlock> codec() {
        return CODEC;
    }

    protected FallbackPaneBlock(BlockBehaviour.Properties settings) {
        super(2.0f, 16.0f, 2.0f, 16.0f, 16.0f, settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        FluidState fluidState = ctx.getLevel().getFluidState(ctx.getClickedPos());
        BlockPos posNorth = pos.north();
        BlockPos posSouth = pos.south();
        BlockPos posWest = pos.west();
        BlockPos posEast = pos.east();
        BlockState stateNorth = world.getBlockState(posNorth);
        BlockState stateSouth = world.getBlockState(posSouth);
        BlockState stateWest = world.getBlockState(posWest);
        BlockState stateEast = world.getBlockState(posEast);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo(stateNorth, stateNorth.isFaceSturdy((BlockGetter)world, posNorth, Direction.SOUTH))))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo(stateSouth, stateSouth.isFaceSturdy((BlockGetter)world, posSouth, Direction.NORTH))))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo(stateWest, stateWest.isFaceSturdy((BlockGetter)world, posWest, Direction.EAST))))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo(stateEast, stateEast.isFaceSturdy((BlockGetter)world, posEast, Direction.WEST))))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickView.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        return direction.getAxis().isHorizontal() ? (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(this.connectsTo(neighborState, neighborState.isFaceSturdy((BlockGetter)world, neighborPos, direction.getOpposite())))) : super.updateShape(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    protected boolean skipRendering(BlockState state, BlockState stateFrom, Direction direction) {
        if (stateFrom.is((Block)this) || stateFrom.is(BlockTags.BARS) && state.is(BlockTags.BARS) && stateFrom.hasProperty((Property)PROPERTY_BY_DIRECTION.get(direction.getOpposite()))) {
            if (!direction.getAxis().isHorizontal()) {
                return true;
            }
            if (((Boolean)state.getValue((Property)PROPERTY_BY_DIRECTION.get(direction))).booleanValue() && ((Boolean)stateFrom.getValue((Property)PROPERTY_BY_DIRECTION.get(direction.getOpposite()))).booleanValue()) {
                return true;
            }
        }
        return super.skipRendering(state, stateFrom, direction);
    }

    public final boolean connectsTo(BlockState state, boolean sideSolidFullSquare) {
        return !FallbackPaneBlock.isExceptionForConnection((BlockState)state) && sideSolidFullSquare || state.getBlock() instanceof IronBarsBlock || state.is(BlockTags.WALLS);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, WEST, SOUTH, WATERLOGGED});
    }
}

