/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.materials.MaterialCache;
import fi.dy.masa.litematica.mixin.block.IMixinWallMountedBlock;
import fi.dy.masa.litematica.mixin.entity.IMixinSignBlockEntity;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.SchematicMetadata;
import fi.dy.masa.litematica.schematic.SchematicaSchematic;
import fi.dy.masa.litematica.schematic.pickblock.SchematicPickBlockEventHandler;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.tool.ToolMode;
import fi.dy.masa.litematica.util.DataFixerMode;
import fi.dy.masa.litematica.util.EasyPlaceProtocol;
import fi.dy.masa.litematica.util.EasyPlaceUtils;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.FileType;
import fi.dy.masa.litematica.util.IWorldUpdateSuppressor;
import fi.dy.masa.litematica.util.InventoryUtils;
import fi.dy.masa.litematica.util.PlacementHandler;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.RayTraceUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.MessageOutputType;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.game.BlockUtils;
import fi.dy.masa.malilib.util.game.wrap.GameWrap;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.BaseTorchBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class WorldUtils {
    @Deprecated(forRemoval=true)
    private static final List<PositionCache> EASY_PLACE_POSITIONS = new ArrayList<PositionCache>();
    @Deprecated(forRemoval=true)
    private static long easyPlaceLastPickBlockTime = System.nanoTime();

    public static double getValidBlockRange(Minecraft mc) {
        return Configs.Generic.EASY_PLACE_VANILLA_REACH.getBooleanValue() ? mc.player.blockInteractionRange() : mc.player.blockInteractionRange() + 1.0;
    }

    public static boolean shouldPreventBlockUpdates(Level world) {
        return ((IWorldUpdateSuppressor)world).litematica_getShouldPreventBlockUpdates();
    }

    public static void setShouldPreventBlockUpdates(Level world, boolean preventUpdates) {
        ((IWorldUpdateSuppressor)world).litematica_setShouldPreventBlockUpdates(preventUpdates);
    }

    public static boolean convertLitematicaSchematicToLitematicaSchematic(Path inputDir, String inputFileName, Path outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        LitematicaSchematic litematicaSchematic = WorldUtils.convertLitematicaSchematicToLitematicaSchematic(inputDir, inputFileName, outputFileName, feedback);
        return litematicaSchematic != null && litematicaSchematic.writeToFile(outputDir, outputFileName, override);
    }

    public static boolean convertSpongeSchematicToLitematicaSchematic(Path inputDir, String inputFileName, Path outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        DataFixerMode oldMode = (DataFixerMode)Configs.Generic.DATAFIXER_MODE.getOptionListValue();
        Configs.Generic.DATAFIXER_MODE.setOptionListValue((IConfigOptionListEntry)DataFixerMode.ALWAYS);
        LitematicaSchematic origSchematic = WorldUtils.convertSpongeSchematicToLitematicaSchematic(inputDir, inputFileName);
        if (origSchematic == null) {
            feedback.setString("litematica.error.schematic_conversion.sponge_to_litematica.failed_to_read_sponge");
            Configs.Generic.DATAFIXER_MODE.setOptionListValue((IConfigOptionListEntry)oldMode);
            return false;
        }
        WorldSchematic world = SchematicWorldHandler.createSchematicWorld(null);
        BlockPos size = new BlockPos(origSchematic.getTotalSize());
        WorldUtils.loadChunksSchematicWorld(world, BlockPos.ZERO, (Vec3i)size);
        SchematicPlacement schematicPlacement = SchematicPlacement.createForSchematicConversion(origSchematic, BlockPos.ZERO);
        origSchematic.placeToWorld(world, schematicPlacement, false);
        String subRegionName = FileUtils.getNameWithoutExtension((String)inputFileName);
        AreaSelection area = new AreaSelection();
        area.setName(subRegionName);
        subRegionName = area.createNewSubRegionBox(BlockPos.ZERO, subRegionName);
        area.setSelectedSubRegionBox(subRegionName);
        Box box = area.getSelectedSubRegionBox();
        area.setSubRegionCornerPos(box, PositionUtils.Corner.CORNER_1, BlockPos.ZERO);
        area.setSubRegionCornerPos(box, PositionUtils.Corner.CORNER_2, size.offset(-1, -1, -1));
        LitematicaSchematic.SchematicSaveInfo info = new LitematicaSchematic.SchematicSaveInfo(false, false);
        LitematicaSchematic newSchem = LitematicaSchematic.createFromWorld(world, area, info, "?", feedback);
        if (newSchem == null) {
            feedback.setString("litematica.error.schematic_conversion.sponge_to_litematica.failed_to_create_litematic");
            Configs.Generic.DATAFIXER_MODE.setOptionListValue((IConfigOptionListEntry)oldMode);
            return false;
        }
        SchematicMetadata origMetadata = origSchematic.getMetadata();
        if (origMetadata.getAuthor().isEmpty() || origMetadata.getAuthor() == "?") {
            newSchem.getMetadata().setAuthor(GameWrap.getPlayerName());
        } else {
            newSchem.getMetadata().setAuthor(origMetadata.getAuthor());
        }
        if (origMetadata.getName().isEmpty() || origMetadata.getName() == "?") {
            newSchem.getMetadata().setName(subRegionName);
        } else {
            newSchem.getMetadata().setName(origMetadata.getName());
        }
        newSchem.getMetadata().setDescription("Converted Sponge V" + origMetadata.getSchematicVersion() + ", Schema " + origMetadata.getSchemaString());
        newSchem.getMetadata().setTimeCreated(origMetadata.getTimeCreated());
        newSchem.getMetadata().setTimeModifiedToNow();
        world.clearEntities();
        Configs.Generic.DATAFIXER_MODE.setOptionListValue((IConfigOptionListEntry)oldMode);
        return newSchem.writeToFile(outputDir, outputFileName, override);
    }

    public static boolean convertSchematicaSchematicToLitematicaSchematic(Path inputDir, String inputFileName, Path outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        LitematicaSchematic litematicaSchematic = WorldUtils.convertSchematicaSchematicToLitematicaSchematic(inputDir, inputFileName, ignoreEntities, feedback);
        return litematicaSchematic != null && litematicaSchematic.writeToFile(outputDir, outputFileName, override);
    }

    @Nullable
    public static LitematicaSchematic convertLitematicaSchematicToLitematicaSchematic(Path inputDir, String inputFileName, String outputFilename, IStringConsumer feedback) {
        DataFixerMode oldMode = (DataFixerMode)Configs.Generic.DATAFIXER_MODE.getOptionListValue();
        Configs.Generic.DATAFIXER_MODE.setOptionListValue((IConfigOptionListEntry)DataFixerMode.ALWAYS);
        LitematicaSchematic newSchematic = LitematicaSchematic.createFromFile(inputDir, inputFileName, FileType.LITEMATICA_SCHEMATIC);
        if (newSchematic == null) {
            feedback.setString("litematica.error.schematic_conversion.litematic_to_litematica.failed_to_read_litematic");
            Configs.Generic.DATAFIXER_MODE.setOptionListValue((IConfigOptionListEntry)oldMode);
            return null;
        }
        SchematicMetadata origMetadata = newSchematic.getMetadata();
        if (origMetadata.getAuthor().isEmpty() || origMetadata.getAuthor() == "?") {
            newSchematic.getMetadata().setAuthor(GameWrap.getPlayerName());
        } else {
            newSchematic.getMetadata().setAuthor(origMetadata.getAuthor());
        }
        if (origMetadata.getName().isEmpty() || origMetadata.getName() == "?") {
            newSchematic.getMetadata().setName(outputFilename);
        } else {
            newSchematic.getMetadata().setName(origMetadata.getName());
        }
        newSchematic.getMetadata().setDescription("Converted Litematic V" + origMetadata.getSchematicVersion() + ", Schema " + origMetadata.getSchemaString());
        newSchematic.getMetadata().setTimeCreated(origMetadata.getTimeCreated());
        newSchematic.getMetadata().setTimeModifiedToNow();
        Configs.Generic.DATAFIXER_MODE.setOptionListValue((IConfigOptionListEntry)oldMode);
        return newSchematic;
    }

    @Nullable
    public static LitematicaSchematic convertSchematicaSchematicToLitematicaSchematic(Path inputDir, String inputFileName, boolean ignoreEntities, IStringConsumer feedback) {
        DataFixerMode oldMode = (DataFixerMode)Configs.Generic.DATAFIXER_MODE.getOptionListValue();
        Configs.Generic.DATAFIXER_MODE.setOptionListValue((IConfigOptionListEntry)DataFixerMode.ALWAYS);
        SchematicaSchematic schematic = SchematicaSchematic.createFromFile(inputDir.resolve(inputFileName));
        if (schematic == null) {
            feedback.setString("litematica.error.schematic_conversion.schematic_to_litematica.failed_to_read_schematic");
            Configs.Generic.DATAFIXER_MODE.setOptionListValue((IConfigOptionListEntry)oldMode);
            return null;
        }
        WorldSchematic world = SchematicWorldHandler.createSchematicWorld(null);
        WorldUtils.loadChunksSchematicWorld(world, BlockPos.ZERO, schematic.getSize());
        StructurePlaceSettings placementSettings = new StructurePlaceSettings();
        placementSettings.setIgnoreEntities(ignoreEntities);
        schematic.placeSchematicDirectlyToChunks(world, BlockPos.ZERO, placementSettings);
        Object subRegionName = FileUtils.getNameWithoutExtension((String)inputFileName) + " (Converted Schematic)";
        AreaSelection area = new AreaSelection();
        area.setName((String)subRegionName);
        subRegionName = area.createNewSubRegionBox(BlockPos.ZERO, (String)subRegionName);
        area.setSelectedSubRegionBox((String)subRegionName);
        Box box = area.getSelectedSubRegionBox();
        area.setSubRegionCornerPos(box, PositionUtils.Corner.CORNER_1, BlockPos.ZERO);
        area.setSubRegionCornerPos(box, PositionUtils.Corner.CORNER_2, new BlockPos(schematic.getSize()).offset(-1, -1, -1));
        LitematicaSchematic.SchematicSaveInfo info = new LitematicaSchematic.SchematicSaveInfo(false, false);
        LitematicaSchematic newSchematic = LitematicaSchematic.createFromWorld(world, area, info, "?", feedback);
        if (newSchematic != null && !ignoreEntities) {
            newSchematic.takeEntityDataFromSchematicaSchematic(schematic, (String)subRegionName);
        } else {
            feedback.setString("litematica.error.schematic_conversion.schematic_to_litematica.failed_to_create_schematic");
        }
        newSchematic.getMetadata().setName((String)subRegionName);
        newSchematic.getMetadata().setAuthor(GameWrap.getPlayerName());
        newSchematic.getMetadata().setDescription("Converted Schematica Schematic, Schema " + String.valueOf(schematic.getMetadata().getSchema()));
        newSchematic.getMetadata().setTimeCreated(System.currentTimeMillis());
        newSchematic.getMetadata().setTimeModifiedToNow();
        world.clearEntities();
        Configs.Generic.DATAFIXER_MODE.setOptionListValue((IConfigOptionListEntry)oldMode);
        return newSchematic;
    }

    public static boolean convertStructureToLitematicaSchematic(Path structureDir, String structureFileName, Path outputDir, String outputFileName, boolean override) {
        LitematicaSchematic litematicaSchematic = WorldUtils.convertStructureToLitematicaSchematic(structureDir, structureFileName);
        return litematicaSchematic != null && litematicaSchematic.writeToFile(outputDir, outputFileName, override);
    }

    public static boolean convertStructureToLitematicaSchematic(Path structureDir, String structureFileName, Path outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        DataFixerMode oldMode = (DataFixerMode)Configs.Generic.DATAFIXER_MODE.getOptionListValue();
        Configs.Generic.DATAFIXER_MODE.setOptionListValue((IConfigOptionListEntry)DataFixerMode.ALWAYS);
        LitematicaSchematic origStructure = WorldUtils.convertStructureToLitematicaSchematic(structureDir, structureFileName);
        if (origStructure == null) {
            feedback.setString("litematica.error.schematic_conversion.structure_to_litematica.failed_to_read_structure");
            Configs.Generic.DATAFIXER_MODE.setOptionListValue((IConfigOptionListEntry)oldMode);
            return false;
        }
        WorldSchematic world = SchematicWorldHandler.createSchematicWorld(null);
        BlockPos size = new BlockPos(origStructure.getTotalSize());
        WorldUtils.loadChunksSchematicWorld(world, BlockPos.ZERO, (Vec3i)size);
        SchematicPlacement schematicPlacement = SchematicPlacement.createForSchematicConversion(origStructure, BlockPos.ZERO);
        origStructure.placeToWorld(world, schematicPlacement, false);
        String subRegionName = FileUtils.getNameWithoutExtension((String)structureFileName);
        AreaSelection area = new AreaSelection();
        area.setName(subRegionName);
        subRegionName = area.createNewSubRegionBox(BlockPos.ZERO, subRegionName);
        area.setSelectedSubRegionBox(subRegionName);
        Box box = area.getSelectedSubRegionBox();
        area.setSubRegionCornerPos(box, PositionUtils.Corner.CORNER_1, BlockPos.ZERO);
        area.setSubRegionCornerPos(box, PositionUtils.Corner.CORNER_2, size.offset(-1, -1, -1));
        LitematicaSchematic.SchematicSaveInfo info = new LitematicaSchematic.SchematicSaveInfo(false, false);
        LitematicaSchematic newSchem = LitematicaSchematic.createFromWorld(world, area, info, "?", feedback);
        if (newSchem == null) {
            feedback.setString("litematica.error.schematic_conversion.structure_to_litematica.failed_to_create_litematic");
            Configs.Generic.DATAFIXER_MODE.setOptionListValue((IConfigOptionListEntry)oldMode);
            return false;
        }
        SchematicMetadata origMetadata = origStructure.getMetadata();
        if (origMetadata.getAuthor().isEmpty() || origMetadata.getAuthor() == "?") {
            newSchem.getMetadata().setAuthor(GameWrap.getPlayerName());
        } else {
            newSchem.getMetadata().setAuthor(origMetadata.getAuthor());
        }
        if (origMetadata.getName().isEmpty() || origMetadata.getName() == "?") {
            newSchem.getMetadata().setName(subRegionName);
        } else {
            newSchem.getMetadata().setName(origMetadata.getName());
        }
        newSchem.getMetadata().setDescription("Converted Vanilla Strucutre, Schema " + origMetadata.getSchemaString());
        newSchem.getMetadata().setTimeCreated(origMetadata.getTimeCreated());
        newSchem.getMetadata().setTimeModifiedToNow();
        boolean result = newSchem.writeToFile(outputDir, outputFileName, override);
        world.clearEntities();
        return result;
    }

    @Nullable
    public static LitematicaSchematic convertSpongeSchematicToLitematicaSchematic(Path dir, String fileName) {
        try {
            LitematicaSchematic schematic = LitematicaSchematic.createFromFile(dir, fileName, FileType.SPONGE_SCHEMATIC);
            if (schematic == null) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)("Failed to read the Sponge schematic from '" + fileName + "\""), (Object[])new Object[0]);
            }
            return schematic;
        }
        catch (Exception e) {
            String msg = "Exception while trying to load the Sponge schematic: " + e.getMessage();
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)msg, (Object[])new Object[0]);
            Litematica.LOGGER.error(msg);
            return null;
        }
    }

    @Nullable
    public static LitematicaSchematic convertStructureToLitematicaSchematic(Path structureDir, String structureFileName) {
        try {
            LitematicaSchematic litematicaSchematic = LitematicaSchematic.createFromFile(structureDir, structureFileName, FileType.VANILLA_STRUCTURE);
            if (litematicaSchematic == null) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)("Failed to read the vanilla structure template from '" + structureFileName + "\""), (Object[])new Object[0]);
            }
            return litematicaSchematic;
        }
        catch (Exception e) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)("Exception while trying to load the vanilla structure: " + e.getMessage()), (Object[])new Object[0]);
            Litematica.LOGGER.error("Exception while trying to load the vanilla structure: " + e.getMessage());
            return null;
        }
    }

    public static boolean convertLitematicaSchematicToSchematicaSchematic(Path inputDir, String inputFileName, Path outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        return false;
    }

    public static boolean convertLitematicaSchematicToV6LitematicaSchematic(Path inputDir, String inputFileName, Path outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        LitematicaSchematic v7LitematicaSchematic = LitematicaSchematic.createFromFile(inputDir, inputFileName, FileType.LITEMATICA_SCHEMATIC);
        if (v7LitematicaSchematic == null) {
            feedback.setString("litematica.error.schematic_conversion.litematica_to_schematic.failed_to_read_schematic");
            return false;
        }
        LitematicaSchematic v6LitematicaSchematic = LitematicaSchematic.createEmptySchematicFromExisting(v7LitematicaSchematic, Minecraft.getInstance().player.getName().getString());
        v6LitematicaSchematic.downgradeV7toV6Schematic(v7LitematicaSchematic);
        if (v6LitematicaSchematic.writeToFile(outputDir, outputFileName, override, true)) {
            return true;
        }
        feedback.setString("litematica.error.schematic_conversion.litematica_to_schematic.failed_to_downgrade_litematic");
        return false;
    }

    public static boolean convertLitematicaSchematicToVanillaStructure(Path inputDir, String inputFileName, Path outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        StructureTemplate template = WorldUtils.convertLitematicaSchematicToVanillaStructure(inputDir, inputFileName, ignoreEntities, feedback);
        return WorldUtils.writeVanillaStructureToFile(template, outputDir, outputFileName, override, feedback);
    }

    @Nullable
    public static StructureTemplate convertLitematicaSchematicToVanillaStructure(Path inputDir, String inputFileName, boolean ignoreEntities, IStringConsumer feedback) {
        LitematicaSchematic litematicaSchematic = LitematicaSchematic.createFromFile(inputDir, inputFileName);
        if (litematicaSchematic == null) {
            feedback.setString("litematica.error.schematic_conversion.litematica_to_schematic.failed_to_read_schematic");
            return null;
        }
        WorldSchematic world = SchematicWorldHandler.createSchematicWorld(null);
        BlockPos size = new BlockPos(litematicaSchematic.getTotalSize());
        WorldUtils.loadChunksSchematicWorld(world, BlockPos.ZERO, (Vec3i)size);
        SchematicPlacement schematicPlacement = SchematicPlacement.createForSchematicConversion(litematicaSchematic, BlockPos.ZERO);
        litematicaSchematic.placeToWorld(world, schematicPlacement, false);
        StructureTemplate template = new StructureTemplate();
        template.fillFromWorld((Level)world, BlockPos.ZERO, (Vec3i)size, !ignoreEntities, List.of(Blocks.STRUCTURE_VOID));
        world.clearEntities();
        return template;
    }

    private static boolean writeVanillaStructureToFile(StructureTemplate template, Path dir, String fileNameIn, boolean override, IStringConsumer feedback) {
        Object fileName = fileNameIn;
        String extension = ".nbt";
        if (!((String)fileName).endsWith(extension)) {
            fileName = (String)fileName + extension;
        }
        Path file = dir.resolve((String)fileName);
        Object os = null;
        try {
            if (!Files.exists(dir, new LinkOption[0])) {
                FileUtils.createDirectoriesIfMissing((Path)dir);
            }
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                feedback.setString(StringUtils.translate((String)"litematica.error.schematic_write_to_file_failed.directory_creation_failed", (Object[])new Object[]{dir.toAbsolutePath()}));
                return false;
            }
            if (!override && Files.exists(file, new LinkOption[0])) {
                feedback.setString(StringUtils.translate((String)"litematica.error.structure_write_to_file_failed.exists", (Object[])new Object[]{file.toAbsolutePath()}));
                return false;
            }
            NbtIo.writeCompressed((CompoundTag)template.save(new CompoundTag()), (Path)file);
            return true;
        }
        catch (Exception e) {
            feedback.setString(StringUtils.translate((String)"litematica.error.structure_write_to_file_failed.exception", (Object[])new Object[]{file.toAbsolutePath()}));
            return false;
        }
    }

    public static boolean isClientChunkLoaded(ClientLevel world, int chunkX, int chunkZ) {
        boolean test = world.getChunkSource().getChunk(chunkX, chunkZ, ChunkStatus.FULL, false) != null;
        return test;
    }

    public static void loadChunksSchematicWorld(WorldSchematic world, BlockPos origin, Vec3i areaSize) {
        BlockPos posEnd = origin.offset((Vec3i)PositionUtils.getRelativeEndPositionFromAreaSize(areaSize));
        BlockPos posMin = PositionUtils.getMinCorner(origin, posEnd);
        BlockPos posMax = PositionUtils.getMaxCorner(origin, posEnd);
        int cxMin = posMin.getX() >> 4;
        int czMin = posMin.getZ() >> 4;
        int cxMax = posMax.getX() >> 4;
        int czMax = posMax.getZ() >> 4;
        for (int cz = czMin; cz <= czMax; ++cz) {
            for (int cx = cxMin; cx <= cxMax; ++cx) {
                world.getChunkProvider().loadChunk(cx, cz);
            }
        }
    }

    public static void setToolModeBlockState(ToolMode mode, boolean primary, Minecraft mc) {
        BlockHitResult trace;
        BlockState state = Blocks.AIR.defaultBlockState();
        Entity entity = fi.dy.masa.malilib.util.EntityUtils.getCameraEntity();
        RayTraceUtils.RayTraceWrapper wrapper = RayTraceUtils.getGenericTrace((Level)mc.level, entity, WorldUtils.getValidBlockRange(mc));
        if (wrapper != null && (trace = wrapper.getBlockHitResult()) != null && trace.getType() == HitResult.Type.BLOCK) {
            BlockPos pos = trace.getBlockPos();
            if (wrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
                state = SchematicWorldHandler.getSchematicWorld().getBlockState(pos);
            } else if (wrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.VANILLA_BLOCK) {
                state = mc.level.getBlockState(pos);
            }
        }
        if (primary) {
            mode.setPrimaryBlock(state);
        } else {
            mode.setSecondaryBlock(state);
        }
    }

    public static boolean doSchematicWorldPickBlock(boolean closest, Minecraft mc) {
        WorldSchematic world;
        if (SchematicPickBlockEventHandler.getInstance().onSchematicPickBlockStart(closest)) {
            return true;
        }
        BlockPos pos = closest ? RayTraceUtils.getSchematicWorldTraceIfClosest((Level)mc.level, (Entity)mc.player, WorldUtils.getValidBlockRange(mc)) : RayTraceUtils.getFurthestSchematicWorldBlockBeforeVanilla((Level)mc.level, (Entity)mc.player, WorldUtils.getValidBlockRange(mc), true);
        if (pos != null && (world = SchematicWorldHandler.getSchematicWorld()) != null) {
            BlockState state = world.getBlockState(pos);
            if (SchematicPickBlockEventHandler.getInstance().onSchematicPickBlockPreGather(world, pos, state)) {
                return true;
            }
            ItemStack stack = SchematicPickBlockEventHandler.getInstance().hasPickStack() ? SchematicPickBlockEventHandler.getInstance().getPickStack() : MaterialCache.getInstance().getRequiredBuildItemForState(state, world, pos);
            if (SchematicPickBlockEventHandler.getInstance().onSchematicPickBlockPrePick(world, pos, state, stack)) {
                return true;
            }
            if (SchematicPickBlockEventHandler.getInstance().hasSlotHandler() && SchematicPickBlockEventHandler.getInstance().executePickBlockHandler(world, pos, stack)) {
                SchematicPickBlockEventHandler.getInstance().onSchematicPickBlockSuccess();
                return true;
            }
            InventoryUtils.schematicWorldPickBlock(stack, pos, world, mc);
            SchematicPickBlockEventHandler.getInstance().onSchematicPickBlockSuccess();
            return true;
        }
        return false;
    }

    public static void insertSignTextFromSchematic(SignBlockEntity beClient, String[] screenTextArr, boolean front) {
        BlockEntity beSchem;
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        if (worldSchematic != null && (beSchem = worldSchematic.getBlockEntity(beClient.getBlockPos())) instanceof SignBlockEntity) {
            SignText textSchematic;
            IMixinSignBlockEntity beMixinSchem = (IMixinSignBlockEntity)beSchem;
            SignText signText = textSchematic = front ? beMixinSchem.litematica_getFrontText() : beMixinSchem.litematica_getBackText();
            if (textSchematic != null) {
                for (int i = 0; i < screenTextArr.length; ++i) {
                    screenTextArr[i] = textSchematic.getMessage(i, false).getString();
                }
                beClient.setText(textSchematic, front);
            }
        }
    }

    @Deprecated
    public static void easyPlaceOnUseTick(Minecraft mc) {
        if (mc.player != null && DataManager.getToolMode() != ToolMode.REBUILD && Configs.Generic.EASY_PLACE_MODE.getBooleanValue() && Configs.Generic.EASY_PLACE_HOLD_ENABLED.getBooleanValue() && Hotkeys.EASY_PLACE_ACTIVATION.getKeybind().isKeybindHeld() && !Configs.Generic.EASY_PLACE_POST_REWRITE.getBooleanValue()) {
            WorldUtils.doEasyPlaceAction(mc);
        }
    }

    @Deprecated
    public static boolean handleEasyPlace(Minecraft mc) {
        if (Configs.Generic.EASY_PLACE_MODE.getBooleanValue() && !Configs.Generic.EASY_PLACE_POST_REWRITE.getBooleanValue() && DataManager.getToolMode() != ToolMode.REBUILD) {
            InteractionResult result = WorldUtils.doEasyPlaceAction(mc);
            if (result == InteractionResult.FAIL) {
                MessageOutputType type = (MessageOutputType)Configs.Generic.PLACEMENT_RESTRICTION_WARN.getOptionListValue();
                if (type == MessageOutputType.MESSAGE) {
                    InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)"litematica.message.easy_place_fail", (Object[])new Object[0]);
                } else if (type == MessageOutputType.ACTIONBAR) {
                    InfoUtils.printActionbarMessage((String)"litematica.message.easy_place_fail", (Object[])new Object[0]);
                }
                return true;
            }
            return result != InteractionResult.PASS;
        }
        return false;
    }

    @Deprecated
    private static InteractionResult doEasyPlaceAction(Minecraft mc) {
        RayTraceUtils.RayTraceWrapper traceWrapper;
        double traceMaxRange = WorldUtils.getValidBlockRange(mc);
        if (Configs.Generic.EASY_PLACE_FIRST.getBooleanValue()) {
            boolean targetFluids = Configs.InfoOverlays.INFO_OVERLAYS_TARGET_FLUIDS.getBooleanValue();
            traceWrapper = RayTraceUtils.getGenericTrace((Level)mc.level, (Entity)mc.player, traceMaxRange, true, targetFluids, false);
        } else {
            traceWrapper = RayTraceUtils.getFurthestSchematicWorldTraceBeforeVanilla((Level)mc.level, (Entity)mc.player, traceMaxRange);
            if (traceWrapper == null && WorldUtils.placementRestrictionInEffect(mc)) {
                return InteractionResult.FAIL;
            }
        }
        if (traceWrapper == null) {
            return InteractionResult.PASS;
        }
        if (traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            BlockHitResult trace = traceWrapper.getBlockHitResult();
            HitResult traceVanilla = RayTraceUtils.getRayTraceFromEntity((Level)mc.level, (Entity)mc.player, false, traceMaxRange);
            BlockPos pos = trace.getBlockPos();
            WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
            BlockState stateSchematic = world.getBlockState(pos);
            ItemStack stack = MaterialCache.getInstance().getRequiredBuildItemForState(stateSchematic);
            if (EasyPlaceUtils.easyPlaceIsPositionCached(pos)) {
                return InteractionResult.FAIL;
            }
            if (EasyPlaceUtils.easyPlaceIsTooFast()) {
                return InteractionResult.FAIL;
            }
            if (!stack.isEmpty()) {
                BlockState stateClient = mc.level.getBlockState(pos);
                if (stateSchematic == stateClient) {
                    return InteractionResult.FAIL;
                }
                if (WorldUtils.easyPlaceBlockChecksCancel(stateSchematic, stateClient, (Player)mc.player, traceVanilla, stack)) {
                    return InteractionResult.FAIL;
                }
                InventoryUtils.schematicWorldPickBlock(stack, pos, world, mc);
                InteractionHand hand = EntityUtils.getUsedHandForItem((Player)mc.player, stack);
                if (hand == null) {
                    return InteractionResult.FAIL;
                }
                Vec3 hitPos = trace.getLocation();
                Direction sideOrig = trace.getDirection();
                EasyPlaceProtocol protocol = PlacementHandler.getEffectiveProtocolVersion();
                if ((protocol == EasyPlaceProtocol.NONE || protocol == EasyPlaceProtocol.SLAB_ONLY) && traceVanilla != null && traceVanilla.getType() == HitResult.Type.BLOCK) {
                    BlockHitResult hitResult = (BlockHitResult)traceVanilla;
                    BlockPos posVanilla = hitResult.getBlockPos();
                    Direction sideVanilla = hitResult.getDirection();
                    BlockState stateVanilla = mc.level.getBlockState(posVanilla);
                    Vec3 hit = traceVanilla.getLocation();
                    BlockPlaceContext ctx = new BlockPlaceContext(new UseOnContext((Player)mc.player, hand, hitResult));
                    if (!stateVanilla.canBeReplaced(ctx) && pos.equals((Object)(posVanilla = posVanilla.relative(sideVanilla)))) {
                        hitPos = hit;
                        sideOrig = sideVanilla;
                    }
                }
                Direction side = WorldUtils.applyPlacementFacing(stateSchematic, sideOrig, stateClient);
                PlacementProtocolData placementData = WorldUtils.applyPlacementProtocolAll(pos, stateSchematic, hitPos);
                if (placementData.mustFail) {
                    return InteractionResult.FAIL;
                }
                if (placementData.handled) {
                    pos = placementData.pos;
                    side = placementData.side;
                    hitPos = placementData.hitVec;
                }
                if (protocol == EasyPlaceProtocol.V3) {
                    hitPos = WorldUtils.applyPlacementProtocolV3(pos, stateSchematic, hitPos);
                } else if (protocol == EasyPlaceProtocol.V2) {
                    hitPos = WorldUtils.applyCarpetProtocolHitVec(pos, stateSchematic, hitPos);
                } else if (protocol == EasyPlaceProtocol.SLAB_ONLY) {
                    hitPos = WorldUtils.applyBlockSlabProtocol(pos, stateSchematic, hitPos);
                }
                EasyPlaceUtils.cacheEasyPlacePosition(pos);
                BlockHitResult hitResult = new BlockHitResult(hitPos, side, pos, false);
                InteractionResult result = mc.gameMode.useItemOn(mc.player, hand, hitResult);
                if (InteractionResult.SUCCESS.swingSource().equals((Object)InteractionResult.SwingSource.CLIENT) && Configs.Generic.EASY_PLACE_SWING_HAND.getBooleanValue()) {
                    mc.player.swing(hand);
                }
                if (stateSchematic.getBlock() instanceof SlabBlock && stateSchematic.getValue((Property)SlabBlock.TYPE) == SlabType.DOUBLE && (stateClient = mc.level.getBlockState(pos)).getBlock() instanceof SlabBlock && stateClient.getValue((Property)SlabBlock.TYPE) != SlabType.DOUBLE) {
                    side = WorldUtils.applyPlacementFacing(stateSchematic, sideOrig, stateClient);
                    hitResult = new BlockHitResult(hitPos, side, pos, false);
                    mc.gameMode.useItemOn(mc.player, hand, hitResult);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.VANILLA_BLOCK) {
            return WorldUtils.placementRestrictionInEffect(mc) ? InteractionResult.FAIL : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    @Deprecated
    private static boolean easyPlaceBlockChecksCancel(BlockState stateSchematic, BlockState stateClient, Player player, HitResult trace, ItemStack stack) {
        Block blockClient;
        Block blockSchematic = stateSchematic.getBlock();
        if (blockSchematic instanceof SlabBlock && stateSchematic.getValue((Property)SlabBlock.TYPE) == SlabType.DOUBLE && (blockClient = stateClient.getBlock()) instanceof SlabBlock && stateClient.getValue((Property)SlabBlock.TYPE) != SlabType.DOUBLE) {
            return blockSchematic != blockClient;
        }
        if (trace.getType() != HitResult.Type.BLOCK) {
            return false;
        }
        BlockHitResult hitResult = (BlockHitResult)trace;
        BlockPlaceContext ctx = new BlockPlaceContext(new UseOnContext(player, InteractionHand.MAIN_HAND, hitResult));
        return !stateClient.canBeReplaced(ctx);
    }

    public static PlacementProtocolData applyPlacementProtocolAll(BlockPos pos, BlockState stateSchematic, Vec3 hitVecIn) {
        PlacementProtocolData placementData = new PlacementProtocolData();
        Block stateBlock = stateSchematic.getBlock();
        ClientLevel world = Minecraft.getInstance().level;
        if (stateBlock instanceof BaseTorchBlock || stateBlock instanceof AbstractBannerBlock || stateBlock instanceof SignBlock || stateBlock instanceof AbstractSkullBlock) {
            placementData.handled = true;
            placementData.hitVec = hitVecIn;
            if (stateBlock instanceof WallTorchBlock || stateBlock instanceof RedstoneWallTorchBlock || stateBlock instanceof WallBannerBlock || stateBlock instanceof WallSignBlock || stateBlock instanceof WallSkullBlock) {
                placementData.side = (Direction)stateSchematic.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                placementData.pos = pos.relative(placementData.side.getOpposite());
            } else {
                placementData.side = Direction.UP;
                placementData.pos = pos.below();
            }
            BlockState stateFacing = world.getBlockState(placementData.pos);
            if (stateFacing == null || stateFacing.isAir()) {
                placementData.mustFail = true;
            }
        } else if (stateBlock instanceof FaceAttachedHorizontalDirectionalBlock && !((IMixinWallMountedBlock)stateBlock).litematica_invokeCanPlaceAt(stateSchematic, (LevelReader)world, pos)) {
            placementData.mustFail = true;
        }
        return placementData;
    }

    public static Vec3 applyCarpetProtocolHitVec(BlockPos pos, BlockState state, Vec3 hitVecIn) {
        double x = hitVecIn.x;
        double y = hitVecIn.y;
        double z = hitVecIn.z;
        Block block = state.getBlock();
        Optional facing = BlockUtils.getFirstPropertyFacingValue((BlockState)state);
        int propertyIncrement = 16;
        boolean hasData = false;
        int protocolValue = 0;
        if (facing.isPresent()) {
            protocolValue = ((Direction)facing.get()).get3DDataValue();
            hasData = true;
        } else if (state.hasProperty((Property)BlockStateProperties.AXIS)) {
            Direction.Axis axis = (Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS);
            protocolValue = axis.ordinal();
            hasData = true;
        }
        if (block instanceof RepeaterBlock) {
            protocolValue += (Integer)state.getValue((Property)RepeaterBlock.DELAY) * 16;
        } else if (block instanceof ComparatorBlock && state.getValue((Property)ComparatorBlock.MODE) == ComparatorMode.SUBTRACT) {
            protocolValue += 16;
        } else if (state.hasProperty((Property)BlockStateProperties.HALF) && state.getValue((Property)BlockStateProperties.HALF) == Half.TOP) {
            protocolValue += 16;
        } else if (state.hasProperty((Property)BlockStateProperties.SLAB_TYPE) && state.getValue((Property)BlockStateProperties.SLAB_TYPE) == SlabType.TOP) {
            protocolValue += 16;
        }
        y = WorldUtils.applySlabOrStairHitVecY(y, pos, state);
        if (protocolValue != 0 || hasData) {
            x += (double)(protocolValue * 2 + 2);
        }
        return new Vec3(x, y, z);
    }

    private static double applySlabOrStairHitVecY(double origY, BlockPos pos, BlockState state) {
        double y = origY;
        if (state.hasProperty((Property)BlockStateProperties.SLAB_TYPE)) {
            y = pos.getY();
            if (state.getValue((Property)BlockStateProperties.SLAB_TYPE) == SlabType.TOP) {
                y += 0.99;
            }
        } else if (state.hasProperty((Property)BlockStateProperties.HALF)) {
            y = pos.getY();
            if (state.getValue((Property)BlockStateProperties.HALF) == Half.TOP) {
                y += 0.99;
            }
        }
        return y;
    }

    public static Vec3 applyBlockSlabProtocol(BlockPos pos, BlockState state, Vec3 hitVecIn) {
        double newY = WorldUtils.applySlabOrStairHitVecY(hitVecIn.y, pos, state);
        return newY != hitVecIn.y ? new Vec3(hitVecIn.x, newY, hitVecIn.z) : hitVecIn;
    }

    public static <T extends Comparable<T>> Vec3 applyPlacementProtocolV3(BlockPos pos, BlockState state, Vec3 hitVecIn) {
        Collection props = state.getBlock().getStateDefinition().getProperties();
        if (props.isEmpty()) {
            return hitVecIn;
        }
        double relX = hitVecIn.x - (double)pos.getX();
        int protocolValue = 0;
        int shiftAmount = 1;
        int propCount = 0;
        Optional property = BlockUtils.getFirstDirectionProperty((BlockState)state);
        if (property.isPresent() && property.get() != BlockStateProperties.VERTICAL_DIRECTION) {
            Direction direction = (Direction)state.getValue((Property)property.get());
            protocolValue |= direction.get3DDataValue() << shiftAmount;
            shiftAmount += 3;
            ++propCount;
        }
        ArrayList<Property> propList = new ArrayList<Property>(props);
        propList.sort(Comparator.comparing(Property::getName));
        try {
            for (Property p : propList) {
                if (property.isPresent() && ((EnumProperty)property.get()).equals((Object)p) || !PlacementHandler.WHITELISTED_PROPERTIES.contains((Object)p) || PlacementHandler.BLACKLISTED_PROPERTIES.contains((Object)p)) continue;
                Property prop = p;
                ArrayList list = new ArrayList(prop.getPossibleValues());
                list.sort(Comparable::compareTo);
                int requiredBits = Mth.log2((int)Mth.smallestEncompassingPowerOfTwo((int)list.size()));
                int valueIndex = list.indexOf(state.getValue(prop));
                if (valueIndex == -1) continue;
                protocolValue |= valueIndex << shiftAmount;
                shiftAmount += requiredBits;
                ++propCount;
            }
        }
        catch (Exception e) {
            Litematica.LOGGER.warn("Exception trying to request placement protocol value", (Throwable)e);
        }
        if (propCount > 0) {
            double x = (double)pos.getX() + relX + 2.0 + (double)protocolValue;
            return new Vec3(x, hitVecIn.y, hitVecIn.z);
        }
        return hitVecIn;
    }

    public static Direction applyPlacementFacing(BlockState stateSchematic, Direction side, BlockState stateClient) {
        Block blockSchematic = stateSchematic.getBlock();
        Block blockClient = stateClient.getBlock();
        if (blockSchematic instanceof SlabBlock) {
            if (stateSchematic.getValue((Property)SlabBlock.TYPE) == SlabType.DOUBLE && blockClient instanceof SlabBlock && stateClient.getValue((Property)SlabBlock.TYPE) != SlabType.DOUBLE) {
                if (stateClient.getValue((Property)SlabBlock.TYPE) == SlabType.TOP) {
                    return Direction.DOWN;
                }
                return Direction.UP;
            }
            return Direction.NORTH;
        }
        if (stateSchematic.hasProperty((Property)BlockStateProperties.HALF)) {
            side = stateSchematic.getValue((Property)BlockStateProperties.HALF) == Half.TOP ? Direction.DOWN : Direction.UP;
        }
        return side;
    }

    public static boolean handlePlacementRestriction(Minecraft mc) {
        boolean cancel = WorldUtils.placementRestrictionInEffect(mc);
        if (cancel) {
            MessageOutputType type = (MessageOutputType)Configs.Generic.PLACEMENT_RESTRICTION_WARN.getOptionListValue();
            if (type == MessageOutputType.MESSAGE) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)"litematica.message.placement_restriction_fail", (Object[])new Object[0]);
            } else if (type == MessageOutputType.ACTIONBAR) {
                InfoUtils.printActionbarMessage((String)"litematica.message.placement_restriction_fail", (Object[])new Object[0]);
            }
        }
        return cancel;
    }

    private static boolean placementRestrictionInEffect(Minecraft mc) {
        HitResult trace = mc.hitResult;
        ItemStack stack = mc.player.getMainHandItem();
        if (stack.isEmpty()) {
            stack = mc.player.getOffhandItem();
        }
        if (stack.isEmpty()) {
            return false;
        }
        if (trace != null && trace.getType() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)trace;
            BlockPlaceContext ctx = new BlockPlaceContext(new UseOnContext((Player)mc.player, InteractionHand.MAIN_HAND, blockHitResult));
            BlockPos pos = ctx.getClickedPos();
            BlockState stateClient = mc.level.getBlockState(pos);
            WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
            LayerRange range = DataManager.getRenderLayerRange();
            boolean schematicHasAir = worldSchematic.isEmptyBlock(pos);
            if (!schematicHasAir && !range.isPositionWithinRange(pos)) {
                return true;
            }
            if (schematicHasAir && WorldUtils.isPositionWithinRangeOfSchematicRegions(pos, 2)) {
                return true;
            }
            ctx = new BlockPlaceContext(new UseOnContext((Player)mc.player, InteractionHand.MAIN_HAND, blockHitResult = new BlockHitResult(blockHitResult.getLocation(), blockHitResult.getDirection(), pos, false)));
            if (!stateClient.canBeReplaced(ctx)) {
                return true;
            }
            BlockState stateSchematic = worldSchematic.getBlockState(pos);
            stack = MaterialCache.getInstance().getRequiredBuildItemForState(stateSchematic);
            if (!stack.isEmpty() && EntityUtils.getUsedHandForItem((Player)mc.player, stack) == null) {
                return true;
            }
            Block schematicBlock = stateSchematic.getBlock();
            if ((schematicBlock instanceof WallTorchBlock || schematicBlock instanceof RedstoneWallTorchBlock || schematicBlock instanceof WallBannerBlock || schematicBlock instanceof WallSignBlock || schematicBlock instanceof WallSkullBlock) && blockHitResult.getDirection() != stateSchematic.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                return true;
            }
            BlockState attemptState = schematicBlock.getStateForPlacement(ctx);
            return !WorldUtils.isMatchingStatePlacementRestriction(attemptState, stateSchematic);
        }
        return false;
    }

    private static boolean isMatchingStatePlacementRestriction(BlockState state1, BlockState state2) {
        Property[] orientationProperties;
        if (state1 == null || state2 == null) {
            return false;
        }
        if (state1 == state2) {
            return true;
        }
        for (Property property : orientationProperties = new Property[]{BlockStateProperties.FACING, BlockStateProperties.HALF, BlockStateProperties.FACING_HOPPER, BlockStateProperties.DOOR_HINGE, BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.AXIS, BlockStateProperties.SLAB_TYPE, BlockStateProperties.VERTICAL_DIRECTION, BlockStateProperties.ROTATION_16, BlockStateProperties.HANGING, BlockStateProperties.ATTACH_FACE, BlockStateProperties.BELL_ATTACHMENT}) {
            boolean hasProperty2;
            boolean hasProperty1 = state1.hasProperty(property);
            if (hasProperty1 != (hasProperty2 = state2.hasProperty(property))) {
                return false;
            }
            if (!hasProperty1 || state1.getValue(property) == state2.getValue(property)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPositionWithinRangeOfSchematicRegions(BlockPos pos, int range) {
        SchematicPlacementManager manager = DataManager.getSchematicPlacementManager();
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int minCX = x - range >> 4;
        int minCZ = z - range >> 4;
        int maxCX = x + range >> 4;
        int maxCZ = z + range >> 4;
        for (int cz = minCZ; cz <= maxCZ; ++cz) {
            for (int cx = minCX; cx <= maxCX; ++cx) {
                List<SchematicPlacementManager.PlacementPart> parts = manager.getPlacementPartsInChunk(cx, cz);
                for (SchematicPlacementManager.PlacementPart part : parts) {
                    IntBoundingBox box = part.bb;
                    if (x < box.minX - range || x > box.maxX + range || y < box.minY - range || y > box.maxY + range || z < box.minZ - range || z > box.maxZ + range) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isSliceEmpty(Level world, Direction.Axis axis, BlockPos pos1, BlockPos pos2) {
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        switch (axis) {
            case Z: {
                int x1 = Math.min(pos1.getX(), pos2.getX());
                int x2 = Math.max(pos1.getX(), pos2.getX());
                int y1 = Math.min(pos1.getY(), pos2.getY());
                int y2 = Math.max(pos1.getY(), pos2.getY());
                int z = pos1.getZ();
                int cxMin = x1 >> 4;
                int cxMax = x2 >> 4;
                for (int cx = cxMin; cx <= cxMax; ++cx) {
                    LevelChunk chunk = world.getChunk(cx, z >> 4);
                    int xMin = Math.max(x1, cx << 4);
                    int xMax = Math.min(x2, (cx << 4) + 15);
                    int yMax = Math.min(y2, fi.dy.masa.malilib.util.WorldUtils.getHighestSectionYOffset((ChunkAccess)chunk) + 15);
                    for (int x = xMin; x <= xMax; ++x) {
                        for (int y = y1; y <= yMax; ++y) {
                            if (chunk.getBlockState((BlockPos)posMutable.set(x, y, z)).isAir()) continue;
                            return false;
                        }
                    }
                }
                break;
            }
            case Y: {
                int x1 = Math.min(pos1.getX(), pos2.getX());
                int x2 = Math.max(pos1.getX(), pos2.getX());
                int y = pos1.getY();
                int z1 = Math.min(pos1.getZ(), pos2.getZ());
                int z2 = Math.max(pos1.getZ(), pos2.getZ());
                int cxMin = x1 >> 4;
                int cxMax = x2 >> 4;
                int czMin = z1 >> 4;
                int czMax = z2 >> 4;
                for (int cz = czMin; cz <= czMax; ++cz) {
                    for (int cx = cxMin; cx <= cxMax; ++cx) {
                        LevelChunk chunk = world.getChunk(cx, cz);
                        if (y > fi.dy.masa.malilib.util.WorldUtils.getHighestSectionYOffset((ChunkAccess)chunk) + 15) continue;
                        int xMin = Math.max(x1, cx << 4);
                        int xMax = Math.min(x2, (cx << 4) + 15);
                        int zMin = Math.max(z1, cz << 4);
                        int zMax = Math.min(z2, (cz << 4) + 15);
                        for (int z = zMin; z <= zMax; ++z) {
                            for (int x = xMin; x <= xMax; ++x) {
                                if (chunk.getBlockState((BlockPos)posMutable.set(x, y, z)).isAir()) continue;
                                return false;
                            }
                        }
                    }
                }
                break;
            }
            case X: {
                int x = pos1.getX();
                int z1 = Math.min(pos1.getZ(), pos2.getZ());
                int z2 = Math.max(pos1.getZ(), pos2.getZ());
                int y1 = Math.min(pos1.getY(), pos2.getY());
                int y2 = Math.max(pos1.getY(), pos2.getY());
                int czMin = z1 >> 4;
                int czMax = z2 >> 4;
                for (int cz = czMin; cz <= czMax; ++cz) {
                    LevelChunk chunk = world.getChunk(x >> 4, cz);
                    int zMin = Math.max(z1, cz << 4);
                    int zMax = Math.min(z2, (cz << 4) + 15);
                    int yMax = Math.min(y2, fi.dy.masa.malilib.util.WorldUtils.getHighestSectionYOffset((ChunkAccess)chunk) + 15);
                    for (int z = zMin; z <= zMax; ++z) {
                        for (int y = y1; y <= yMax; ++y) {
                            if (chunk.getBlockState((BlockPos)posMutable.set(x, y, z)).isAir()) continue;
                            return false;
                        }
                    }
                }
                break;
            }
        }
        return true;
    }

    @Deprecated(forRemoval=true)
    private static boolean easyPlaceIsPositionCached(BlockPos pos) {
        long currentTime = System.nanoTime();
        boolean cached = false;
        for (int i = 0; i < EASY_PLACE_POSITIONS.size(); ++i) {
            PositionCache val = EASY_PLACE_POSITIONS.get(i);
            boolean expired = val.hasExpired(currentTime);
            if (expired) {
                EASY_PLACE_POSITIONS.remove(i);
                --i;
                continue;
            }
            if (!val.getPos().equals((Object)pos)) continue;
            cached = true;
            if (EASY_PLACE_POSITIONS.size() < 16) break;
        }
        return cached;
    }

    @Deprecated(forRemoval=true)
    private static void cacheEasyPlacePosition(BlockPos pos) {
        EASY_PLACE_POSITIONS.add(new PositionCache(pos, System.nanoTime(), 2000000000L));
    }

    @Deprecated(forRemoval=true)
    private static boolean easyPlaceIsTooFast() {
        return System.nanoTime() - easyPlaceLastPickBlockTime < 1000000L * (long)Configs.Generic.EASY_PLACE_SWAP_INTERVAL.getIntegerValue();
    }

    @Deprecated(forRemoval=true)
    public static void setEasyPlaceLastPickBlockTime() {
        easyPlaceLastPickBlockTime = System.nanoTime();
    }

    public static class PlacementProtocolData {
        boolean handled;
        boolean mustFail;
        BlockPos pos;
        Direction side;
        Vec3 hitVec;
    }

    @Deprecated(forRemoval=true)
    public static class PositionCache {
        private final BlockPos pos;
        private final long time;
        private final long timeout;

        private PositionCache(BlockPos pos, long time, long timeout) {
            this.pos = pos;
            this.time = time;
            this.timeout = timeout;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public boolean hasExpired(long currentTime) {
            return currentTime - this.time > this.timeout;
        }
    }
}

