/*
 * Decompiled with CFR 0.152.
 */
package decok.dfcdvadstf.createworldui.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.world.WorldSettings;

public class CreateWorldAPI {
    private static final List<IWorldTab> registeredTabs = new ArrayList<IWorldTab>();
    private static final Map<Class<?>, ITabCustomizer> customizers = new HashMap();

    public static void registerTab(IWorldTab tab) {
        registeredTabs.add(tab);
    }

    public static void registerTabCustomizer(Class<?> targetClass, ITabCustomizer customizer) {
        customizers.put(targetClass, customizer);
    }

    public static List<IWorldTab> getTabs() {
        return Collections.unmodifiableList(registeredTabs);
    }

    public static ITabCustomizer getCustomizer(Class<?> targetClass) {
        return customizers.get(targetClass);
    }

    public static interface ITabCustomizer {
        public void customize(List<GuiButton> var1);
    }

    public static interface IWorldTab {
        public String getTabName();

        public void initGui(GuiScreen var1, WorldSettings var2);

        public void drawScreen(int var1, int var2, float var3);

        public void actionPerformed(GuiButton var1) throws IOException;

        public void keyTyped(char var1, int var2) throws IOException;

        public void mouseClicked(int var1, int var2, int var3) throws IOException;

        public WorldSettings applySettings(WorldSettings var1);

        public int getTabOrder();
    }
}

