/*
 * Decompiled with CFR 0.152.
 */
package decok.dfcdvadstf.createworldui.mixin;

import decok.dfcdvadstf.createworldui.api.TabState;
import decok.dfcdvadstf.createworldui.api.TextureHelper;
import decok.dfcdvadstf.createworldui.gamerule.GameRuleEditor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiCreateWorld.class})
public abstract class ModernCreateWorld
extends GuiScreen {
    @Shadow
    private GuiScreen field_146332_f;
    @Shadow
    private boolean field_146337_w;
    @Shadow
    private String field_146330_J;
    @Shadow
    private String field_146342_r;
    @Shadow
    private String field_146329_I;
    @Shadow
    private boolean field_146341_s;
    @Shadow
    private boolean field_146338_v;
    @Shadow
    private boolean field_146340_t;
    @Shadow
    private GuiTextField field_146335_h;
    @Shadow
    private GuiTextField field_146333_g;
    @Shadow
    private GuiButton field_146321_E;
    @Shadow
    private GuiButton field_146343_z;
    @Shadow
    private GuiButton field_146326_C;
    @Shadow
    private GuiButton field_146320_D;
    @Shadow
    private GuiButton field_146325_B;
    @Shadow
    private GuiButton field_146322_F;
    @Shadow
    private int field_146331_K;
    @Unique
    private int modernWorldCreatingUI$currentTab = 100;
    @Unique
    private final List<GuiButton> modernWorldCreatingUI$tabButtons = new ArrayList<GuiButton>();
    @Unique
    private boolean modernWorldCreatingUI$isReorganizing = false;
    @Unique
    private final Map<Integer, GuiButton> modernWorldCreatingUI$tabControls = new HashMap<Integer, GuiButton>();
    @Unique
    private static final ResourceLocation OPTIONS_BG_LIGHT = new ResourceLocation("createworldui:textures/gui/options_background.png");
    @Unique
    private static final ResourceLocation OPTIONS_BG_DARK = new ResourceLocation("createworldui:textures/gui/options_background_dark.png");
    @Unique
    private static final ResourceLocation TABS_TEXTURE = new ResourceLocation("createworldui:textures/gui/tabs.png");
    @Unique
    private static final int TAB_WIDTH = 130;
    @Unique
    private static final int TAB_HEIGHT = 24;

    @Inject(method={"initGui"}, at={@At(value="HEAD")})
    private void onInitGuiHead(CallbackInfo ci) {
        this.modernWorldCreatingUI$preInit();
    }

    @Inject(method={"initGui"}, at={@At(value="TAIL")})
    private void onInitGuiTail(CallbackInfo ci) {
        this.modernWorldCreatingUI$reorganizeToTabLayout();
    }

    @Unique
    private void modernWorldCreatingUI$preInit() {
        this.modernWorldCreatingUI$ensureFieldsNotNull();
        this.modernWorldCreatingUI$isReorganizing = true;
    }

    @Unique
    private void modernWorldCreatingUI$ensureFieldsNotNull() {
        if (this.field_146330_J == null) {
            this.field_146330_J = "New World";
        }
        if (this.field_146329_I == null) {
            this.field_146329_I = "";
        }
        if (this.field_146342_r == null) {
            this.field_146342_r = "survival";
        }
        if (WorldType.worldTypes == null || this.field_146331_K >= WorldType.worldTypes.length || WorldType.worldTypes[this.field_146331_K] == null) {
            this.field_146331_K = 0;
        }
    }

    @Unique
    private void modernWorldCreatingUI$reorganizeToTabLayout() {
        List<GuiButton> essentialButtons = this.modernWorldCreatingUI$collectEssentialButtons();
        this.buttonList.clear();
        this.modernWorldCreatingUI$tabButtons.clear();
        this.buttonList.addAll(essentialButtons);
        this.modernWorldCreatingUI$createTabButtons();
        this.modernWorldCreatingUI$recreateFunctionalButtons();
        this.modernWorldCreatingUI$setupTextFields();
        this.modernWorldCreatingUI$updateButtonVisibility();
        this.modernWorldCreatingUI$repositionActionButtons();
        this.modernWorldCreatingUI$isReorganizing = false;
    }

    @Unique
    private List<GuiButton> modernWorldCreatingUI$collectEssentialButtons() {
        ArrayList<GuiButton> essentialButtons = new ArrayList<GuiButton>();
        for (GuiButton button : this.buttonList) {
            if (button.id != 0 && button.id != 1) continue;
            essentialButtons.add(button);
        }
        return essentialButtons;
    }

    @Unique
    private void modernWorldCreatingUI$recreateFunctionalButtons() {
        this.field_146343_z = new GuiButton(2, this.width / 2 - 100, 140, 200, 20, "");
        this.buttonList.add(this.field_146343_z);
        this.field_146325_B = new GuiButton(4, this.width / 2 - 100, 165, 200, 20, "");
        this.buttonList.add(this.field_146325_B);
        this.field_146326_C = new GuiButton(7, this.width / 2 - 100, 190, 200, 20, "");
        this.buttonList.add(this.field_146326_C);
        this.field_146320_D = new GuiButton(5, this.width / 2 - 100, 215, 200, 20, "");
        this.buttonList.add(this.field_146320_D);
        this.field_146321_E = new GuiButton(6, this.width / 2 - 100, 240, 200, 20, "");
        this.buttonList.add(this.field_146321_E);
        this.field_146322_F = new GuiButton(8, this.width / 2 - 100, 265, 200, 20, I18n.format((String)"selectWorld.customizeType", (Object[])new Object[0]));
        this.buttonList.add(this.field_146322_F);
        this.buttonList.add(new GuiButton(200, this.width / 2 - 100, 140, 200, 20, I18n.format((String)"createworldui.button.gameRuleEditor", (Object[])new Object[0])));
        this.modernWorldCreatingUI$updateButtonText();
    }

    @Unique
    private void modernWorldCreatingUI$setupTextFields() {
        if (this.field_146333_g != null) {
            this.field_146333_g.xPosition = this.width / 2 - 100;
            this.field_146333_g.yPosition = 40;
        } else {
            this.field_146333_g = new GuiTextField(this.fontRendererObj, this.width / 2 - 100, 40, 200, 20);
            this.field_146333_g.setText(this.field_146330_J);
        }
        if (this.field_146335_h != null) {
            this.field_146335_h.xPosition = this.width / 2 - 100;
            this.field_146335_h.yPosition = 100;
        } else {
            this.field_146335_h = new GuiTextField(this.fontRendererObj, this.width / 2 - 100, 100, 200, 20);
            this.field_146335_h.setText(this.field_146329_I);
        }
        this.field_146333_g.setFocused(true);
    }

    @Unique
    private void modernWorldCreatingUI$repositionActionButtons() {
        GuiButton createButton = this.modernWorldCreatingUI$getButtonById(0);
        GuiButton cancelButton = this.modernWorldCreatingUI$getButtonById(1);
        if (createButton != null) {
            createButton.xPosition = this.width / 2 - 155;
            createButton.yPosition = this.height - 28;
            createButton.width = 150;
            createButton.height = 20;
        }
        if (cancelButton != null) {
            cancelButton.xPosition = this.width / 2 + 5;
            cancelButton.yPosition = this.height - 28;
            cancelButton.width = 150;
            cancelButton.height = 20;
        }
    }

    @Unique
    private void modernWorldCreatingUI$createTabButtons() {
        this.modernWorldCreatingUI$tabButtons.clear();
        int xPos = this.width / 2 - 125;
        int yPos = 5;
        String[] tabNames = new String[]{I18n.format((String)"createworldui.tab.game", (Object[])new Object[0]), I18n.format((String)"createworldui.tab.world", (Object[])new Object[0]), I18n.format((String)"createworldui.tab.more", (Object[])new Object[0])};
        for (int i = 0; i < 3; ++i) {
            GuiButton tabButton = new GuiButton(100 + i, xPos, yPos, 130, 24, tabNames[i]){

                public void drawButton(Minecraft mc, int mouseX, int mouseY) {
                    if (this.visible) {
                        boolean isSelected;
                        mc.getTextureManager().bindTexture(TABS_TEXTURE);
                        boolean isHovered = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
                        boolean bl = isSelected = ModernCreateWorld.this.modernWorldCreatingUI$currentTab == this.id;
                        TabState state = isSelected ? (isHovered ? TabState.SELECTED_HOVER : TabState.SELECTED) : (isHovered ? TabState.HOVER : TabState.NORMAL);
                        this.drawTexturedModalRect(this.xPosition, this.yPosition, state.u, state.v, 130, 24);
                        this.drawCenteredString(mc.fontRenderer, this.displayString, this.xPosition + this.width / 2, this.yPosition + (this.height - 8) / 2, state.textColor);
                    }
                }
            };
            this.modernWorldCreatingUI$tabButtons.add(tabButton);
            this.buttonList.add(tabButton);
            xPos += 135;
        }
    }

    @Unique
    private void modernWorldCreatingUI$updateButtonText() {
        if (this.field_146342_r == null) {
            this.field_146342_r = "survival";
        }
        if (WorldType.worldTypes == null || this.field_146331_K >= WorldType.worldTypes.length || WorldType.worldTypes[this.field_146331_K] == null) {
            this.field_146331_K = 0;
        }
        this.field_146343_z.displayString = I18n.format((String)"selectWorld.gameMode", (Object[])new Object[0]) + " " + I18n.format((String)("selectWorld.gameMode." + this.field_146342_r), (Object[])new Object[0]);
        this.field_146325_B.displayString = I18n.format((String)"selectWorld.mapFeatures", (Object[])new Object[0]) + (this.field_146341_s ? I18n.format((String)"options.on", (Object[])new Object[0]) : I18n.format((String)"options.off", (Object[])new Object[0]));
        this.field_146326_C.displayString = I18n.format((String)"selectWorld.bonusItems", (Object[])new Object[0]) + (this.field_146338_v && !this.field_146337_w ? I18n.format((String)"options.on", (Object[])new Object[0]) : I18n.format((String)"options.off", (Object[])new Object[0]));
        this.field_146320_D.displayString = I18n.format((String)"selectWorld.mapType", (Object[])new Object[0]) + I18n.format((String)WorldType.worldTypes[this.field_146331_K].getTranslateName(), (Object[])new Object[0]);
        this.field_146321_E.displayString = I18n.format((String)"selectWorld.allowCommands", (Object[])new Object[0]) + (this.field_146340_t && !this.field_146337_w ? I18n.format((String)"options.on", (Object[])new Object[0]) : I18n.format((String)"options.off", (Object[])new Object[0]));
    }

    @Unique
    private void modernWorldCreatingUI$updateButtonVisibility() {
        switch (this.modernWorldCreatingUI$currentTab) {
            case 100: {
                this.field_146343_z.visible = true;
                this.field_146321_E.visible = true;
                this.field_146325_B.visible = false;
                this.field_146326_C.visible = false;
                this.field_146320_D.visible = false;
                this.field_146322_F.visible = false;
                this.modernWorldCreatingUI$getButtonById((int)200).visible = false;
                break;
            }
            case 101: {
                this.field_146343_z.visible = false;
                this.field_146321_E.visible = false;
                this.field_146325_B.visible = true;
                this.field_146326_C.visible = true;
                this.field_146320_D.visible = true;
                this.field_146322_F.visible = WorldType.worldTypes[this.field_146331_K].isCustomizable();
                this.modernWorldCreatingUI$getButtonById((int)200).visible = false;
                break;
            }
            case 102: {
                this.field_146343_z.visible = false;
                this.field_146321_E.visible = false;
                this.field_146325_B.visible = false;
                this.field_146326_C.visible = false;
                this.field_146320_D.visible = false;
                this.field_146322_F.visible = false;
                this.modernWorldCreatingUI$getButtonById((int)200).visible = true;
            }
        }
        this.modernWorldCreatingUI$updateButtonText();
    }

    @Overwrite
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        String tabTitle;
        TextureHelper.drawModalRectWithCustomSizedTexture(OPTIONS_BG_LIGHT, 0, 0, 16.0f, 16.0f, this.width, this.height, 16.0f, 16.0f);
        this.mc.getTextureManager().bindTexture(OPTIONS_BG_DARK);
        this.drawCenteredString(this.fontRendererObj, I18n.format((String)"selectWorld.create", (Object[])new Object[0]), this.width / 2, 15, 0xFFFFFF);
        if (this.modernWorldCreatingUI$currentTab == 100) {
            this.drawString(this.fontRendererObj, I18n.format((String)"selectWorld.enterName", (Object[])new Object[0]), this.width / 2 - 100, 27, 0xA0A0A0);
            this.field_146333_g.drawTextBox();
        } else {
            this.drawString(this.fontRendererObj, I18n.format((String)"selectWorld.enterSeed", (Object[])new Object[0]), this.width / 2 - 100, 87, 0xA0A0A0);
            this.field_146335_h.drawTextBox();
        }
        switch (this.modernWorldCreatingUI$currentTab) {
            case 100: {
                tabTitle = I18n.format((String)"createworldui.tab.game", (Object[])new Object[0]);
                break;
            }
            case 101: {
                tabTitle = I18n.format((String)"createworldui.tab.world", (Object[])new Object[0]);
                break;
            }
            case 102: {
                tabTitle = I18n.format((String)"createworldui.tab.more", (Object[])new Object[0]);
                break;
            }
            default: {
                tabTitle = "";
            }
        }
        this.drawCenteredString(this.fontRendererObj, tabTitle, this.width / 2, 120, 0xFFFFFF);
        super.drawScreen(mouseX, mouseY, partialTicks);
    }

    @Inject(method={"actionPerformed"}, at={@At(value="HEAD")}, cancellable=true)
    private void onActionPerformed(GuiButton button, CallbackInfo ci) {
        if (button.id >= 100 && button.id <= 102) {
            this.modernWorldCreatingUI$currentTab = button.id;
            this.modernWorldCreatingUI$updateButtonVisibility();
            ci.cancel();
            return;
        }
        if (button.id == 200) {
            this.mc.displayGuiScreen((GuiScreen)new GameRuleEditor(null));
            ci.cancel();
            return;
        }
        if (button.id == 5) {
            this.modernWorldCreatingUI$handleWorldTypeSelection();
            ci.cancel();
            return;
        }
        if (button.id == 2 || button.id == 4 || button.id == 5 || button.id == 6 || button.id == 7) {
            this.modernWorldCreatingUI$scheduleButtonTextUpdate();
        }
    }

    @Unique
    private void modernWorldCreatingUI$handleWorldTypeSelection() {
        do {
            this.field_146331_K = (this.field_146331_K + 1) % WorldType.worldTypes.length;
        } while (WorldType.worldTypes[this.field_146331_K] == null);
        this.modernWorldCreatingUI$updateButtonText();
        this.modernWorldCreatingUI$updateButtonVisibility();
    }

    @Unique
    private void modernWorldCreatingUI$scheduleButtonTextUpdate() {
        Runnable updateTask = new Runnable(){

            @Override
            public void run() {
                ModernCreateWorld.this.modernWorldCreatingUI$updateButtonText();
            }
        };
        Minecraft.getMinecraft().func_152344_a(updateTask);
    }

    protected void keyTyped(char typedChar, int keyCode) {
        if (this.modernWorldCreatingUI$currentTab == 100) {
            this.field_146333_g.textboxKeyTyped(typedChar, keyCode);
            this.field_146330_J = this.field_146333_g.getText();
        } else {
            this.field_146335_h.textboxKeyTyped(typedChar, keyCode);
            this.field_146329_I = this.field_146335_h.getText();
        }
        if (keyCode == 1) {
            this.mc.displayGuiScreen(this.field_146332_f);
        }
        ((GuiButton)this.buttonList.get((int)2)).enabled = this.field_146333_g.getText().length() > 0;
        this.func_146314_g();
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.modernWorldCreatingUI$currentTab == 100) {
            this.field_146333_g.mouseClicked(mouseX, mouseY, mouseButton);
        } else {
            this.field_146335_h.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    @Unique
    private GuiButton modernWorldCreatingUI$getButtonById(int id) {
        for (Object obj : this.buttonList) {
            if (!(obj instanceof GuiButton)) continue;
            GuiButton button = (GuiButton)obj;
            if (button.id != id) continue;
            return button;
        }
        return null;
    }

    @Shadow
    private void func_146314_g() {
    }

    @Shadow
    private void func_146319_h() {
    }
}

