/*
 * Decompiled with CFR 0.152.
 */
package decok.dfcdvadstf.createworldui.gamerule;

import decok.dfcdvadstf.createworldui.gamerule.GameRuleMonitorNSetter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GameRuleEditor
extends GuiScreen {
    private static final Logger LOGGER = LogManager.getLogger((String)"GameRuleEditor");
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("textures/gui/options_background.png");
    private World world;
    private Map<String, GameRuleMonitorNSetter.GameruleValue> originalRules;
    private final Map<String, Object> modifiedRules = new HashMap<String, Object>();
    private final Map<String, GuiComponentWrapper> ruleComponents = new HashMap<String, GuiComponentWrapper>();
    private GuiButton saveButton;
    private GuiButton cancelButton;
    private GuiButton resetButton;
    private int scrollOffset = 0;
    private int maxScrollOffset = 0;
    private static final int ROW_HEIGHT = 25;
    private static final int VISIBLE_ROWS = 8;
    private boolean isScrolling = false;

    public GameRuleEditor(World world) {
        this.world = world;
        this.originalRules = GameRuleMonitorNSetter.getAllGamerules(world);
        this.maxScrollOffset = Math.max(0, this.originalRules.size() - 8);
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.saveButton = new GuiButton(0, this.field_146294_l / 2 - 154, this.field_146295_m - 30, 100, 20, I18n.func_135052_a((String)"options.save", (Object[])new Object[0]));
        this.cancelButton = new GuiButton(1, this.field_146294_l / 2 - 50, this.field_146295_m - 30, 100, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]));
        this.resetButton = new GuiButton(2, this.field_146294_l / 2 + 54, this.field_146295_m - 30, 100, 20, I18n.func_135052_a((String)"options.reset", (Object[])new Object[0]));
        this.field_146292_n.add(this.saveButton);
        this.field_146292_n.add(this.cancelButton);
        this.field_146292_n.add(this.resetButton);
        this.createRuleComponents();
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private void createRuleComponents() {
        this.ruleComponents.clear();
        int yPos = 60;
        int index = 0;
        for (Map.Entry<String, GameRuleMonitorNSetter.GameruleValue> entry : this.originalRules.entrySet()) {
            int componentY;
            GameRuleMonitorNSetter.GameruleValue value;
            Object optimalValue;
            String ruleName;
            GuiComponentWrapper component;
            if (index >= this.scrollOffset && index < this.scrollOffset + 8 && (component = this.createComponentForRule(ruleName = entry.getKey(), optimalValue = (value = entry.getValue()).getOptimalValue(), componentY = yPos + (index - this.scrollOffset) * 25)) != null) {
                this.ruleComponents.put(ruleName, component);
                if (component.type == ComponentType.BOOLEAN_BUTTON) {
                    ((GuiButton)component.component).field_146127_k = 100 + index;
                }
            }
            ++index;
        }
    }

    private GuiComponentWrapper createComponentForRule(String ruleName, Object value, int yPos) {
        int componentWidth = 150;
        int componentX = this.field_146294_l / 2 + 20;
        if (value instanceof Boolean) {
            boolean boolValue = (Boolean)value;
            String buttonText = boolValue ? I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.off", (Object[])new Object[0]);
            GuiButton button = new GuiButton(0, componentX, yPos, componentWidth, 20, buttonText);
            return new GuiComponentWrapper(button, ComponentType.BOOLEAN_BUTTON);
        }
        GuiTextField textField = new GuiTextField(this.field_146289_q, componentX, yPos, componentWidth, 20);
        textField.func_146180_a(String.valueOf(value));
        textField.func_146203_f(50);
        return new GuiComponentWrapper(textField, ComponentType.TEXT_FIELD);
    }

    protected void func_146284_a(GuiButton button) {
        int ruleIndex;
        String ruleName;
        if (button == this.saveButton) {
            this.saveChanges();
            this.field_146297_k.func_147108_a(null);
        } else if (button == this.cancelButton) {
            this.field_146297_k.func_147108_a(null);
        } else if (button == this.resetButton) {
            this.resetToDefaults();
        } else if (button.field_146127_k >= 100 && (ruleName = this.getRuleNameByIndex(ruleIndex = button.field_146127_k - 100)) != null) {
            this.toggleBooleanRule(ruleName, button);
        }
    }

    private String getRuleNameByIndex(int index) {
        if (index < 0 || index >= this.originalRules.size()) {
            return null;
        }
        int i = 0;
        for (String ruleName : this.originalRules.keySet()) {
            if (i == index) {
                return ruleName;
            }
            ++i;
        }
        return null;
    }

    private void toggleBooleanRule(String ruleName, GuiButton button) {
        Object currentValue = this.modifiedRules.get(ruleName);
        if (currentValue == null) {
            currentValue = this.originalRules.get(ruleName).getOptimalValue();
        }
        boolean newValue = (Boolean)currentValue == false;
        this.modifiedRules.put(ruleName, newValue);
        button.field_146126_j = newValue ? I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.off", (Object[])new Object[0]);
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        super.func_73869_a(typedChar, keyCode);
        for (Map.Entry<String, GuiComponentWrapper> entry : this.ruleComponents.entrySet()) {
            GuiComponentWrapper wrapper = entry.getValue();
            if (wrapper.type != ComponentType.TEXT_FIELD) continue;
            GuiTextField textField = (GuiTextField)wrapper.component;
            textField.func_146201_a(typedChar, keyCode);
            if (keyCode != 28) continue;
            String newValue = textField.func_146179_b();
            String ruleName = entry.getKey();
            Object parsedValue = this.parseValue(newValue, this.originalRules.get(ruleName).getOptimalValue());
            this.modifiedRules.put(ruleName, parsedValue);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (GuiComponentWrapper wrapper : this.ruleComponents.values()) {
            if (wrapper.type != ComponentType.TEXT_FIELD) continue;
            GuiTextField textField = (GuiTextField)wrapper.component;
            textField.func_146192_a(mouseX, mouseY, mouseButton);
        }
        int scrollBarX = this.field_146294_l / 2 - 10;
        int scrollBarY = 60;
        int scrollBarHeight = 200;
        if (mouseX >= scrollBarX && mouseX <= scrollBarX + 10 && mouseY >= scrollBarY && mouseY <= scrollBarY + scrollBarHeight) {
            this.isScrolling = true;
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (state == 0 || state == 1) {
            this.isScrolling = false;
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        if (this.isScrolling) {
            int scrollBarY = 60;
            int scrollBarHeight = 200;
            float relativePosition = (float)(mouseY - scrollBarY) / (float)scrollBarHeight;
            this.scrollOffset = (int)(relativePosition * (float)this.maxScrollOffset);
            this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScrollOffset));
            this.createRuleComponents();
        } else if (Mouse.getEventDWheel() != 0) {
            int scrollAmount = Mouse.getEventDWheel() > 0 ? -1 : 1;
            this.scrollOffset += scrollAmount;
            this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScrollOffset));
            this.createRuleComponents();
        }
    }

    public void func_73876_c() {
        for (GuiComponentWrapper wrapper : this.ruleComponents.values()) {
            if (wrapper.type != ComponentType.TEXT_FIELD) continue;
            GuiTextField textField = (GuiTextField)wrapper.component;
            textField.func_146178_a();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146278_c(0);
        this.drawContentPanel();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"createWorld.customize.custom.gamerules", (Object[])new Object[0]), this.field_146294_l / 2, 20, 0xFFFFFF);
        this.drawRuleList(mouseX, mouseY);
        for (GuiComponentWrapper wrapper : this.ruleComponents.values()) {
            if (wrapper.type == ComponentType.TEXT_FIELD) {
                GuiTextField textField = (GuiTextField)wrapper.component;
                textField.func_146194_f();
                continue;
            }
            if (wrapper.type != ComponentType.BOOLEAN_BUTTON) continue;
            GuiButton button = (GuiButton)wrapper.component;
            button.func_146112_a(this.field_146297_k, mouseX, mouseY);
        }
        this.drawScrollBar();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawTooltips(mouseX, mouseY);
    }

    private void drawContentPanel() {
        int panelWidth = this.field_146294_l - 100;
        int panelHeight = this.field_146295_m - 100;
        int panelX = 50;
        int panelY = 40;
        GameRuleEditor.func_73734_a((int)panelX, (int)panelY, (int)(panelX + panelWidth), (int)(panelY + panelHeight), (int)-1440603614);
        GameRuleEditor.func_73734_a((int)(panelX - 1), (int)(panelY - 1), (int)(panelX + panelWidth + 1), (int)panelY, (int)-11184811);
        GameRuleEditor.func_73734_a((int)(panelX - 1), (int)(panelY + panelHeight), (int)(panelX + panelWidth + 1), (int)(panelY + panelHeight + 1), (int)-11184811);
        GameRuleEditor.func_73734_a((int)(panelX - 1), (int)panelY, (int)panelX, (int)(panelY + panelHeight), (int)-11184811);
        GameRuleEditor.func_73734_a((int)(panelX + panelWidth), (int)panelY, (int)(panelX + panelWidth + 1), (int)(panelY + panelHeight), (int)-11184811);
        GameRuleEditor.func_73734_a((int)panelX, (int)panelY, (int)(panelX + panelWidth), (int)(panelY + 20), (int)-1438366652);
        GameRuleEditor.func_73734_a((int)panelX, (int)(panelY + 20), (int)(panelX + panelWidth), (int)(panelY + 21), (int)-10066330);
    }

    private void drawRuleList(int mouseX, int mouseY) {
        int index = 0;
        int yPos = 60;
        for (Map.Entry<String, GameRuleMonitorNSetter.GameruleValue> entry : this.originalRules.entrySet()) {
            if (index >= this.scrollOffset && index < this.scrollOffset + 8) {
                String ruleName = entry.getKey();
                GameRuleMonitorNSetter.GameruleValue originalValue = entry.getValue();
                Object currentValue = this.modifiedRules.get(ruleName);
                if (currentValue == null) {
                    currentValue = originalValue.getOptimalValue();
                }
                int rowY = yPos + (index - this.scrollOffset) * 25;
                this.func_73731_b(this.field_146289_q, ruleName, this.field_146294_l / 2 - 150, rowY + 6, 0xFFFFFF);
                String defaultValueText = I18n.func_135052_a((String)"createWorld.customize.custom.default", (Object[])new Object[0]) + ": " + originalValue.getOptimalValue();
                this.func_73731_b(this.field_146289_q, defaultValueText, this.field_146294_l / 2 - 150, rowY + 16, 0x888888);
            }
            ++index;
        }
    }

    private void drawScrollBar() {
        if (this.maxScrollOffset > 0) {
            int scrollBarX = this.field_146294_l / 2 - 10;
            int scrollBarY = 60;
            int scrollBarHeight = 200;
            GameRuleEditor.func_73734_a((int)scrollBarX, (int)scrollBarY, (int)(scrollBarX + 10), (int)(scrollBarY + scrollBarHeight), (int)-1439485133);
            GameRuleEditor.func_73734_a((int)(scrollBarX + 1), (int)(scrollBarY + 1), (int)(scrollBarX + 9), (int)(scrollBarY + scrollBarHeight - 1), (int)-1437248171);
            float scrollPercentage = (float)this.scrollOffset / (float)this.maxScrollOffset;
            int sliderHeight = Math.max(20, scrollBarHeight / (this.maxScrollOffset + 8) * 8);
            int sliderY = scrollBarY + (int)(scrollPercentage * (float)(scrollBarHeight - sliderHeight));
            GameRuleEditor.func_73734_a((int)(scrollBarX + 2), (int)sliderY, (int)(scrollBarX + 8), (int)(sliderY + sliderHeight), (int)-7829368);
            GameRuleEditor.func_73734_a((int)(scrollBarX + 2), (int)sliderY, (int)(scrollBarX + 8), (int)(sliderY + sliderHeight - 1), (int)-5592406);
        }
    }

    private void drawTooltips(int mouseX, int mouseY) {
        int index = 0;
        int yPos = 60;
        for (String ruleName : this.originalRules.keySet()) {
            String tooltip;
            int rowY;
            if (index >= this.scrollOffset && index < this.scrollOffset + 8 && this.isMouseOverRuleName(mouseX, mouseY, rowY = yPos + (index - this.scrollOffset) * 25) && (tooltip = this.getRuleTooltip(ruleName)) != null) {
                List<String> tooltipList = Arrays.asList(tooltip);
                this.func_146283_a(tooltipList, mouseX, mouseY);
            }
            ++index;
        }
    }

    private boolean isMouseOverRuleName(int mouseX, int mouseY, int rowY) {
        return mouseX >= this.field_146294_l / 2 - 150 && mouseX <= this.field_146294_l / 2 - 20 && mouseY >= rowY && mouseY <= rowY + 25;
    }

    private String getRuleTooltip(String ruleName) {
        String translationKey = "gamerule." + ruleName + ".description";
        String translated = I18n.func_135052_a((String)translationKey, (Object[])new Object[0]);
        if (translated.equals(translationKey)) {
            HashMap<String, String> defaultDescriptions = new HashMap<String, String>();
            defaultDescriptions.put("doFireTick", "Controls whether fire spreads and naturally extinguishes");
            defaultDescriptions.put("mobGriefing", "Controls whether mobs can destroy blocks");
            defaultDescriptions.put("keepInventory", "Keep inventory after death");
            defaultDescriptions.put("doMobSpawning", "Natural mob spawning");
            defaultDescriptions.put("doMobLoot", "Mobs drop loot");
            defaultDescriptions.put("doTileDrops", "Blocks drop items when destroyed");
            defaultDescriptions.put("doEntityDrops", "Entities drop items");
            defaultDescriptions.put("commandBlockOutput", "Command blocks output to chat");
            defaultDescriptions.put("naturalRegeneration", "Natural health regeneration");
            defaultDescriptions.put("doDaylightCycle", "Day/night cycle");
            defaultDescriptions.put("logAdminCommands", "Log admin commands to server log");
            defaultDescriptions.put("showDeathMessages", "Show death messages in chat");
            defaultDescriptions.put("randomTickSpeed", "Random tick speed (plant growth, etc.)");
            defaultDescriptions.put("sendCommandFeedback", "Show command execution feedback");
            defaultDescriptions.put("reducedDebugInfo", "Reduce debug screen information");
            return (String)defaultDescriptions.get(ruleName);
        }
        return translated;
    }

    private Object parseValue(String textValue, Object originalValue) {
        if (originalValue instanceof Boolean) {
            return Boolean.parseBoolean(textValue);
        }
        if (originalValue instanceof Integer) {
            try {
                return Integer.parseInt(textValue);
            }
            catch (NumberFormatException e) {
                return originalValue;
            }
        }
        if (originalValue instanceof Double) {
            try {
                return Double.parseDouble(textValue);
            }
            catch (NumberFormatException e) {
                return originalValue;
            }
        }
        return textValue;
    }

    private void saveChanges() {
        for (Map.Entry<String, Object> entry : this.modifiedRules.entrySet()) {
            Object value;
            String ruleName = entry.getKey();
            boolean success = GameRuleMonitorNSetter.setGamerule(this.world, ruleName, value = entry.getValue());
            if (success) {
                LOGGER.info("Successfully set game rule {} to {}", new Object[]{ruleName, value});
                continue;
            }
            LOGGER.warn("Failed to set game rule {}", new Object[]{ruleName});
        }
    }

    private void resetToDefaults() {
        this.modifiedRules.clear();
        this.createRuleComponents();
    }

    private static enum ComponentType {
        BOOLEAN_BUTTON,
        TEXT_FIELD;

    }

    private static class GuiComponentWrapper {
        public final Object component;
        public final ComponentType type;

        public GuiComponentWrapper(Object component, ComponentType type) {
            this.component = component;
            this.type = type;
        }
    }
}

