/*
 * Decompiled with CFR 0.152.
 */
package decok.dfcdvadstf.createworldui.gamerule;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GameRuleMonitorNSetter {
    private static final Logger LOGGER = LogManager.getLogger((String)"GameruleMonitorAndSetter");

    public static Map<String, GameruleValue> getAllGamerules(World world) {
        String[] ruleNames;
        HashMap<String, GameruleValue> gamerules = new HashMap<String, GameruleValue>();
        if (world == null) {
            LOGGER.warn("World object is null, returning empty gamerule map");
            return gamerules;
        }
        GameRules gameRules = world.func_82736_K();
        for (String ruleName : ruleNames = gameRules.func_82763_b()) {
            GameruleValue value = GameRuleMonitorNSetter.getGamerule(world, ruleName);
            if (value == null) continue;
            gamerules.put(ruleName, value);
        }
        LOGGER.debug("Retrieved {} gamerules from world", new Object[]{gamerules.size()});
        return gamerules;
    }

    public static GameruleValue getGamerule(World world, String ruleName) {
        if (world == null) {
            LOGGER.warn("World object is null, cannot get gamerule: {}", new Object[]{ruleName});
            return null;
        }
        if (!world.func_82736_K().func_82765_e(ruleName)) {
            LOGGER.debug("Gamerule does not exist: {}", new Object[]{ruleName});
            return null;
        }
        GameRules gameRules = world.func_82736_K();
        String stringValue = gameRules.func_82767_a(ruleName);
        boolean booleanValue = gameRules.func_82766_b(ruleName);
        int intValue = 0;
        double doubleValue = 0.0;
        try {
            Field field = GameRules.class.getDeclaredField("theGameRules");
            field.setAccessible(true);
            TreeMap rulesMap = (TreeMap)field.get(gameRules);
            Object valueObj = rulesMap.get(ruleName);
            if (valueObj != null) {
                Field intField = valueObj.getClass().getDeclaredField("valueInteger");
                Field doubleField = valueObj.getClass().getDeclaredField("valueDouble");
                intField.setAccessible(true);
                doubleField.setAccessible(true);
                intValue = intField.getInt(valueObj);
                doubleValue = doubleField.getDouble(valueObj);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to retrieve numeric values for gamerule {} via reflection: {}", new Object[]{ruleName, e.getMessage()});
            try {
                intValue = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                doubleValue = Double.parseDouble(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new GameruleValue(stringValue, booleanValue, intValue, doubleValue);
    }

    public static boolean setGamerule(World world, String ruleName, Object value) {
        if (world == null) {
            LOGGER.warn("World object is null, cannot set gamerule: {}", new Object[]{ruleName});
            return false;
        }
        try {
            String stringValue = value instanceof Boolean ? value.toString() : (value instanceof Integer ? value.toString() : (value instanceof Double ? value.toString() : (value instanceof String ? (String)value : String.valueOf(value))));
            world.func_82736_K().func_82764_b(ruleName, stringValue);
            LOGGER.debug("Successfully set gamerule {} to value: {}", new Object[]{ruleName, stringValue});
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to set gamerule {} to value {}: {}", new Object[]{ruleName, value, e.getMessage()});
            return false;
        }
    }

    public static boolean addGamerule(World world, String ruleName, Object defaultValue) {
        if (world == null) {
            LOGGER.warn("World object is null, cannot add gamerule: {}", new Object[]{ruleName});
            return false;
        }
        if (world.func_82736_K().func_82765_e(ruleName)) {
            LOGGER.debug("Gamerule already exists: {}", new Object[]{ruleName});
            return false;
        }
        try {
            String stringValue = String.valueOf(defaultValue);
            world.func_82736_K().func_82769_a(ruleName, stringValue);
            LOGGER.debug("Successfully added new gamerule {} with default value: {}", new Object[]{ruleName, stringValue});
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to add gamerule {} with default value {}: {}", new Object[]{ruleName, defaultValue, e.getMessage()});
            return false;
        }
    }

    public static boolean hasGamerule(World world, String ruleName) {
        boolean exists = world != null && world.func_82736_K().func_82765_e(ruleName);
        LOGGER.debug("Gamerule {} exists: {}", new Object[]{ruleName, exists});
        return exists;
    }

    public static Map<String, Object> getOptimalGameruleValues(World world) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, GameruleValue> allGamerules = GameRuleMonitorNSetter.getAllGamerules(world);
        for (Map.Entry<String, GameruleValue> entry : allGamerules.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getOptimalValue());
        }
        LOGGER.debug("Retrieved optimal values for {} gamerules", new Object[]{result.size()});
        return result;
    }

    public static void logAllGamerules(World world) {
        Map<String, GameruleValue> gamerules = GameRuleMonitorNSetter.getAllGamerules(world);
        LOGGER.info("=== All Game Rules (Complete Information) ===");
        for (Map.Entry<String, GameruleValue> entry : gamerules.entrySet()) {
            LOGGER.info("{}: {}", new Object[]{entry.getKey(), entry.getValue()});
        }
        LOGGER.info("=============================================");
        LOGGER.info("=== All Game Rules (Optimal Types) ===");
        Map<String, Object> optimalValues = GameRuleMonitorNSetter.getOptimalGameruleValues(world);
        for (Map.Entry<String, Object> entry : optimalValues.entrySet()) {
            LOGGER.info("{}: {} ({})", new Object[]{entry.getKey(), entry.getValue(), entry.getValue().getClass().getSimpleName()});
        }
        LOGGER.info("======================================");
    }

    public static class GameruleValue {
        public final String stringValue;
        public final boolean booleanValue;
        public final int intValue;
        public final double doubleValue;

        public GameruleValue(String stringValue, boolean booleanValue, int intValue, double doubleValue) {
            this.stringValue = stringValue;
            this.booleanValue = booleanValue;
            this.intValue = intValue;
            this.doubleValue = doubleValue;
        }

        public String toString() {
            return String.format("String: %s, Boolean: %b, Int: %d, Double: %.2f", this.stringValue, this.booleanValue, this.intValue, this.doubleValue);
        }

        public Object getOptimalValue() {
            if (this.stringValue.matches("-?\\d+")) {
                return this.intValue;
            }
            if (this.stringValue.matches("-?\\d+\\.\\d+")) {
                return this.doubleValue;
            }
            if ("true".equalsIgnoreCase(this.stringValue) || "false".equalsIgnoreCase(this.stringValue)) {
                return this.booleanValue;
            }
            return this.stringValue;
        }
    }
}

