/*
 * Decompiled with CFR 0.152.
 */
package decok.dfcdvadstf.createworldui;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import decok.dfcdvadstf.createworldui.tabbyui.GuiCreateWorldModern;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Logger;

@Mod(modid="createworldui", name="CreateWorldUI", version="0.0.1")
public class CreateWorldUI {
    private static Logger logger;
    private static final boolean FORCE_MODERN_UI = true;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        logger.info("Initializing CreateWorldUI Mod");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        logger.info("CreateWorldUI Mod loaded successfully");
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.gui instanceof GuiCreateWorld) {
            logger.info("Detected GuiCreateWorld opening");
            if (this.shouldUseModernUI()) {
                logger.info("Using modern world creation UI");
                GuiScreen parentScreen = this.getParentScreen((GuiCreateWorld)event.gui);
                event.gui = new GuiCreateWorldModern(parentScreen);
            } else {
                logger.info("Using vanilla world creation UI");
            }
        }
    }

    private boolean shouldUseModernUI() {
        logger.info("DEBUG MODE: Forcing modern UI");
        return true;
    }

    private GuiScreen getParentScreen(GuiCreateWorld gui) {
        try {
            Field parentField = GuiCreateWorld.class.getDeclaredField("parentScreen");
            parentField.setAccessible(true);
            return (GuiScreen)parentField.get(gui);
        }
        catch (Exception e) {
            logger.error("Failed to get parent screen from GuiCreateWorld", (Throwable)e);
            return Minecraft.getMinecraft().currentScreen;
        }
    }
}

