/*
 * Decompiled with CFR 0.152.
 */
package decok.dfcdvadstf.createworldui.api.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;

public class TexturedButton
extends GuiButton {
    private final ResourceLocation texture;
    private final int texU;
    private final int texV;
    private final int hoverU;
    private final int hoverV;

    public TexturedButton(int id, int x, int y, String text, ResourceLocation texture, int texU, int texV, int hoverU, int hoverV) {
        super(id, x, y, 100, 20, text);
        this.texture = texture;
        this.texU = texU;
        this.texV = texV;
        this.hoverU = hoverU;
        this.hoverV = hoverV;
    }

    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        if (this.visible) {
            boolean isHovered;
            mc.getTextureManager().bindTexture(this.texture);
            boolean bl = isHovered = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
            if (isHovered) {
                this.drawTexturedModalRect(this.xPosition, this.yPosition, this.hoverU, this.hoverV, this.width, this.height);
            } else {
                this.drawTexturedModalRect(this.xPosition, this.yPosition, this.texU, this.texV, this.width, this.height);
            }
            int color = isHovered ? 0xFFFFA0 : 0xE0E0E0;
            this.drawCenteredString(mc.fontRenderer, this.displayString, this.xPosition + this.width / 2, this.yPosition + (this.height - 8) / 2, color);
        }
    }
}

