/*
 * Decompiled with CFR 0.152.
 */
package decok.dfcdvadstf.createworldui.tabbyui;

import decok.dfcdvadstf.createworldui.api.CreateWorldAPI;
import decok.dfcdvadstf.createworldui.api.util.TextureHelper;
import decok.dfcdvadstf.createworldui.api.util.TextureManager;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;

public class GuiCreateWorldModern
extends GuiScreen {
    private final GuiScreen parentScreen;
    private WorldSettings worldSettings;
    private GuiTextField worldNameField;
    private String seedText;
    private GuiTextField seedField;
    private CreateWorldAPI.IWorldTab currentTab;
    private final List<GuiButton> tabButtons = new ArrayList<GuiButton>();
    private static Logger logger;
    private WorldSettings.GameType selectedGameType = WorldSettings.GameType.SURVIVAL;
    private WorldType selectedWorldType = WorldType.DEFAULT;
    private boolean spawnAnimals = true;
    private boolean spawnMonsters = true;
    private boolean weatherCycle = true;
    private boolean daylightCycle = true;
    private boolean allowCommands = false;
    private boolean mapFeaturesEnabled = true;
    private boolean bonusChestEnabled = false;
    private int difficulty = 2;
    private static final Logger LOGGER;
    private final List<CreateWorldAPI.IWorldTab> defaultTabs = new ArrayList<CreateWorldAPI.IWorldTab>();
    private static final ResourceLocation OPTIONS_BG_LIGHT;
    private static final ResourceLocation OPTIONS_BG_DARK;

    public GuiCreateWorldModern(GuiScreen parent) {
        this.parentScreen = parent;
        this.worldSettings = new WorldSettings(0L, WorldSettings.GameType.SURVIVAL, true, false, WorldType.DEFAULT);
        this.seedText = "";
        this.defaultTabs.add(new GameTab());
        this.defaultTabs.add(new WorldTab());
        this.defaultTabs.add(new MoreTab());
    }

    private void addButtonSafely(GuiButton button) {
        this.buttonList.add(button);
    }

    public void initGui() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonList.clear();
        this.tabButtons.clear();
        this.createTabButtons();
        if (this.currentTab == null) {
            this.currentTab = this.defaultTabs.get(0);
        }
        this.currentTab.initGui(this, this.worldSettings);
        this.worldNameField = new GuiTextField(this.fontRendererObj, this.width / 2 - 100, 40, 200, 20);
        this.worldNameField.setFocused(true);
        this.worldNameField.setText(I18n.format((String)"selectWorld.newWorld", (Object[])new Object[0]));
        this.buttonList.add(new GuiButton(0, this.width / 2 - 155, this.height - 28, 150, 20, I18n.format((String)"gui.create", (Object[])new Object[0])));
        this.buttonList.add(new GuiButton(1, this.width / 2 + 5, this.height - 28, 150, 20, I18n.format((String)"gui.cancel", (Object[])new Object[0])));
    }

    private void createTabButtons() {
        this.tabButtons.clear();
        int xPos = this.width / 2 - 150;
        int yPos = 5;
        List<CreateWorldAPI.IWorldTab> allTabs = this.getAllTabs();
        for (int i = 0; i < allTabs.size(); ++i) {
            CreateWorldAPI.IWorldTab tab = allTabs.get(i);
            final int tabIndex = i;
            GuiButton tabButton = new GuiButton(1000 + i, xPos, yPos, 130, 24, tab.getTabName()){

                public void drawButton(Minecraft mc, int mouseX, int mouseY) {
                    if (this.visible) {
                        mc.getTextureManager().bindTexture(TextureManager.TABS);
                        boolean isHovered = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
                        boolean isSelected = GuiCreateWorldModern.this.currentTab != null && GuiCreateWorldModern.this.getAllTabs().indexOf(GuiCreateWorldModern.this.currentTab) == tabIndex;
                        TabState state = TabState.getState(isSelected, isHovered);
                        this.drawTexturedModalRect(this.xPosition, this.yPosition, state.u, state.v, this.width, this.height);
                        this.drawCenteredString(mc.fontRenderer, this.displayString, this.xPosition + this.width / 2, this.yPosition + (this.height - 8) / 2, state.textColor);
                    }
                }
            };
            this.tabButtons.add(tabButton);
            this.addButtonSafely(tabButton);
            xPos += 135;
        }
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        this.mc.getTextureManager().bindTexture(OPTIONS_BG_LIGHT);
        TextureHelper.drawModalRectWithCustomSizedTexture(0, 0, 0, 0, this.width, this.height, this.width, this.height);
        this.mc.getTextureManager().bindTexture(OPTIONS_BG_DARK);
        int contentX = 10;
        int contentY = 30;
        int contentWidth = this.width - 20;
        int contentHeight = this.height - 40;
        TextureHelper.drawModalRectWithCustomSizedTexture(contentX, contentY, 0, 0, contentWidth, contentHeight, 16, 16);
        this.drawCenteredString(this.fontRendererObj, I18n.format((String)"selectWorld.create", (Object[])new Object[0]), this.width / 2, 15, 0xFFFFFF);
        this.drawString(this.fontRendererObj, I18n.format((String)"selectWorld.enterName", (Object[])new Object[0]), this.width / 2 - 100, 27, 0xA0A0A0);
        this.worldNameField.drawTextBox();
        for (GuiButton tabButton : this.tabButtons) {
            tabButton.drawButton(this.mc, mouseX, mouseY);
        }
        if (this.currentTab != null) {
            this.currentTab.drawScreen(mouseX, mouseY, partialTicks);
        }
        for (Object obj : this.buttonList) {
            if (!(obj instanceof GuiButton)) continue;
            GuiButton button = (GuiButton)obj;
            if (button.id >= 1000 && button.id < 1000 + this.tabButtons.size()) continue;
            button.drawButton(this.mc, mouseX, mouseY);
        }
    }

    protected void actionPerformed(GuiButton button) {
        List<CreateWorldAPI.IWorldTab> allTabs;
        int tabIndex;
        if (button.id == 1) {
            this.mc.displayGuiScreen(this.parentScreen);
        } else if (button.id == 0) {
            this.createWorld();
        } else if (button.id >= 1000 && (tabIndex = button.id - 1000) < (allTabs = this.getAllTabs()).size()) {
            this.clearCurrentTabButtons();
            this.currentTab = allTabs.get(tabIndex);
            this.currentTab.initGui(this, this.worldSettings);
            this.updateTabButtons();
        }
        if (this.currentTab != null) {
            try {
                this.currentTab.actionPerformed(button);
            }
            catch (IOException e) {
                LOGGER.error("Error in tab actionPerformed: {}", new Object[]{e.getMessage(), e});
            }
        }
    }

    private void clearCurrentTabButtons() {
        ArrayList<GuiButton> buttonsToKeep = new ArrayList<GuiButton>();
        for (Object obj : this.buttonList) {
            if (!(obj instanceof GuiButton)) continue;
            GuiButton button = (GuiButton)obj;
            if (button.id < 1000 && button.id != 0 && button.id != 1) continue;
            buttonsToKeep.add(button);
        }
        this.buttonList.clear();
        this.buttonList.addAll(buttonsToKeep);
    }

    private void updateTabButtons() {
        List<CreateWorldAPI.IWorldTab> allTabs = this.getAllTabs();
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            GuiButton tabButton = this.tabButtons.get(i);
            if (i >= allTabs.size()) continue;
            tabButton.displayString = allTabs.get(i).getTabName();
        }
    }

    protected void keyTyped(char typedChar, int keyCode) {
        super.keyTyped(typedChar, keyCode);
        try {
            this.worldNameField.textboxKeyTyped(typedChar, keyCode);
            if (this.currentTab != null) {
                this.currentTab.keyTyped(typedChar, keyCode);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error in tab keyTyped: {}", new Object[]{e.getMessage(), e});
        }
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        try {
            this.worldNameField.mouseClicked(mouseX, mouseY, mouseButton);
            if (this.currentTab != null) {
                this.currentTab.mouseClicked(mouseX, mouseY, mouseButton);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error in tab mouseClicked: {}", new Object[]{e.getMessage(), e});
        }
    }

    private void createWorld() {
        long seed;
        String worldName = this.worldNameField.getText().trim();
        if (worldName.isEmpty()) {
            worldName = I18n.format((String)"selectWorld.newWorld", (Object[])new Object[0]);
        }
        try {
            seed = Long.parseLong(this.seedField.getText());
        }
        catch (NumberFormatException e) {
            seed = this.seedField.getText().hashCode();
        }
        WorldSettings settings = new WorldSettings(seed, this.selectedGameType, this.mapFeaturesEnabled, this.bonusChestEnabled, this.selectedWorldType);
        this.applyGameRules(settings);
        if (this.currentTab != null) {
            settings = this.currentTab.applySettings(settings);
        }
        try {
            Method createWorldMethod = GuiCreateWorld.class.getDeclaredMethod("func_146318_a", String.class, String.class, WorldSettings.class);
            createWorldMethod.setAccessible(true);
            createWorldMethod.invoke((Object)this, worldName, worldName, settings);
            this.setGameRulesAfterCreation();
        }
        catch (Exception e) {
            LOGGER.error("Failed to create world", (Throwable)e);
            this.mc.displayGuiScreen(null);
        }
    }

    private GameRules getGameRules() {
        GameRules rules = new GameRules();
        rules.setOrCreateGameRule("doMobSpawning", Boolean.toString(this.spawnMonsters));
        rules.setOrCreateGameRule("doEntityDrops", Boolean.toString(this.spawnAnimals));
        rules.setOrCreateGameRule("doWeatherCycle", Boolean.toString(this.weatherCycle));
        rules.setOrCreateGameRule("doDaylightCycle", Boolean.toString(this.daylightCycle));
        return rules;
    }

    private long parseSeed(String seed) {
        try {
            return Long.parseLong(seed);
        }
        catch (NumberFormatException e) {
            return seed.hashCode();
        }
    }

    private void applyGameRules(WorldSettings settings) {
        try {
            Class<?> worldSettingsClass = settings.getClass();
            Field gameRulesField = worldSettingsClass.getDeclaredField("gameRules");
            gameRulesField.setAccessible(true);
            Object gameRules = gameRulesField.get(settings);
            Class<?> gameRulesClass = gameRules.getClass();
            Method setGameRuleMethod = gameRulesClass.getDeclaredMethod("setOrCreateGameRule", String.class, String.class);
            setGameRuleMethod.setAccessible(true);
            setGameRuleMethod.invoke(gameRules, "doMobSpawning", Boolean.toString(this.spawnMonsters));
            setGameRuleMethod.invoke(gameRules, "doMobLoot", Boolean.toString(this.spawnAnimals));
            setGameRuleMethod.invoke(gameRules, "doWeatherCycle", Boolean.toString(this.weatherCycle));
            setGameRuleMethod.invoke(gameRules, "doDaylightCycle", Boolean.toString(this.daylightCycle));
        }
        catch (Exception e) {
            LOGGER.error("Failed to set game rules: {}", new Object[]{e.getMessage(), e});
        }
    }

    private void setGameRulesAfterCreation() {
        try {
            Field integratedServerField = Minecraft.class.getDeclaredField("theIntegratedServer");
            integratedServerField.setAccessible(true);
            Object integratedServer = integratedServerField.get(this.mc);
            if (integratedServer != null) {
                Method getGameRulesMethod = integratedServer.getClass().getDeclaredMethod("getGameRules", new Class[0]);
                getGameRulesMethod.setAccessible(true);
                Object gameRules = getGameRulesMethod.invoke(integratedServer, new Object[0]);
                Method setGameRuleMethod = gameRules.getClass().getDeclaredMethod("setOrCreateGameRule", String.class, String.class);
                setGameRuleMethod.setAccessible(true);
                setGameRuleMethod.invoke(gameRules, "doMobSpawning", Boolean.toString(this.spawnMonsters));
                setGameRuleMethod.invoke(gameRules, "doMobLoot", Boolean.toString(this.spawnAnimals));
                setGameRuleMethod.invoke(gameRules, "doWeatherCycle", Boolean.toString(this.weatherCycle));
                setGameRuleMethod.invoke(gameRules, "doDaylightCycle", Boolean.toString(this.daylightCycle));
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to set game rules after creation: {}", new Object[]{e.getMessage(), e});
        }
    }

    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private List<CreateWorldAPI.IWorldTab> getAllTabs() {
        ArrayList<CreateWorldAPI.IWorldTab> allTabs = new ArrayList<CreateWorldAPI.IWorldTab>(this.defaultTabs);
        allTabs.addAll(CreateWorldAPI.getTabs());
        allTabs.sort(Comparator.comparingInt(CreateWorldAPI.IWorldTab::getTabOrder));
        return allTabs;
    }

    static {
        LOGGER = LogManager.getLogger();
        OPTIONS_BG_LIGHT = TextureManager.OPTIONS_BG_LIGHT;
        OPTIONS_BG_DARK = TextureManager.OPTIONS_BG_DARK;
    }

    private class MoreTab
    implements CreateWorldAPI.IWorldTab {
        private GuiButton spawnAnimalsButton;
        private GuiButton spawnMonstersButton;
        private GuiButton weatherCycleButton;
        private GuiButton daylightCycleButton;

        private MoreTab() {
        }

        @Override
        public String getTabName() {
            return I18n.format((String)"worldcreateui.tab.more", (Object[])new Object[0]);
        }

        @Override
        public void initGui(GuiScreen parent, WorldSettings settings) {
            int yPos = 80;
            int buttonWidth = 180;
            this.spawnAnimalsButton = new GuiButton(400, GuiCreateWorldModern.this.width / 2 - buttonWidth / 2, yPos, buttonWidth, 20, I18n.format((String)"createworldui.gamerules.spawn_animals", (Object[])new Object[0]) + (GuiCreateWorldModern.this.spawnAnimals ? I18n.format((String)"options.on", (Object[])new Object[0]) : I18n.format((String)"options.off", (Object[])new Object[0])));
            this.spawnMonstersButton = new GuiButton(401, GuiCreateWorldModern.this.width / 2 - buttonWidth / 2, yPos += 25, buttonWidth, 20, I18n.format((String)"createworldui.gamerules.spawn_monsters", (Object[])new Object[0]) + ": " + (GuiCreateWorldModern.this.spawnMonsters ? I18n.format((String)"options.on", (Object[])new Object[0]) : I18n.format((String)"options.off", (Object[])new Object[0])));
            this.weatherCycleButton = new GuiButton(402, GuiCreateWorldModern.this.width / 2 - buttonWidth / 2, yPos += 25, buttonWidth, 20, I18n.format((String)"createworldui.gamerules.weather_cycle", (Object[])new Object[0]) + ": " + (GuiCreateWorldModern.this.weatherCycle ? I18n.format((String)"options.on", (Object[])new Object[0]) : I18n.format((String)"options.off", (Object[])new Object[0])));
            this.daylightCycleButton = new GuiButton(403, GuiCreateWorldModern.this.width / 2 - buttonWidth / 2, yPos += 25, buttonWidth, 20, I18n.format((String)"createworldui.gamerules.daylight_cycle", (Object[])new Object[0]) + ": " + (GuiCreateWorldModern.this.daylightCycle ? I18n.format((String)"options.on", (Object[])new Object[0]) : I18n.format((String)"options.off", (Object[])new Object[0])));
            GuiCreateWorldModern.this.addButtonSafely(this.spawnAnimalsButton);
            GuiCreateWorldModern.this.addButtonSafely(this.spawnMonstersButton);
            GuiCreateWorldModern.this.addButtonSafely(this.weatherCycleButton);
            GuiCreateWorldModern.this.addButtonSafely(this.daylightCycleButton);
        }

        @Override
        public void drawScreen(int mouseX, int mouseY, float partialTicks) {
            GuiCreateWorldModern.this.mc.getTextureManager().bindTexture(TextureManager.OPTIONS_BG_DARK);
            TextureHelper.drawModalRectWithCustomSizedTexture(GuiCreateWorldModern.this.width / 2 - 110, 70, 0, 0, 220, 190, 16, 16);
            GuiCreateWorldModern.this.drawCenteredString(GuiCreateWorldModern.this.fontRendererObj, I18n.format((String)"createworldui.gamerules.title", (Object[])new Object[0]), GuiCreateWorldModern.this.width / 2, 60, 0xFFFFFF);
            GuiCreateWorldModern.this.drawCenteredString(GuiCreateWorldModern.this.fontRendererObj, I18n.format((String)"createworldui.experimental.warning", (Object[])new Object[0]), GuiCreateWorldModern.this.width / 2, 170, 0xFF5555);
        }

        @Override
        public void actionPerformed(GuiButton button) {
            if (button == this.spawnAnimalsButton) {
                GuiCreateWorldModern.this.spawnAnimals = !GuiCreateWorldModern.this.spawnAnimals;
                button.displayString = I18n.format((String)"createworldui.gamerules.spawn_animals", (Object[])new Object[0]) + ": " + (GuiCreateWorldModern.this.spawnAnimals ? I18n.format((String)"options.on", (Object[])new Object[0]) : I18n.format((String)"options.off", (Object[])new Object[0]));
            } else if (button == this.spawnMonstersButton) {
                GuiCreateWorldModern.this.spawnMonsters = !GuiCreateWorldModern.this.spawnMonsters;
                button.displayString = I18n.format((String)"createworldui.gamerules.spawn_monsters", (Object[])new Object[0]) + ": " + (GuiCreateWorldModern.this.spawnMonsters ? I18n.format((String)"options.on", (Object[])new Object[0]) : I18n.format((String)"options.off", (Object[])new Object[0]));
            } else if (button == this.weatherCycleButton) {
                GuiCreateWorldModern.this.weatherCycle = !GuiCreateWorldModern.this.weatherCycle;
                button.displayString = I18n.format((String)"createworldui.gamerules.weather_cycle", (Object[])new Object[0]) + ": " + (GuiCreateWorldModern.this.weatherCycle ? I18n.format((String)"options.on", (Object[])new Object[0]) : I18n.format((String)"options.off", (Object[])new Object[0]));
            } else if (button == this.daylightCycleButton) {
                GuiCreateWorldModern.this.daylightCycle = !GuiCreateWorldModern.this.daylightCycle;
                button.displayString = I18n.format((String)"createworldui.gamerules.daylight_cycle", (Object[])new Object[0]) + ": " + (GuiCreateWorldModern.this.daylightCycle ? I18n.format((String)"options.on", (Object[])new Object[0]) : I18n.format((String)"options.off", (Object[])new Object[0]));
            }
        }

        @Override
        public void keyTyped(char typedChar, int keyCode) {
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        }

        @Override
        public WorldSettings applySettings(WorldSettings settings) {
            return settings;
        }

        @Override
        public int getTabOrder() {
            return 30;
        }
    }

    private class WorldTab
    implements CreateWorldAPI.IWorldTab {
        private GuiButton worldTypeButton;
        private GuiButton mapFeaturesButton;
        private GuiButton bonusChestButton;

        private WorldTab() {
        }

        @Override
        public String getTabName() {
            return I18n.format((String)"worldcreateui.tab.world", (Object[])new Object[0]);
        }

        @Override
        public void initGui(GuiScreen parent, WorldSettings settings) {
            int yPos = 80;
            this.worldTypeButton = new GuiButton(300, GuiCreateWorldModern.this.width / 2 - 100, yPos, 200, 20, I18n.format((String)"selectWorld.mapType", (Object[])new Object[0]) + GuiCreateWorldModern.this.selectedWorldType.getWorldTypeName());
            GuiCreateWorldModern.this.seedField = new GuiTextField(GuiCreateWorldModern.this.fontRendererObj, GuiCreateWorldModern.this.width / 2 - 100, yPos += 25, 200, 20);
            GuiCreateWorldModern.this.seedField.setText("");
            this.mapFeaturesButton = new GuiButton(301, GuiCreateWorldModern.this.width / 2 - 100, yPos += 25, 200, 20, I18n.format((String)"selectWorld.mapFeatures", (Object[])new Object[0]) + (GuiCreateWorldModern.this.mapFeaturesEnabled ? I18n.format((String)"options.on", (Object[])new Object[0]) : I18n.format((String)"options.off", (Object[])new Object[0])));
            this.bonusChestButton = new GuiButton(302, GuiCreateWorldModern.this.width / 2 - 100, yPos += 25, 200, 20, I18n.format((String)"selectWorld.bonusItems", (Object[])new Object[0]) + (GuiCreateWorldModern.this.bonusChestEnabled ? I18n.format((String)"options.on", (Object[])new Object[0]) : I18n.format((String)"options.off", (Object[])new Object[0])));
            GuiCreateWorldModern.this.addButtonSafely(this.worldTypeButton);
            GuiCreateWorldModern.this.addButtonSafely(this.mapFeaturesButton);
            GuiCreateWorldModern.this.addButtonSafely(this.bonusChestButton);
        }

        @Override
        public void drawScreen(int mouseX, int mouseY, float partialTicks) {
            GuiCreateWorldModern.this.mc.getTextureManager().bindTexture(TextureManager.OPTIONS_BG_DARK);
            TextureHelper.drawModalRectWithCustomSizedTexture(GuiCreateWorldModern.this.width / 2 - 110, 70, 0, 0, 220, 190, 16, 16);
            GuiCreateWorldModern.this.drawCenteredString(GuiCreateWorldModern.this.fontRendererObj, I18n.format((String)"worldcreateui.title.world", (Object[])new Object[0]), GuiCreateWorldModern.this.width / 2, 60, 0xFFFFFF);
            GuiCreateWorldModern.this.drawString(GuiCreateWorldModern.this.fontRendererObj, I18n.format((String)"selectWorld.enterSeed", (Object[])new Object[0]), GuiCreateWorldModern.this.width / 2 - 100, 127, 0xA0A0A0);
            GuiCreateWorldModern.this.seedField.drawTextBox();
            GuiCreateWorldModern.this.drawString(GuiCreateWorldModern.this.fontRendererObj, I18n.format((String)"createworld.seed.tooltip", (Object[])new Object[0]), GuiCreateWorldModern.this.width / 2 - 100, 170, 0xAAAAAA);
            String description = GuiCreateWorldModern.this.selectedWorldType.getTranslateName();
            List lines = GuiCreateWorldModern.this.fontRendererObj.listFormattedStringToWidth(description, 180);
            int yPos = 190;
            for (String line : lines) {
                GuiCreateWorldModern.this.drawCenteredString(GuiCreateWorldModern.this.fontRendererObj, line, GuiCreateWorldModern.this.width / 2, yPos, 0xCCCCCC);
                yPos += 10;
            }
        }

        @Override
        public void actionPerformed(GuiButton button) {
            if (button == this.worldTypeButton) {
                this.cycleWorldType();
                button.displayString = I18n.format((String)"selectWorld.mapType", (Object[])new Object[0]) + GuiCreateWorldModern.this.selectedWorldType.getWorldTypeName();
            } else if (button == this.mapFeaturesButton) {
                GuiCreateWorldModern.this.mapFeaturesEnabled = !GuiCreateWorldModern.this.mapFeaturesEnabled;
                button.displayString = I18n.format((String)"selectWorld.mapFeatures", (Object[])new Object[0]) + (GuiCreateWorldModern.this.mapFeaturesEnabled ? I18n.format((String)"options.on", (Object[])new Object[0]) : I18n.format((String)"options.off", (Object[])new Object[0]));
            } else if (button == this.bonusChestButton) {
                GuiCreateWorldModern.this.bonusChestEnabled = !GuiCreateWorldModern.this.bonusChestEnabled;
                button.displayString = I18n.format((String)"selectWorld.bonusItems", (Object[])new Object[0]) + (GuiCreateWorldModern.this.bonusChestEnabled ? I18n.format((String)"options.on", (Object[])new Object[0]) : I18n.format((String)"options.off", (Object[])new Object[0]));
            }
        }

        @Override
        public void keyTyped(char typedChar, int keyCode) {
            GuiCreateWorldModern.this.seedField.textboxKeyTyped(typedChar, keyCode);
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
            GuiCreateWorldModern.this.seedField.mouseClicked(mouseX, mouseY, mouseButton);
        }

        private void cycleWorldType() {
            WorldType[] types = new WorldType[]{WorldType.DEFAULT, WorldType.FLAT, WorldType.LARGE_BIOMES};
            int currentIndex = Arrays.asList(types).indexOf(GuiCreateWorldModern.this.selectedWorldType);
            int nextIndex = (currentIndex + 1) % types.length;
            GuiCreateWorldModern.this.selectedWorldType = types[nextIndex];
        }

        @Override
        public WorldSettings applySettings(WorldSettings settings) {
            return settings;
        }

        @Override
        public int getTabOrder() {
            return 20;
        }
    }

    private class GameTab
    implements CreateWorldAPI.IWorldTab {
        private GuiButton gameModeButton;
        private GuiButton difficultyButton;
        private GuiButton cheatsButton;

        private GameTab() {
        }

        @Override
        public String getTabName() {
            return I18n.format((String)"worldcreateui.tab.game", (Object[])new Object[0]);
        }

        @Override
        public void initGui(GuiScreen parent, WorldSettings settings) {
            int yPos = 80;
            this.gameModeButton = new GuiButton(200, GuiCreateWorldModern.this.width / 2 - 100, yPos, 200, 20, I18n.format((String)"selectWorld.gameMode", (Object[])new Object[0]) + ": " + GuiCreateWorldModern.this.selectedGameType.getName());
            this.difficultyButton = new GuiButton(201, GuiCreateWorldModern.this.width / 2 - 100, yPos += 25, 200, 20, I18n.format((String)"worldcreateui.button.selectWorld.difficulty", (Object[])new Object[0]) + this.getDifficultyText());
            this.cheatsButton = new GuiButton(202, GuiCreateWorldModern.this.width / 2 - 100, yPos += 25, 200, 20, I18n.format((String)"selectWorld.allowCommands", (Object[])new Object[0]) + (GuiCreateWorldModern.this.allowCommands ? I18n.format((String)"options.on", (Object[])new Object[0]) : I18n.format((String)"options.off", (Object[])new Object[0])));
            GuiCreateWorldModern.this.addButtonSafely(this.gameModeButton);
            GuiCreateWorldModern.this.addButtonSafely(this.difficultyButton);
            GuiCreateWorldModern.this.addButtonSafely(this.cheatsButton);
        }

        @Override
        public void drawScreen(int mouseX, int mouseY, float partialTicks) {
            GuiCreateWorldModern.this.mc.getTextureManager().bindTexture(TextureManager.OPTIONS_BG_DARK);
            TextureHelper.drawModalRectWithCustomSizedTexture(GuiCreateWorldModern.this.width / 2 - 110, 70, 0, 0, 220, 150, 16, 16);
            GuiCreateWorldModern.this.drawCenteredString(GuiCreateWorldModern.this.fontRendererObj, I18n.format((String)"worldcreateui.title.game", (Object[])new Object[0]), GuiCreateWorldModern.this.width / 2, 60, 0xFFFFFF);
            String description = this.getGameModeDescription();
            List lines = GuiCreateWorldModern.this.fontRendererObj.listFormattedStringToWidth(description, 180);
            int yPos = 170;
            for (String line : lines) {
                GuiCreateWorldModern.this.drawCenteredString(GuiCreateWorldModern.this.fontRendererObj, line, GuiCreateWorldModern.this.width / 2, yPos, 0xCCCCCC);
                yPos += 10;
            }
        }

        @Override
        public void actionPerformed(GuiButton button) {
            if (button == this.gameModeButton) {
                this.cycleGameMode();
                button.displayString = I18n.format((String)"selectWorld.gameMode", (Object[])new Object[0]) + ": " + GuiCreateWorldModern.this.selectedGameType.getName();
            } else if (button == this.difficultyButton) {
                GuiCreateWorldModern.this.difficulty = (GuiCreateWorldModern.this.difficulty + 1) % 4;
                button.displayString = I18n.format((String)"worldcreateui.button.selectWorld.difficulty", (Object[])new Object[0]) + this.getDifficultyText();
            } else if (button == this.cheatsButton) {
                GuiCreateWorldModern.this.allowCommands = !GuiCreateWorldModern.this.allowCommands;
                button.displayString = I18n.format((String)"selectWorld.allowCommands", (Object[])new Object[0]) + (GuiCreateWorldModern.this.allowCommands ? I18n.format((String)"options.on", (Object[])new Object[0]) : I18n.format((String)"options.off", (Object[])new Object[0]));
            }
        }

        private void cycleGameMode() {
            WorldSettings.GameType[] modes = WorldSettings.GameType.values();
            int next = (GuiCreateWorldModern.this.selectedGameType.ordinal() + 1) % modes.length;
            GuiCreateWorldModern.this.selectedGameType = modes[next];
        }

        private String getDifficultyText() {
            switch (GuiCreateWorldModern.this.difficulty) {
                case 0: {
                    return I18n.format((String)"worldcreateui.button.selectWorld.difficulty.peaceful", (Object[])new Object[0]);
                }
                case 1: {
                    return I18n.format((String)"worldcreateui.button.selectWorld.difficulty.easy", (Object[])new Object[0]);
                }
                case 2: {
                    return I18n.format((String)"worldcreateui.button.selectWorld.difficulty.normal", (Object[])new Object[0]);
                }
                case 3: {
                    return I18n.format((String)"worldcreateui.button.selectWorld.difficulty.hard", (Object[])new Object[0]);
                }
            }
            return "";
        }

        private String getGameModeDescription() {
            switch (GuiCreateWorldModern.this.selectedGameType) {
                case SURVIVAL: {
                    return I18n.format((String)"createworldui.desc.gamemode.survival", (Object[])new Object[0]);
                }
                case CREATIVE: {
                    return I18n.format((String)"createworldui.desc.gamemode.creative", (Object[])new Object[0]);
                }
                case ADVENTURE: {
                    return I18n.format((String)"createworldui.desc.gamemode.adventure", (Object[])new Object[0]);
                }
                case NOT_SET: {
                    return I18n.format((String)"createworldui.desc.gamemode.not_set", (Object[])new Object[0]);
                }
            }
            return "";
        }

        @Override
        public void keyTyped(char typedChar, int keyCode) {
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        }

        @Override
        public WorldSettings applySettings(WorldSettings settings) {
            return settings;
        }

        @Override
        public int getTabOrder() {
            return 10;
        }
    }

    private static enum TabState {
        NORMAL(0, 0, 0xE0E0E0),
        HOVER(0, 24, 0xFFFFFF),
        SELECTED(0, 48, 0xFFCC00),
        SELECTED_HOVER(0, 72, 0xFFCC00);

        final int u;
        final int v;
        final int textColor;

        private TabState(int u, int v, int textColor) {
            this.u = u;
            this.v = v;
            this.textColor = textColor;
        }

        static TabState getState(boolean isSelected, boolean isHovered) {
            if (isSelected) {
                return isHovered ? SELECTED_HOVER : SELECTED;
            }
            return isHovered ? HOVER : NORMAL;
        }
    }
}

