/*
 * Decompiled with CFR 0.152.
 */
package decok.dfcdvadstf.createworldui.mixin;

import decok.dfcdvadstf.createworldui.api.TabState;
import decok.dfcdvadstf.createworldui.gamerule.GameRuleEditor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.WorldType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiCreateWorld.class})
public abstract class ModernCreateWorld
extends GuiScreen {
    @Shadow
    private GuiScreen field_146332_f;
    @Shadow
    private boolean field_146337_w;
    @Shadow
    private String field_146330_J;
    @Shadow
    private String field_146342_r;
    @Shadow
    private String field_146329_I;
    @Shadow
    private boolean field_146341_s;
    @Shadow
    private boolean field_146338_v;
    @Shadow
    private boolean field_146340_t;
    @Shadow
    private GuiTextField field_146335_h;
    @Shadow
    private GuiTextField field_146333_g;
    @Shadow
    private GuiButton field_146321_E;
    @Shadow
    private GuiButton field_146343_z;
    @Shadow
    private GuiButton field_146326_C;
    @Shadow
    private GuiButton field_146320_D;
    @Shadow
    private GuiButton field_146325_B;
    @Shadow
    private GuiButton field_146322_F;
    @Shadow
    private int field_146331_K;
    @Unique
    private int modernWorldCreatingUI$currentTab = 100;
    @Unique
    private final List<GuiButton> modernWorldCreatingUI$tabButtons = new ArrayList<GuiButton>();
    @Unique
    private boolean modernWorldCreatingUI$isReorganizing = false;
    @Unique
    private static final ResourceLocation OPTIONS_BG_DARK = new ResourceLocation("createworldui:textures/gui/options_background_dark.png");
    @Unique
    private static final ResourceLocation TABS_TEXTURE = new ResourceLocation("createworldui:textures/gui/tabs.png");
    @Unique
    private static final int TAB_WIDTH = 130;
    @Unique
    private static final int TAB_HEIGHT = 24;
    @Unique
    private final Map<Integer, String> modernWorldCreatingUI$hoverTexts = new HashMap<Integer, String>();
    @Unique
    private GuiButton modernWorldCreatingUI$difficultyButton;
    @Unique
    private EnumDifficulty modernWorldCreatingUI$difficulty = EnumDifficulty.NORMAL;

    @Inject(method={"initGui"}, at={@At(value="HEAD")})
    private void onInitGuiHead(CallbackInfo ci) {
        this.modernWorldCreatingUI$ensureFieldsNotNull();
        this.modernWorldCreatingUI$isReorganizing = true;
    }

    @Inject(method={"initGui"}, at={@At(value="TAIL")})
    private void onInitGuiTail(CallbackInfo ci) {
        List<GuiButton> essentialButtons = this.modernWorldCreatingUI$collectEssentialButtons();
        this.buttonList.clear();
        this.modernWorldCreatingUI$tabButtons.clear();
        this.modernWorldCreatingUI$hoverTexts.clear();
        this.buttonList.addAll(essentialButtons);
        this.modernWorldCreatingUI$createTabButtons();
        this.modernWorldCreatingUI$recreateFunctionalButtons();
        this.modernWorldCreatingUI$setupTextFields();
        this.modernWorldCreatingUI$updateButtonVisibilityNAbility();
        this.modernWorldCreatingUI$repositionActionButtons();
        this.modernWorldCreatingUI$initHoverTexts();
        this.modernWorldCreatingUI$isReorganizing = false;
    }

    @Unique
    private void modernWorldCreatingUI$initHoverTexts() {
        this.modernWorldCreatingUI$hoverTexts.put(4, I18n.format((String)"createworldui.hover.generateStructures", (Object[])new Object[0]));
        this.modernWorldCreatingUI$hoverTexts.put(5, I18n.format((String)"createworldui.hover.worldType", (Object[])new Object[0]));
        this.modernWorldCreatingUI$hoverTexts.put(6, I18n.format((String)"createworldui.hover.allowCheats", (Object[])new Object[0]));
        this.modernWorldCreatingUI$hoverTexts.put(7, I18n.format((String)"createworldui.hover.bonusChest", (Object[])new Object[0]));
        this.modernWorldCreatingUI$hoverTexts.put(8, I18n.format((String)"createworldui.hover.customize", (Object[])new Object[0]));
        this.modernWorldCreatingUI$hoverTexts.put(200, I18n.format((String)"createworldui.hover.gameRuleEditor", (Object[])new Object[0]));
    }

    @Unique
    private void modernWorldCreatingUI$ensureFieldsNotNull() {
        if (this.field_146330_J == null) {
            this.field_146330_J = "New World";
        }
        if (this.field_146329_I == null) {
            this.field_146329_I = "";
        }
        if (this.field_146342_r == null) {
            this.field_146342_r = "survival";
        }
        if (WorldType.worldTypes == null || this.field_146331_K >= WorldType.worldTypes.length || WorldType.worldTypes[this.field_146331_K] == null) {
            this.field_146331_K = 0;
        }
    }

    @Unique
    private List<GuiButton> modernWorldCreatingUI$collectEssentialButtons() {
        ArrayList<GuiButton> essentialButtons = new ArrayList<GuiButton>();
        for (GuiButton button : this.buttonList) {
            if (button.id != 0 && button.id != 1) continue;
            essentialButtons.add(button);
        }
        return essentialButtons;
    }

    @Unique
    private void modernWorldCreatingUI$recreateFunctionalButtons() {
        this.field_146343_z = new GuiButton(2, this.width / 2 - 104, this.height / 2, 208, 20, "");
        this.buttonList.add(this.field_146343_z);
        this.field_146325_B = new GuiButton(4, this.width / 2 + 154 - 44, this.height / 2 + 15, 44, 20, "");
        this.buttonList.add(this.field_146325_B);
        this.field_146326_C = new GuiButton(7, this.width / 2 + 154 - 44, this.height / 2 - 15, 44, 20, "");
        this.buttonList.add(this.field_146326_C);
        this.field_146320_D = new GuiButton(5, this.width / 2 - 154, this.height / 8 + 10, 150, 20, "");
        this.buttonList.add(this.field_146320_D);
        this.field_146321_E = new GuiButton(6, this.width / 2 - 104, this.height / 2 + 50, 208, 20, "");
        this.buttonList.add(this.field_146321_E);
        this.field_146322_F = new GuiButton(8, this.width / 2 + 4, this.height / 8 + 10, 150, 20, I18n.format((String)"selectWorld.customizeType", (Object[])new Object[0]));
        this.buttonList.add(this.field_146322_F);
        this.buttonList.add(new GuiButton(200, this.width / 2 - 100, this.height / 6 + 2, 200, 20, I18n.format((String)"createworldui.button.gameRuleEditor", (Object[])new Object[0])));
        this.modernWorldCreatingUI$difficultyButton = new GuiButton(9, this.width / 2 - 104, this.height / 2 + 25, 208, 20, this.modernWorldCreatingUI$getDifficultyText());
        this.buttonList.add(this.modernWorldCreatingUI$difficultyButton);
        this.modernWorldCreatingUI$updateButtonText();
    }

    @Unique
    private void modernWorldCreatingUI$setupTextFields() {
        if (this.field_146333_g != null) {
            this.field_146333_g.xPosition = this.width / 2 - 104;
            this.field_146333_g.yPosition = this.height / 5;
            this.field_146333_g.width = 208;
        } else {
            this.field_146333_g = new GuiTextField(this.fontRendererObj, this.width / 2 - 100, 34, this.width / 2, 20);
            this.field_146333_g.setText(this.field_146330_J);
        }
        if (this.field_146335_h != null) {
            this.field_146335_h.xPosition = this.width / 2 - 154;
            this.field_146335_h.yPosition = this.height / 3 - 1;
            this.field_146335_h.width = 308;
        } else {
            this.field_146335_h = new GuiTextField(this.fontRendererObj, this.width / 2 - 100, 44, this.width / 2, 20);
            this.field_146335_h.setText(this.field_146329_I);
        }
        this.field_146333_g.setFocused(true);
    }

    @Unique
    private void modernWorldCreatingUI$repositionActionButtons() {
        GuiButton createButton = this.modernWorldCreatingUI$getButtonById(0);
        GuiButton cancelButton = this.modernWorldCreatingUI$getButtonById(1);
        if (createButton != null) {
            createButton.xPosition = this.width / 2 - 155;
            createButton.yPosition = this.height - 28;
            createButton.width = 150;
            createButton.height = 20;
        }
        if (cancelButton != null) {
            cancelButton.xPosition = this.width / 2 + 5;
            cancelButton.yPosition = this.height - 28;
            cancelButton.width = 150;
            cancelButton.height = 20;
        }
    }

    @Unique
    private void modernWorldCreatingUI$createTabButtons() {
        this.modernWorldCreatingUI$tabButtons.clear();
        int totalWidth = 392;
        int startX = this.width / 2 - totalWidth / 2;
        String[] tabNames = new String[]{I18n.format((String)"createworldui.tab.game", (Object[])new Object[0]), I18n.format((String)"createworldui.tab.world", (Object[])new Object[0]), I18n.format((String)"createworldui.tab.more", (Object[])new Object[0])};
        for (int i = 0; i < 3; ++i) {
            int xPos = startX + i * 131;
            GuiButton tabButton = new GuiButton(100 + i, xPos, 0, 130, 24, tabNames[i]){

                public void drawButton(Minecraft mc, int mouseX, int mouseY) {
                    if (this.visible) {
                        boolean isSelected;
                        mc.getTextureManager().bindTexture(TABS_TEXTURE);
                        boolean isHovered = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
                        boolean bl = isSelected = ModernCreateWorld.this.modernWorldCreatingUI$currentTab == this.id;
                        TabState state = isSelected ? (isHovered ? TabState.SELECTED_HOVER : TabState.SELECTED) : (isHovered ? TabState.HOVER : TabState.NORMAL);
                        this.drawTexturedModalRect(this.xPosition, this.yPosition, state.u, state.v, 130, 24);
                        this.drawCenteredString(mc.fontRenderer, this.displayString, this.xPosition + this.width / 2, this.yPosition + (this.height - 8) / 2, state.textColor);
                    }
                }
            };
            this.modernWorldCreatingUI$tabButtons.add(tabButton);
            this.buttonList.add(tabButton);
        }
    }

    @Unique
    private void modernWorldCreatingUI$updateButtonText() {
        if (this.field_146342_r == null) {
            this.field_146342_r = "survival";
        }
        if (WorldType.worldTypes == null || this.field_146331_K >= WorldType.worldTypes.length || WorldType.worldTypes[this.field_146331_K] == null) {
            this.field_146331_K = 0;
        }
        this.modernWorldCreatingUI$difficultyButton.displayString = this.modernWorldCreatingUI$getDifficultyText();
        this.field_146343_z.displayString = I18n.format((String)"selectWorld.gameMode", (Object[])new Object[0]) + " " + I18n.format((String)("selectWorld.gameMode." + this.field_146342_r), (Object[])new Object[0]);
        this.field_146325_B.displayString = this.field_146341_s ? I18n.format((String)"options.on", (Object[])new Object[0]) : I18n.format((String)"options.off", (Object[])new Object[0]);
        this.field_146326_C.displayString = this.field_146338_v && !this.field_146337_w ? I18n.format((String)"options.on", (Object[])new Object[0]) : I18n.format((String)"options.off", (Object[])new Object[0]);
        this.field_146320_D.displayString = I18n.format((String)"selectWorld.mapType", (Object[])new Object[0]) + " " + I18n.format((String)WorldType.worldTypes[this.field_146331_K].getTranslateName(), (Object[])new Object[0]);
        this.field_146321_E.displayString = I18n.format((String)"selectWorld.allowCommands", (Object[])new Object[0]) + " " + (this.field_146340_t && !this.field_146337_w ? I18n.format((String)"options.on", (Object[])new Object[0]) : I18n.format((String)"options.off", (Object[])new Object[0]));
    }

    @Unique
    private String modernWorldCreatingUI$getDifficultyText() {
        return I18n.format((String)"options.difficulty", (Object[])new Object[0]) + ": " + I18n.format((String)this.modernWorldCreatingUI$difficulty.getDifficultyResourceKey(), (Object[])new Object[0]);
    }

    @Unique
    private void modernWorldCreatingUI$updateButtonVisibilityNAbility() {
        switch (this.modernWorldCreatingUI$currentTab) {
            case 100: {
                this.field_146343_z.visible = true;
                this.field_146321_E.visible = true;
                this.modernWorldCreatingUI$difficultyButton.visible = true;
                this.field_146325_B.visible = false;
                this.field_146326_C.visible = false;
                this.field_146320_D.visible = false;
                this.field_146322_F.visible = false;
                this.modernWorldCreatingUI$getButtonById((int)200).visible = false;
                break;
            }
            case 101: {
                this.field_146343_z.visible = false;
                this.field_146321_E.visible = false;
                this.modernWorldCreatingUI$difficultyButton.visible = false;
                this.field_146325_B.visible = true;
                this.field_146326_C.visible = true;
                this.field_146320_D.visible = true;
                this.field_146322_F.enabled = WorldType.worldTypes[this.field_146331_K].isCustomizable();
                this.field_146322_F.visible = true;
                this.modernWorldCreatingUI$getButtonById((int)200).visible = false;
                break;
            }
            case 102: {
                this.field_146343_z.visible = false;
                this.field_146321_E.visible = false;
                this.modernWorldCreatingUI$difficultyButton.visible = false;
                this.field_146325_B.visible = false;
                this.field_146326_C.visible = false;
                this.field_146320_D.visible = false;
                this.field_146322_F.visible = false;
                this.modernWorldCreatingUI$getButtonById((int)200).visible = true;
            }
        }
        this.modernWorldCreatingUI$updateButtonText();
    }

    @Inject(method={"drawScreen"}, at={@At(value="HEAD")}, cancellable=true)
    public void onDrawScreen(int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        ci.cancel();
        this.drawBackground(0);
        this.mc.getTextureManager().bindTexture(OPTIONS_BG_DARK);
        this.modernWorldCreatingUI$drawTiledTexture(0, 0, this.width, 22, 16, 16);
        this.modernWorldCreatingUI$drawColoredLine(0, 21, this.width, 0xFFFFFF, 0x40FFFFFF);
        this.modernWorldCreatingUI$drawColoredLine(0, this.height - 35, this.width, 0x40000000, 0x40FFFFFF);
        if (this.modernWorldCreatingUI$currentTab == 100) {
            this.drawString(this.fontRendererObj, I18n.format((String)"selectWorld.enterName", (Object[])new Object[0]), this.width / 2 - 104, this.height / 5 - 13, 0xA0A0A0);
            this.field_146333_g.drawTextBox();
        }
        if (this.modernWorldCreatingUI$currentTab == 101) {
            this.drawString(this.fontRendererObj, I18n.format((String)"selectWorld.enterSeed", (Object[])new Object[0]), this.width / 2 - 154, this.height / 3 - 2 - 13, 0xA0A0A0);
            this.field_146335_h.drawTextBox();
            if (this.field_146335_h.getText().isEmpty() && !this.field_146335_h.isFocused()) {
                String placeholder = I18n.format((String)"selectWorld.seedInfo", (Object[])new Object[0]);
                int x = this.field_146335_h.xPosition + 4;
                int y = this.field_146335_h.yPosition + (this.field_146335_h.height - 8) / 2;
                this.fontRendererObj.drawStringWithShadow(placeholder, x, y, 0x808080);
            }
            this.drawString(this.fontRendererObj, I18n.format((String)"createworldui.selectWorld.mapFeatures", (Object[])new Object[0]), this.width / 2 - 154, this.height / 2 + 15 + 6, 0xFFFFFF);
            this.drawString(this.fontRendererObj, I18n.format((String)"createworldui.selectWorld.bonusItems", (Object[])new Object[0]), this.width / 2 - 154, this.height / 2 - 15 + 6, 0xFFFFFF);
        }
        super.drawScreen(mouseX, mouseY, partialTicks);
        this.modernWorldCreatingUI$drawHoverText(mouseX, mouseY);
    }

    @Unique
    private void modernWorldCreatingUI$drawHoverText(int mouseX, int mouseY) {
        for (Object obj : this.buttonList) {
            String hoverText;
            if (!(obj instanceof GuiButton)) continue;
            GuiButton button = (GuiButton)obj;
            if (!button.visible || mouseX < button.xPosition || mouseY < button.yPosition || mouseX >= button.xPosition + button.width || mouseY >= button.yPosition + button.height || button.id >= 100 && button.id <= 102 || button.id == 0 || button.id == 1) continue;
            if (button.id == 2 && (hoverText = this.modernWorldCreatingUI$getGameModeHoverText()) != null && !hoverText.isEmpty()) {
                this.drawHoveringText(Arrays.asList(hoverText), mouseX, mouseY, this.fontRendererObj);
                return;
            }
            hoverText = this.modernWorldCreatingUI$hoverTexts.get(button.id);
            if (hoverText == null || hoverText.isEmpty()) continue;
            this.drawHoveringText(Arrays.asList(hoverText), mouseX, mouseY, this.fontRendererObj);
            return;
        }
        if (this.modernWorldCreatingUI$currentTab == 100 && this.field_146333_g != null && mouseX >= this.field_146333_g.xPosition && mouseY >= this.field_146333_g.yPosition && mouseX < this.field_146333_g.xPosition + this.field_146333_g.width && mouseY < this.field_146333_g.yPosition + this.field_146333_g.height) {
            String worldName = this.field_146333_g.getText();
            String hoverText = worldName.isEmpty() ? I18n.format((String)"createworldui.hover.worldName.empty", (Object[])new Object[0]) : I18n.format((String)"createworldui.hover.worldName.filled", (Object[])new Object[]{worldName});
            this.drawHoveringText(Arrays.asList(hoverText), mouseX, mouseY, this.fontRendererObj);
            return;
        }
    }

    @Unique
    private String modernWorldCreatingUI$getGameModeHoverText() {
        if (this.field_146342_r == null) {
            return I18n.format((String)"createworldui.hover.gameMode", (Object[])new Object[0]);
        }
        switch (this.field_146342_r) {
            case "survival": {
                return I18n.format((String)"createworldui.hover.gameMode.survival", (Object[])new Object[0]);
            }
            case "creative": {
                return I18n.format((String)"createworldui.hover.gameMode.creative", (Object[])new Object[0]);
            }
            case "hardcore": {
                return I18n.format((String)"createworldui.hover.gameMode.hardcore", (Object[])new Object[0]);
            }
            case "adventure": {
                return I18n.format((String)"createworldui.hover.gameMode.adventure", (Object[])new Object[0]);
            }
        }
        return I18n.format((String)"createworldui.hover.gameMode", (Object[])new Object[0]);
    }

    @Inject(method={"actionPerformed"}, at={@At(value="HEAD")}, cancellable=true)
    private void onActionPerformed(GuiButton button, CallbackInfo ci) {
        if (button.id >= 100 && button.id <= 102) {
            this.modernWorldCreatingUI$currentTab = button.id;
            this.modernWorldCreatingUI$updateButtonVisibilityNAbility();
            ci.cancel();
            return;
        }
        if (button.id == 200) {
            this.mc.displayGuiScreen((GuiScreen)new GameRuleEditor(null));
            ci.cancel();
            return;
        }
        if (button.id == 5) {
            this.modernWorldCreatingUI$handleWorldTypeSelection();
            ci.cancel();
            return;
        }
        if (button.id == 4) {
            this.field_146341_s = !this.field_146341_s;
            this.modernWorldCreatingUI$updateButtonText();
            ci.cancel();
            return;
        }
        if (button.id == 6) {
            this.field_146340_t = this.field_146337_w ? false : !this.field_146340_t;
            this.modernWorldCreatingUI$updateButtonText();
            ci.cancel();
            return;
        }
        if (button.id == 7) {
            this.field_146338_v = this.field_146337_w ? false : !this.field_146338_v;
            this.modernWorldCreatingUI$updateButtonText();
            ci.cancel();
            return;
        }
        if (button.id == 110) {
            int next = (this.modernWorldCreatingUI$difficulty.getDifficultyId() + 1) % EnumDifficulty.values().length;
            this.modernWorldCreatingUI$difficulty = EnumDifficulty.getDifficultyEnum((int)next);
            button.displayString = this.modernWorldCreatingUI$getDifficultyText();
            this.modernWorldCreatingUI$updateButtonText();
            ci.cancel();
            return;
        }
        if (button.id == 2 || button.id == 4 || button.id == 5 || button.id == 6 || button.id == 7 || button.id == 110) {
            this.modernWorldCreatingUI$scheduleButtonTextUpdate();
        }
    }

    @Inject(method={"actionPerformed"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;launchIntegratedServer(Ljava/lang/String;Ljava/lang/String;Lnet/minecraft/world/WorldSettings;)V", shift=At.Shift.AFTER)})
    private void modernWorldCreatingUI$afterLaunchWorld(GuiButton button, CallbackInfo ci) {
        block17: {
            try {
                Object integrated = this.mc.getIntegratedServer();
                if (integrated == null) {
                    try {
                        Field fserv = Minecraft.class.getDeclaredField("theIntegratedServer");
                        fserv.setAccessible(true);
                        integrated = fserv.get(this.mc);
                    }
                    catch (Throwable fserv) {
                        // empty catch block
                    }
                }
                if (integrated == null) break block17;
                Class<?> serverClass = integrated.getClass();
                try {
                    Field worldsField = serverClass.getDeclaredField("worldServers");
                    worldsField.setAccessible(true);
                    Object[] worlds = (Object[])worldsField.get(integrated);
                    if (worlds == null || worlds.length <= 0 || worlds[0] == null) break block17;
                    Object overworld = worlds[0];
                    try {
                        Field diffField = overworld.getClass().getDeclaredField("difficultySetting");
                        diffField.setAccessible(true);
                        diffField.set(overworld, this.modernWorldCreatingUI$difficulty);
                        this.mc.gameSettings.difficulty = this.modernWorldCreatingUI$difficulty;
                        this.mc.gameSettings.saveOptions();
                    }
                    catch (NoSuchFieldException nsf) {
                        try {
                            Field diffField = overworld.getClass().getDeclaredField("field_73013_u");
                            diffField.setAccessible(true);
                            diffField.set(overworld, this.modernWorldCreatingUI$difficulty);
                            this.mc.gameSettings.difficulty = this.modernWorldCreatingUI$difficulty;
                            this.mc.gameSettings.saveOptions();
                        }
                        catch (Throwable diffField) {
                        }
                    }
                }
                catch (Throwable t) {
                    try {
                        Field tw = Minecraft.class.getDeclaredField("theWorld");
                        tw.setAccessible(true);
                        Object clientWorld = tw.get(this.mc);
                        if (clientWorld == null) break block17;
                        try {
                            Field diffField = clientWorld.getClass().getDeclaredField("difficultySetting");
                            diffField.setAccessible(true);
                            diffField.set(clientWorld, this.modernWorldCreatingUI$difficulty);
                        }
                        catch (NoSuchFieldException nsf) {
                            try {
                                Field diffField = clientWorld.getClass().getDeclaredField("field_73013_u");
                                diffField.setAccessible(true);
                                diffField.set(clientWorld, this.modernWorldCreatingUI$difficulty);
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Unique
    private void modernWorldCreatingUI$handleWorldTypeSelection() {
        do {
            this.field_146331_K = (this.field_146331_K + 1) % WorldType.worldTypes.length;
        } while (WorldType.worldTypes[this.field_146331_K] == null);
        this.modernWorldCreatingUI$updateButtonText();
        this.modernWorldCreatingUI$updateButtonVisibilityNAbility();
    }

    @Unique
    private void modernWorldCreatingUI$scheduleButtonTextUpdate() {
        Runnable updateTask = new Runnable(){

            @Override
            public void run() {
                ModernCreateWorld.this.modernWorldCreatingUI$updateButtonText();
            }
        };
        Minecraft.getMinecraft().func_152344_a(updateTask);
    }

    protected void keyTyped(char typedChar, int keyCode) {
        if (this.modernWorldCreatingUI$currentTab == 100) {
            this.field_146333_g.textboxKeyTyped(typedChar, keyCode);
            this.field_146330_J = this.field_146333_g.getText();
        } else {
            this.field_146335_h.textboxKeyTyped(typedChar, keyCode);
            this.field_146329_I = this.field_146335_h.getText();
        }
        if (keyCode == 1) {
            this.mc.displayGuiScreen(this.field_146332_f);
        }
        ((GuiButton)this.buttonList.get((int)2)).enabled = this.field_146333_g.getText().length() > 0;
        this.func_146314_g();
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.modernWorldCreatingUI$currentTab == 100) {
            this.field_146333_g.mouseClicked(mouseX, mouseY, mouseButton);
        } else {
            this.field_146335_h.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    @Unique
    private GuiButton modernWorldCreatingUI$getButtonById(int id) {
        for (Object obj : this.buttonList) {
            if (!(obj instanceof GuiButton)) continue;
            GuiButton button = (GuiButton)obj;
            if (button.id != id) continue;
            return button;
        }
        return null;
    }

    @Unique
    private void modernWorldCreatingUI$drawTiledTexture(int x, int y, int width, int height, int textureWidth, int textureHeight) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        for (int tileX = 0; tileX < width; tileX += textureWidth) {
            for (int tileY = 0; tileY < height; tileY += textureHeight) {
                int tileW = Math.min(textureWidth, width - tileX);
                int tileH = Math.min(textureHeight, height - tileY);
                double u1 = 0.0;
                double u2 = (double)tileW / (double)textureWidth;
                double v1 = 0.0;
                double v2 = (double)tileH / (double)textureHeight;
                tessellator.addVertexWithUV((double)(x + tileX), (double)(y + tileY + tileH), 0.0, u1, v2);
                tessellator.addVertexWithUV((double)(x + tileX + tileW), (double)(y + tileY + tileH), 0.0, u2, v2);
                tessellator.addVertexWithUV((double)(x + tileX + tileW), (double)(y + tileY), 0.0, u2, v1);
                tessellator.addVertexWithUV((double)(x + tileX), (double)(y + tileY), 0.0, u1, v1);
            }
        }
        tessellator.draw();
    }

    @Unique
    private void modernWorldCreatingUI$drawColoredLine(int x, int y, int width, int topColor, int bottomColor) {
        ModernCreateWorld.drawRect((int)x, (int)y, (int)(x + width), (int)(y + 1), (int)topColor);
        ModernCreateWorld.drawRect((int)x, (int)(y + 1), (int)(x + width), (int)(y + 2), (int)bottomColor);
    }

    @Shadow
    private void func_146314_g() {
    }

    @Shadow
    private void func_146319_h() {
    }
}

