/*
 * Decompiled with CFR 0.152.
 */
package decok.dfcdvadstf.createworldui.gamerule;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import decok.dfcdvadstf.createworldui.gamerule.GameRuleMonitorNSetter;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.logging.log4j.LogManager;

public class GameRuleApplier {
    private static Map<String, Object> pendingGameRules;

    public static void setPendingGameRules(Map<String, Object> gameRules) {
        pendingGameRules = gameRules;
        MinecraftForge.EVENT_BUS.register((Object)new GameRuleApplier());
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (pendingGameRules != null && !pendingGameRules.isEmpty() && event.world != null && !event.world.isRemote && event.world.provider.dimensionId == 0) {
            this.applyGameRules(event.world);
            pendingGameRules = null;
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    private void applyGameRules(World world) {
        for (Map.Entry<String, Object> entry : pendingGameRules.entrySet()) {
            GameRuleMonitorNSetter.setGamerule(world, entry.getKey(), entry.getValue());
        }
        LogManager.getLogger((String)"GameRuleApplier").info("Applied {} game rules while creating the world.", new Object[]{pendingGameRules.size()});
    }
}

