/*
 * Decompiled with CFR 0.152.
 */
package decok.dfcdvadstf.createworldui.mixin;

import decok.dfcdvadstf.createworldui.api.TabState;
import decok.dfcdvadstf.createworldui.gamerule.GameRuleEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiCreateWorld.class})
public abstract class ModernCreateWorld
extends GuiScreen {
    @Shadow
    private GuiScreen field_146332_f;
    @Shadow
    private boolean field_146337_w;
    @Shadow
    private String field_146330_J;
    @Shadow
    private String field_146342_r;
    @Shadow
    private String field_146329_I;
    @Shadow
    private boolean field_146341_s;
    @Shadow
    private boolean field_146338_v;
    @Shadow
    private boolean field_146340_t;
    @Shadow
    private GuiTextField field_146335_h;
    @Shadow
    private GuiTextField field_146333_g;
    @Shadow
    private GuiButton field_146321_E;
    @Shadow
    private GuiButton field_146343_z;
    @Shadow
    private GuiButton field_146326_C;
    @Shadow
    private GuiButton field_146320_D;
    @Shadow
    private GuiButton field_146325_B;
    @Shadow
    private GuiButton field_146322_F;
    @Shadow
    private int field_146331_K;
    @Unique
    private int modernWorldCreatingUI$currentTab = 100;
    @Unique
    private final List<GuiButton> modernWorldCreatingUI$tabButtons = new ArrayList<GuiButton>();
    @Unique
    private boolean modernWorldCreatingUI$isReorganizing = false;
    @Unique
    private static final ResourceLocation OPTIONS_BG_DARK = new ResourceLocation("createworldui:textures/gui/options_background_dark.png");
    @Unique
    private static final ResourceLocation TABS_TEXTURE = new ResourceLocation("createworldui:textures/gui/tabs.png");
    @Unique
    private static final int TAB_WIDTH = 130;
    @Unique
    private static final int TAB_HEIGHT = 24;
    @Unique
    private final Map<Integer, String> modernWorldCreatingUI$hoverTexts = new HashMap<Integer, String>();

    @Inject(method={"initGui"}, at={@At(value="HEAD")})
    private void onInitGuiHead(CallbackInfo ci) {
        this.modernWorldCreatingUI$ensureFieldsNotNull();
        this.modernWorldCreatingUI$isReorganizing = true;
    }

    @Inject(method={"initGui"}, at={@At(value="TAIL")})
    private void onInitGuiTail(CallbackInfo ci) {
        List<GuiButton> essentialButtons = this.modernWorldCreatingUI$collectEssentialButtons();
        this.field_146292_n.clear();
        this.modernWorldCreatingUI$tabButtons.clear();
        this.modernWorldCreatingUI$hoverTexts.clear();
        this.field_146292_n.addAll(essentialButtons);
        this.modernWorldCreatingUI$createTabButtons();
        this.modernWorldCreatingUI$recreateFunctionalButtons();
        this.modernWorldCreatingUI$setupTextFields();
        this.modernWorldCreatingUI$updateButtonVisibilityNAbility();
        this.modernWorldCreatingUI$repositionActionButtons();
        this.modernWorldCreatingUI$initHoverTexts();
        this.modernWorldCreatingUI$isReorganizing = false;
    }

    @Unique
    private void modernWorldCreatingUI$initHoverTexts() {
        this.modernWorldCreatingUI$hoverTexts.put(4, I18n.func_135052_a((String)"createworldui.hover.generateStructures", (Object[])new Object[0]));
        this.modernWorldCreatingUI$hoverTexts.put(5, I18n.func_135052_a((String)"createworldui.hover.worldType", (Object[])new Object[0]));
        this.modernWorldCreatingUI$hoverTexts.put(6, I18n.func_135052_a((String)"createworldui.hover.allowCheats", (Object[])new Object[0]));
        this.modernWorldCreatingUI$hoverTexts.put(7, I18n.func_135052_a((String)"createworldui.hover.bonusChest", (Object[])new Object[0]));
        this.modernWorldCreatingUI$hoverTexts.put(8, I18n.func_135052_a((String)"createworldui.hover.customize", (Object[])new Object[0]));
        this.modernWorldCreatingUI$hoverTexts.put(200, I18n.func_135052_a((String)"createworldui.hover.gameRuleEditor", (Object[])new Object[0]));
    }

    @Unique
    private void modernWorldCreatingUI$ensureFieldsNotNull() {
        if (this.field_146330_J == null) {
            this.field_146330_J = "New World";
        }
        if (this.field_146329_I == null) {
            this.field_146329_I = "";
        }
        if (this.field_146342_r == null) {
            this.field_146342_r = "survival";
        }
        if (WorldType.field_77139_a == null || this.field_146331_K >= WorldType.field_77139_a.length || WorldType.field_77139_a[this.field_146331_K] == null) {
            this.field_146331_K = 0;
        }
    }

    @Unique
    private List<GuiButton> modernWorldCreatingUI$collectEssentialButtons() {
        ArrayList<GuiButton> essentialButtons = new ArrayList<GuiButton>();
        for (GuiButton button : this.field_146292_n) {
            if (button.field_146127_k != 0 && button.field_146127_k != 1) continue;
            essentialButtons.add(button);
        }
        return essentialButtons;
    }

    @Unique
    private void modernWorldCreatingUI$recreateFunctionalButtons() {
        this.field_146343_z = new GuiButton(2, this.field_146294_l / 2 - 100, this.field_146295_m / 2, 200, 20, "");
        this.field_146292_n.add(this.field_146343_z);
        this.field_146325_B = new GuiButton(4, this.field_146294_l / 2 + 30, this.field_146295_m / 2 + 15, 98, 20, "");
        this.field_146292_n.add(this.field_146325_B);
        this.field_146326_C = new GuiButton(7, this.field_146294_l / 2 + 30, this.field_146295_m / 2 - 15, 44, 20, "");
        this.field_146292_n.add(this.field_146326_C);
        this.field_146320_D = new GuiButton(5, this.field_146294_l / 2 - 100, this.field_146295_m / 8 + 10, 98, 20, "");
        this.field_146292_n.add(this.field_146320_D);
        this.field_146321_E = new GuiButton(6, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 25, 200, 20, "");
        this.field_146292_n.add(this.field_146321_E);
        this.field_146322_F = new GuiButton(8, this.field_146294_l / 2, this.field_146295_m / 8 + 10, 98, 20, I18n.func_135052_a((String)"selectWorld.customizeType", (Object[])new Object[0]));
        this.field_146292_n.add(this.field_146322_F);
        this.field_146292_n.add(new GuiButton(200, this.field_146294_l / 2 - 100, this.field_146295_m / 6 + 2, 200, 20, I18n.func_135052_a((String)"createworldui.button.gameRuleEditor", (Object[])new Object[0])));
        this.modernWorldCreatingUI$updateButtonText();
    }

    @Unique
    private void modernWorldCreatingUI$setupTextFields() {
        if (this.field_146333_g != null) {
            this.field_146333_g.field_146209_f = this.field_146294_l / 2 - 100;
            this.field_146333_g.field_146210_g = this.field_146295_m / 5;
        } else {
            this.field_146333_g = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 100, 34, 200, 20);
            this.field_146333_g.func_146180_a(this.field_146330_J);
        }
        if (this.field_146335_h != null) {
            this.field_146335_h.field_146209_f = this.field_146294_l / 2 - 100;
            this.field_146335_h.field_146210_g = this.field_146295_m / 3 - 1;
        } else {
            this.field_146335_h = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 100, 44, 200, 20);
            this.field_146335_h.func_146180_a(this.field_146329_I);
        }
        this.field_146333_g.func_146195_b(true);
    }

    @Unique
    private void modernWorldCreatingUI$repositionActionButtons() {
        GuiButton createButton = this.modernWorldCreatingUI$getButtonById(0);
        GuiButton cancelButton = this.modernWorldCreatingUI$getButtonById(1);
        if (createButton != null) {
            createButton.field_146128_h = this.field_146294_l / 2 - 155;
            createButton.field_146129_i = this.field_146295_m - 28;
            createButton.field_146120_f = 150;
            createButton.field_146121_g = 20;
        }
        if (cancelButton != null) {
            cancelButton.field_146128_h = this.field_146294_l / 2 + 5;
            cancelButton.field_146129_i = this.field_146295_m - 28;
            cancelButton.field_146120_f = 150;
            cancelButton.field_146121_g = 20;
        }
    }

    @Unique
    private void modernWorldCreatingUI$createTabButtons() {
        this.modernWorldCreatingUI$tabButtons.clear();
        int totalWidth = 392;
        int startX = this.field_146294_l / 2 - totalWidth / 2;
        String[] tabNames = new String[]{I18n.func_135052_a((String)"createworldui.tab.game", (Object[])new Object[0]), I18n.func_135052_a((String)"createworldui.tab.world", (Object[])new Object[0]), I18n.func_135052_a((String)"createworldui.tab.more", (Object[])new Object[0])};
        for (int i = 0; i < 3; ++i) {
            int xPos = startX + i * 131;
            GuiButton tabButton = new GuiButton(100 + i, xPos, 0, 130, 24, tabNames[i]){

                public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
                    if (this.field_146125_m) {
                        boolean isSelected;
                        mc.func_110434_K().func_110577_a(TABS_TEXTURE);
                        boolean isHovered = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                        boolean bl = isSelected = ModernCreateWorld.this.modernWorldCreatingUI$currentTab == this.field_146127_k;
                        TabState state = isSelected ? (isHovered ? TabState.SELECTED_HOVER : TabState.SELECTED) : (isHovered ? TabState.HOVER : TabState.NORMAL);
                        this.func_73729_b(this.field_146128_h, this.field_146129_i, state.u, state.v, 130, 24);
                        this.func_73732_a(mc.field_71466_p, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, state.textColor);
                    }
                }
            };
            this.modernWorldCreatingUI$tabButtons.add(tabButton);
            this.field_146292_n.add(tabButton);
        }
    }

    @Unique
    private void modernWorldCreatingUI$updateButtonText() {
        if (this.field_146342_r == null) {
            this.field_146342_r = "survival";
        }
        if (WorldType.field_77139_a == null || this.field_146331_K >= WorldType.field_77139_a.length || WorldType.field_77139_a[this.field_146331_K] == null) {
            this.field_146331_K = 0;
        }
        this.field_146343_z.field_146126_j = I18n.func_135052_a((String)"selectWorld.gameMode", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)("selectWorld.gameMode." + this.field_146342_r), (Object[])new Object[0]);
        this.field_146325_B.field_146126_j = this.field_146341_s ? I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.off", (Object[])new Object[0]);
        this.field_146326_C.field_146126_j = this.field_146338_v && !this.field_146337_w ? I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.off", (Object[])new Object[0]);
        this.field_146320_D.field_146126_j = I18n.func_135052_a((String)"selectWorld.mapType", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)WorldType.field_77139_a[this.field_146331_K].func_77128_b(), (Object[])new Object[0]);
        this.field_146321_E.field_146126_j = I18n.func_135052_a((String)"selectWorld.allowCommands", (Object[])new Object[0]) + " " + (this.field_146340_t && !this.field_146337_w ? I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.off", (Object[])new Object[0]));
    }

    @Unique
    private void modernWorldCreatingUI$updateButtonVisibilityNAbility() {
        switch (this.modernWorldCreatingUI$currentTab) {
            case 100: {
                this.field_146343_z.field_146125_m = true;
                this.field_146321_E.field_146125_m = true;
                this.field_146325_B.field_146125_m = false;
                this.field_146326_C.field_146125_m = false;
                this.field_146320_D.field_146125_m = false;
                this.field_146322_F.field_146125_m = false;
                this.modernWorldCreatingUI$getButtonById((int)200).field_146125_m = false;
                break;
            }
            case 101: {
                this.field_146343_z.field_146125_m = false;
                this.field_146321_E.field_146125_m = false;
                this.field_146325_B.field_146125_m = true;
                this.field_146326_C.field_146125_m = true;
                this.field_146320_D.field_146125_m = true;
                this.field_146322_F.field_146124_l = WorldType.field_77139_a[this.field_146331_K].isCustomizable();
                this.field_146322_F.field_146125_m = true;
                this.modernWorldCreatingUI$getButtonById((int)200).field_146125_m = false;
                break;
            }
            case 102: {
                this.field_146343_z.field_146125_m = false;
                this.field_146321_E.field_146125_m = false;
                this.field_146325_B.field_146125_m = false;
                this.field_146326_C.field_146125_m = false;
                this.field_146320_D.field_146125_m = false;
                this.field_146322_F.field_146125_m = false;
                this.modernWorldCreatingUI$getButtonById((int)200).field_146125_m = true;
            }
        }
        this.modernWorldCreatingUI$updateButtonText();
    }

    @Overwrite
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146278_c(0);
        this.field_146297_k.func_110434_K().func_110577_a(OPTIONS_BG_DARK);
        this.modernWorldCreatingUI$drawTiledTexture(0, 0, this.field_146294_l, 22, 16, 16);
        this.modernWorldCreatingUI$drawColoredLine(0, 21, this.field_146294_l, 0xFFFFFF, 0x40FFFFFF);
        this.modernWorldCreatingUI$drawColoredLine(0, this.field_146295_m - 35, this.field_146294_l, 0x40000000, 0x40FFFFFF);
        if (this.modernWorldCreatingUI$currentTab == 100) {
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"selectWorld.enterName", (Object[])new Object[0]), this.field_146294_l / 2 - 100, this.field_146295_m / 5 - 13, 0xA0A0A0);
            this.field_146333_g.func_146194_f();
        }
        if (this.modernWorldCreatingUI$currentTab == 101) {
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"selectWorld.enterSeed", (Object[])new Object[0]), this.field_146294_l / 2 - 100, this.field_146295_m / 3 - 2 - 13, 0xA0A0A0);
            this.field_146335_h.func_146194_f();
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"createworldui.selectWorld.bonusItems", (Object[])new Object[0]), this.field_146294_l / 2 - 90, this.field_146295_m / 2 + 15 + 6, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"createworldui.selectWorld.bonusItems", (Object[])new Object[0]), this.field_146294_l / 2 - 90, this.field_146295_m / 2 - 15 + 6, 0xFFFFFF);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.modernWorldCreatingUI$drawHoverText(mouseX, mouseY);
    }

    @Unique
    private void modernWorldCreatingUI$drawHoverText(int mouseX, int mouseY) {
        for (Object obj : this.field_146292_n) {
            String hoverText;
            if (!(obj instanceof GuiButton)) continue;
            GuiButton button = (GuiButton)obj;
            if (!button.field_146125_m || mouseX < button.field_146128_h || mouseY < button.field_146129_i || mouseX >= button.field_146128_h + button.field_146120_f || mouseY >= button.field_146129_i + button.field_146121_g || button.field_146127_k >= 100 && button.field_146127_k <= 102 || button.field_146127_k == 0 || button.field_146127_k == 1) continue;
            if (button.field_146127_k == 2 && (hoverText = this.modernWorldCreatingUI$getGameModeHoverText()) != null && !hoverText.isEmpty()) {
                this.drawHoveringText(Arrays.asList(hoverText), mouseX, mouseY, this.field_146289_q);
                return;
            }
            hoverText = this.modernWorldCreatingUI$hoverTexts.get(button.field_146127_k);
            if (hoverText == null || hoverText.isEmpty()) continue;
            this.drawHoveringText(Arrays.asList(hoverText), mouseX, mouseY, this.field_146289_q);
            return;
        }
    }

    @Unique
    private String modernWorldCreatingUI$getGameModeHoverText() {
        if (this.field_146342_r == null) {
            return I18n.func_135052_a((String)"createworldui.hover.gameMode", (Object[])new Object[0]);
        }
        switch (this.field_146342_r) {
            case "survival": {
                return I18n.func_135052_a((String)"createworldui.hover.gameMode.survival", (Object[])new Object[0]);
            }
            case "creative": {
                return I18n.func_135052_a((String)"createworldui.hover.gameMode.creative", (Object[])new Object[0]);
            }
            case "hardcore": {
                return I18n.func_135052_a((String)"createworldui.hover.gameMode.hardcore", (Object[])new Object[0]);
            }
            case "adventure": {
                return I18n.func_135052_a((String)"createworldui.hover.gameMode.adventure", (Object[])new Object[0]);
            }
        }
        return I18n.func_135052_a((String)"createworldui.hover.gameMode", (Object[])new Object[0]);
    }

    @Inject(method={"actionPerformed"}, at={@At(value="HEAD")}, cancellable=true)
    private void onActionPerformed(GuiButton button, CallbackInfo ci) {
        if (button.field_146127_k >= 100 && button.field_146127_k <= 102) {
            this.modernWorldCreatingUI$currentTab = button.field_146127_k;
            this.modernWorldCreatingUI$updateButtonVisibilityNAbility();
            ci.cancel();
            return;
        }
        if (button.field_146127_k == 200) {
            this.field_146297_k.func_147108_a((GuiScreen)new GameRuleEditor(null));
            ci.cancel();
            return;
        }
        if (button.field_146127_k == 5) {
            this.modernWorldCreatingUI$handleWorldTypeSelection();
            ci.cancel();
            return;
        }
        if (button.field_146127_k == 2 || button.field_146127_k == 4 || button.field_146127_k == 5 || button.field_146127_k == 6 || button.field_146127_k == 7) {
            this.modernWorldCreatingUI$scheduleButtonTextUpdate();
        }
    }

    @Unique
    private void modernWorldCreatingUI$handleWorldTypeSelection() {
        do {
            this.field_146331_K = (this.field_146331_K + 1) % WorldType.field_77139_a.length;
        } while (WorldType.field_77139_a[this.field_146331_K] == null);
        this.modernWorldCreatingUI$updateButtonText();
        this.modernWorldCreatingUI$updateButtonVisibilityNAbility();
    }

    @Unique
    private void modernWorldCreatingUI$scheduleButtonTextUpdate() {
        Runnable updateTask = new Runnable(){

            @Override
            public void run() {
                ModernCreateWorld.this.modernWorldCreatingUI$updateButtonText();
            }
        };
        Minecraft.func_71410_x().func_152344_a(updateTask);
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (this.modernWorldCreatingUI$currentTab == 100) {
            this.field_146333_g.func_146201_a(typedChar, keyCode);
            this.field_146330_J = this.field_146333_g.func_146179_b();
        } else {
            this.field_146335_h.func_146201_a(typedChar, keyCode);
            this.field_146329_I = this.field_146335_h.func_146179_b();
        }
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(this.field_146332_f);
        }
        ((GuiButton)this.field_146292_n.get((int)2)).field_146124_l = this.field_146333_g.func_146179_b().length() > 0;
        this.func_146314_g();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.modernWorldCreatingUI$currentTab == 100) {
            this.field_146333_g.func_146192_a(mouseX, mouseY, mouseButton);
        } else {
            this.field_146335_h.func_146192_a(mouseX, mouseY, mouseButton);
        }
    }

    @Unique
    private GuiButton modernWorldCreatingUI$getButtonById(int id) {
        for (Object obj : this.field_146292_n) {
            if (!(obj instanceof GuiButton)) continue;
            GuiButton button = (GuiButton)obj;
            if (button.field_146127_k != id) continue;
            return button;
        }
        return null;
    }

    @Unique
    private void modernWorldCreatingUI$drawTiledTexture(int x, int y, int width, int height, int textureWidth, int textureHeight) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        for (int tileX = 0; tileX < width; tileX += textureWidth) {
            for (int tileY = 0; tileY < height; tileY += textureHeight) {
                int tileW = Math.min(textureWidth, width - tileX);
                int tileH = Math.min(textureHeight, height - tileY);
                double u1 = 0.0;
                double u2 = (double)tileW / (double)textureWidth;
                double v1 = 0.0;
                double v2 = (double)tileH / (double)textureHeight;
                tessellator.func_78374_a((double)(x + tileX), (double)(y + tileY + tileH), 0.0, u1, v2);
                tessellator.func_78374_a((double)(x + tileX + tileW), (double)(y + tileY + tileH), 0.0, u2, v2);
                tessellator.func_78374_a((double)(x + tileX + tileW), (double)(y + tileY), 0.0, u2, v1);
                tessellator.func_78374_a((double)(x + tileX), (double)(y + tileY), 0.0, u1, v1);
            }
        }
        tessellator.func_78381_a();
    }

    @Unique
    private void modernWorldCreatingUI$drawColoredLine(int x, int y, int width, int topColor, int bottomColor) {
        ModernCreateWorld.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + 1), (int)topColor);
        ModernCreateWorld.func_73734_a((int)x, (int)(y + 1), (int)(x + width), (int)(y + 2), (int)bottomColor);
    }

    @Shadow
    private void func_146314_g() {
    }

    @Shadow
    private void func_146319_h() {
    }
}

