/*
 * Decompiled with CFR 0.152.
 */
package decok.dfcdvadstf.createworldui.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiOptions;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.EnumDifficulty;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiOptions.class})
public class ModernOptions
extends GuiScreen {
    @Inject(method={"initGui"}, at={@At(value="TAIL")})
    private void onInitGui(CallbackInfo ci) {
        for (Object obj : this.buttonList) {
            if (!(obj instanceof GuiButton)) continue;
            GuiButton button = (GuiButton)obj;
            if (button.id != 108) continue;
            this.modernWorldCreatingUI$updateDifficultyButtonText(button);
        }
    }

    @Inject(method={"actionPerformed"}, at={@At(value="HEAD")})
    private void onActionPerformed(final GuiButton button, CallbackInfo ci) {
        if (button.id == 108) {
            Minecraft.getMinecraft().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    ModernOptions.this.modernWorldCreatingUI$updateDifficultyButtonText(button);
                }
            });
        }
    }

    @Unique
    private void modernWorldCreatingUI$updateDifficultyButtonText(GuiButton button) {
        Minecraft mc = Minecraft.getMinecraft();
        if (mc.gameSettings != null) {
            EnumDifficulty difficulty = mc.gameSettings.difficulty;
            String difficultyName = "";
            switch (difficulty) {
                case PEACEFUL: {
                    difficultyName = I18n.format((String)"options.difficulty.peaceful", (Object[])new Object[0]);
                    break;
                }
                case EASY: {
                    difficultyName = I18n.format((String)"options.difficulty.easy", (Object[])new Object[0]);
                    break;
                }
                case NORMAL: {
                    difficultyName = I18n.format((String)"options.difficulty.normal", (Object[])new Object[0]);
                    break;
                }
                case HARD: {
                    difficultyName = I18n.format((String)"options.difficulty.hard", (Object[])new Object[0]);
                }
            }
            button.displayString = I18n.format((String)"options.difficulty", (Object[])new Object[0]) + ": " + difficultyName;
        }
    }
}

