/*
 * Decompiled with CFR 0.152.
 */
package dev.popcorn.amethystplus;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.popcorn.amethystplus.config.ModConfig;
import dev.popcorn.amethystplus.earnings.EarningsOverlay;
import dev.popcorn.amethystplus.utils.ChatFmt;
import dev.popcorn.amethystplus.utils.ColorUtils;
import dev.popcorn.amethystplus.utils.KeyBindingManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Ldev/popcorn/amethystplus/AmethystPlus;", "Lnet/fabricmc/api/ClientModInitializer;", "<init>", "()V", "", "onInitializeClient", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "", "logPrefix", "Ljava/lang/String;", "AmethystPlus"})
@Environment(value=EnvType.CLIENT)
public final class AmethystPlus
implements ClientModInitializer {
    @NotNull
    private final Logger logger;
    @NotNull
    private final String logPrefix;

    public AmethystPlus() {
        Logger logger = LoggerFactory.getLogger(AmethystPlus.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.logPrefix = "[" + AmethystPlus.class.getSimpleName() + "]";
    }

    public void onInitializeClient() {
        this.logger.info(this.logPrefix + " Initializing...");
        this.logger.info(this.logPrefix + " Loading ModConfig...");
        try {
            ModConfig.Companion.load();
            this.logger.info(this.logPrefix + " Loaded ModConfig");
        }
        catch (Exception e) {
            this.logger.error(this.logPrefix + " Failed to load ModConfig", (Throwable)e);
        }
        this.logger.info(this.logPrefix + " Registering KeyBinding & Overlay...");
        try {
            KeyBindingManager.INSTANCE.init();
            this.logger.info(this.logPrefix + " Registered KeyBinding");
            EarningsOverlay overlay = new EarningsOverlay();
            overlay.init();
            this.logger.info(this.logPrefix + " Registered Overlay");
        }
        catch (Exception e) {
            this.logger.error(this.logPrefix + " Failed to register overlay", (Throwable)e);
        }
        ClientCommandRegistrationCallback.EVENT.register(AmethystPlus::onInitializeClient$lambda$0);
        ClientLifecycleEvents.CLIENT_STOPPING.register(arg_0 -> AmethystPlus.onInitializeClient$lambda$1(this, arg_0));
        this.logger.info(this.logPrefix + " Initialization Done!");
    }

    private static final void onInitializeClient$lambda$0(CommandDispatcher dispatcher, class_7157 class_71572) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"amethystplus").then(ClientCommandManager.literal((String)"status").executes(AmethystPlus::onInitializeClient$lambda$0$0)));
    }

    private static final int onInitializeClient$lambda$0$0(CommandContext ctx) {
        ModConfig cfg = ModConfig.Companion.get();
        class_5250 title = ColorUtils.INSTANCE.gradientText("[ AmethystPlus \u25b8 Status ]", -4629505, -42027);
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)title);
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"amethystplus.status.showAlarmTexts").method_10852(ChatFmt.INSTANCE.onOff(cfg.getShowAlarmTexts(), cfg.getChatOnColor(), cfg.getChatOffColor())));
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"amethystplus.status.onlyBreakClusters").method_10852(ChatFmt.INSTANCE.onOff(cfg.getOnlyBreakClusters(), cfg.getChatOnColor(), cfg.getChatOffColor())));
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"amethystplus.status.calculateTotalCost").method_10852(ChatFmt.INSTANCE.onOff(cfg.getCalculateTotalCost(), cfg.getChatOnColor(), cfg.getChatOffColor())));
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"amethystplus.status.includeShard").method_10852(ChatFmt.INSTANCE.onOff(cfg.getIncludeShard(), cfg.getChatOnColor(), cfg.getChatOffColor())));
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"amethystplus.status.unitType").method_10852((class_2561)class_2561.method_43470((String)cfg.getUnitType()).method_27692(class_124.field_1065)));
        return 1;
    }

    private static final void onInitializeClient$lambda$1(AmethystPlus this$0, class_310 it) {
        this$0.logger.info(this$0.logPrefix + " Saving ModConfig...");
        try {
            ModConfig.Companion.save();
            this$0.logger.info(this$0.logPrefix + " Saved ModConfig");
        }
        catch (Exception e) {
            this$0.logger.error(this$0.logPrefix + " Failed to save ModConfig", (Throwable)e);
        }
    }
}

