/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.api.interfaces;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface BossEntity {
    public static final float a = 0.1f;
    public static final float b = 0.1f;

    public List<UUID> getNearbyPlayers();

    public Map<UUID, Float> getDamageMap();

    default public void readBossData(CompoundTag pCompound) {
        this.getNearbyPlayers().clear();
        this.getDamageMap().clear();
        ListTag nearbyPlayersList = pCompound.m_128437_("NearbyPlayers", 10);
        for (int i = 0; i < nearbyPlayersList.size(); ++i) {
            CompoundTag playerTag = nearbyPlayersList.m_128728_(i);
            UUID playerUUID = playerTag.m_128342_("UUID");
            this.getNearbyPlayers().add(playerUUID);
        }
        ListTag damageMapList = pCompound.m_128437_("DamageMap", 10);
        for (int i = 0; i < damageMapList.size(); ++i) {
            CompoundTag damageTag = damageMapList.m_128728_(i);
            UUID playerUUID = damageTag.m_128342_("UUID");
            float damage = damageTag.m_128457_("Damage");
            this.getDamageMap().put(playerUUID, Float.valueOf(damage));
        }
    }

    default public void saveBossData(CompoundTag pCompound) {
        ListTag nearbyPlayersList = new ListTag();
        for (UUID playerUUID : this.getNearbyPlayers()) {
            CompoundTag playerTag = new CompoundTag();
            playerTag.m_128362_("UUID", playerUUID);
            nearbyPlayersList.add((Object)playerTag);
        }
        pCompound.m_128365_("NearbyPlayers", (Tag)nearbyPlayersList);
        ListTag damageMapList = new ListTag();
        for (Map.Entry<UUID, Float> entry : this.getDamageMap().entrySet()) {
            CompoundTag damageTag = new CompoundTag();
            damageTag.m_128362_("UUID", entry.getKey());
            damageTag.m_128350_("Damage", entry.getValue().floatValue());
            damageMapList.add((Object)damageTag);
        }
        pCompound.m_128365_("DamageMap", (Tag)damageMapList);
    }

    default public int getRadius() {
        return 16;
    }

    default public float scalingFactor(float a, float b, float playerCount) {
        float x = playerCount - 1.0f;
        return a * x * x + b * x + 1.0f;
    }

    default public int getHealthScale(Mob mob) {
        int defaultHealth = (int)mob.m_21233_();
        int playerCount = this.getNearbyPlayers().size() - 1;
        return (int)((float)defaultHealth * this.scalingFactor(0.1f, 0.1f, playerCount));
    }

    default public double getRequiredDamage() {
        return 50.0;
    }

    default public void initializeLoot(Level level, ItemStack stack, BlockPos pos, float offsetY) {
        for (UUID playerUUID : this.getNearbyPlayers()) {
            if (!((double)this.getDamageMap().getOrDefault(playerUUID, Float.valueOf(0.0f)).floatValue() >= this.getRequiredDamage())) continue;
            ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_(), (double)((float)pos.m_123342_() + offsetY), (double)pos.m_123343_(), stack.m_41777_());
            itemEntity.m_32064_();
            itemEntity.m_20331_(true);
            itemEntity.m_146915_(true);
            itemEntity.m_32060_();
            itemEntity.m_266426_(playerUUID);
            level.m_7967_((Entity)itemEntity);
        }
    }

    default public void initializeNearbyPlayers(Level level, Entity entity) {
        List players = level.m_45976_(Player.class, entity.m_20191_().m_82400_((double)this.getRadius()));
        for (Player player : players) {
            this.getNearbyPlayers().add(player.m_20148_());
            this.getDamageMap().put(player.m_20148_(), Float.valueOf(0.0f));
        }
    }

    default public void applyBonusHealth(Mob mob) {
        if (mob.m_21051_(Attributes.f_22276_) != null && this.getNearbyPlayers().size() > 1) {
            UUID healthModifierId = UUID.fromString("39ba0d18-24f3-4ea8-ba0d-1824f3fea88b");
            AttributeModifier existingModifier = mob.m_21051_(Attributes.f_22276_).m_22111_(healthModifierId);
            if (existingModifier != null) {
                mob.m_21051_(Attributes.f_22276_).m_22130_(existingModifier);
            }
            AttributeModifier healthModifier = new AttributeModifier(healthModifierId, "nearby_player_bonus", (double)this.getHealthScale(mob), AttributeModifier.Operation.ADDITION);
            mob.m_21051_(Attributes.f_22276_).m_22125_(healthModifier);
            mob.m_21153_((float)mob.m_21051_(Attributes.f_22276_).m_22135_());
            mob.getPersistentData().m_128379_("NearbyPlayerHealthBonus", true);
        }
    }
}

