/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.api.networking;

import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;
import pro.komaru.tridot.api.networking.Packet;
import pro.komaru.tridot.common.networking.AbstractPacketHandler;
import pro.komaru.tridot.common.networking.packets.CooldownSoundPacket;
import pro.komaru.tridot.common.networking.packets.DashParticlePacket;
import pro.komaru.tridot.common.networking.packets.DungeonSoundPacket;
import pro.komaru.tridot.common.networking.packets.SynchronizeCapabilityPacket;
import pro.komaru.tridot.common.networking.packets.UpdateBossbarPacket;
import pro.komaru.tridot.util.struct.stash.net.SyncStashObjectPacket;

public class PacketHandler
extends AbstractPacketHandler {
    public static final String PROTOCOL = "10";
    public static final SimpleChannel HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("tridot", "network"), () -> "10", "10"::equals, "10"::equals);

    public static void init() {
        int id = 0;
        HANDLER.registerMessage(id++, DashParticlePacket.class, DashParticlePacket::encode, DashParticlePacket::decode, DashParticlePacket::handle);
        HANDLER.registerMessage(id++, CooldownSoundPacket.class, CooldownSoundPacket::encode, CooldownSoundPacket::decode, CooldownSoundPacket::handle);
        HANDLER.registerMessage(id++, DungeonSoundPacket.class, DungeonSoundPacket::encode, DungeonSoundPacket::decode, DungeonSoundPacket::handle);
        HANDLER.registerMessage(id++, UpdateBossbarPacket.class, UpdateBossbarPacket::encode, UpdateBossbarPacket::decode, UpdateBossbarPacket::handle);
        HANDLER.registerMessage(id++, SynchronizeCapabilityPacket.class, SynchronizeCapabilityPacket::save, SynchronizeCapabilityPacket::new, Packet::handle);
        HANDLER.registerMessage(id++, SyncStashObjectPacket.class, SyncStashObjectPacket::save, SyncStashObjectPacket::new, Packet::handle);
    }

    public static SimpleChannel getHandler() {
        return HANDLER;
    }

    public static void sendTo(ServerPlayer playerMP, Object toSend) {
        HANDLER.sendTo(toSend, playerMP.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToAll(Object message) {
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
            PacketHandler.sendNonLocal(message, player);
        }
    }

    public static void sendNonLocal(Object msg, ServerPlayer player) {
        HANDLER.sendTo(msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendNonLocal(ServerPlayer playerMP, Object toSend) {
        if (playerMP.f_8924_.m_6982_() || !playerMP.m_36316_().getName().equals(playerMP.f_8924_.m_130009_())) {
            PacketHandler.sendTo(playerMP, toSend);
        }
    }

    public static void sendToTracking(Level world, BlockPos pos, Object msg) {
        HANDLER.send(TRACKING_CHUNK_AND_NEAR.with(() -> Pair.of((Object)world, (Object)pos)), msg);
    }

    public static void sendTo(Player entity, Object msg) {
        HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)entity), msg);
    }

    public static void sendEntity(Player entity, Object msg) {
        HANDLER.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), msg);
    }

    public static void sendToServer(Object msg) {
        HANDLER.sendToServer(msg);
    }
}

