/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.api.render.bossbars;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pro.komaru.tridot.Tridot;
import pro.komaru.tridot.api.render.bossbars.ClientBossbar;
import pro.komaru.tridot.client.BossBarsOverlay;

@OnlyIn(value=Dist.CLIENT)
public class ClientBossbarRegistry {
    private static final Map<ResourceLocation, Class<? extends ClientBossbar>> REGISTRY = new HashMap<ResourceLocation, Class<? extends ClientBossbar>>();

    public ClientBossbarRegistry() {
        ClientBossbarRegistry.register(Tridot.ofTridot("generic"), ClientBossbar.class);
    }

    public static void register(ResourceLocation id, Class<? extends ClientBossbar> bossbarClass) {
        REGISTRY.put(id, bossbarClass);
    }

    public static ClientBossbar create(ResourceLocation id, UUID uuid) {
        Class<? extends ClientBossbar> bossbarClass = REGISTRY.get(id);
        if (bossbarClass != null) {
            try {
                return bossbarClass.getConstructor(UUID.class, Component.class).newInstance(uuid, Component.m_237119_());
            }
            catch (Exception e) {
                Tridot.LOGGER.error("Could not instantiate bossbar class", (Throwable)e);
            }
        }
        return new ClientBossbar(uuid, (Component)Component.m_237119_()){

            @Override
            public void render(BossBarsOverlay overlay, GuiGraphics pGuiGraphics, int baseOffset, Minecraft mc) {
            }
        };
    }
}

