/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.gfx.particle.data;

import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.util.math.Interp;

public class GenericParticleDataBuilder {
    protected float startingValue;
    protected float middleValue;
    protected float endingValue;
    protected float rs1 = -1.0f;
    protected float rs2 = -1.0f;
    protected float rm1 = -1.0f;
    protected float rm2 = -1.0f;
    protected float re1 = -1.0f;
    protected float re2 = -1.0f;
    protected float coefficient = 1.0f;
    protected Interp startToMiddleEasing = Interp.linear;
    protected Interp middleToEndEasing = Interp.linear;

    protected GenericParticleDataBuilder(float startingValue, float middleValue, float endingValue) {
        this.startingValue = startingValue;
        this.middleValue = middleValue;
        this.endingValue = endingValue;
    }

    public GenericParticleDataBuilder setCoefficient(float coefficient) {
        this.coefficient = coefficient;
        return this;
    }

    public GenericParticleDataBuilder setEasing(Interp easing) {
        this.startToMiddleEasing = easing;
        return this;
    }

    public GenericParticleDataBuilder setEasing(Interp easing, Interp middleToEndEasing) {
        this.startToMiddleEasing = easing;
        this.middleToEndEasing = easing;
        return this;
    }

    public GenericParticleDataBuilder setRandomValue(float v1, float v2) {
        this.setRandomValue(v1, v2, -1.0f, -1.0f);
        return this;
    }

    public GenericParticleDataBuilder setRandomValue(float rs1, float rs2, float rm1, float rm2) {
        this.setRandomValue(rs1, rs2, rm1, rm2, -1.0f, -1.0f);
        return this;
    }

    public GenericParticleDataBuilder setRandomValue(float rs1, float rs2, float rm1, float rm2, float re1, float re2) {
        this.rs1 = rs1;
        this.rs2 = rs2;
        this.rm1 = rm1;
        this.rm2 = rm2;
        this.re1 = re1;
        this.re2 = re2;
        return this;
    }

    public GenericParticleData build() {
        return new GenericParticleData(this.startingValue, this.middleValue, this.endingValue, this.rs1, this.rs2, this.rm1, this.rm2, this.re1, this.re2, this.coefficient, this.startToMiddleEasing, this.middleToEndEasing);
    }
}

