/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.gfx.trail;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.joml.Vector4f;
import pro.komaru.tridot.client.gfx.trail.TrailPoint;
import pro.komaru.tridot.util.comps.phys.Pos3;

public class TrailPointBuilder {
    private final List<TrailPoint> trailPoints = new ArrayList<TrailPoint>();
    public final Supplier<Integer> trailLength;

    public TrailPointBuilder(Supplier<Integer> trailLength) {
        this.trailLength = trailLength;
    }

    public static TrailPointBuilder create(int trailLength) {
        return TrailPointBuilder.create(() -> trailLength);
    }

    public static TrailPointBuilder create(Supplier<Integer> trailLength) {
        return new TrailPointBuilder(trailLength);
    }

    public List<TrailPoint> points() {
        return this.trailPoints;
    }

    public List<TrailPoint> points(float lerp) {
        ArrayList<TrailPoint> lerpedTrailPoints = new ArrayList<TrailPoint>();
        int size = this.trailPoints.size();
        if (size > 1) {
            for (int i = 0; i < size - 2; ++i) {
                lerpedTrailPoints.add(this.trailPoints.get(i).lerp(this.trailPoints.get(i + 1), lerp));
            }
        }
        return lerpedTrailPoints;
    }

    public TrailPointBuilder add(Pos3 point) {
        return this.add(new TrailPoint(point, 0));
    }

    public TrailPointBuilder add(TrailPoint point) {
        this.trailPoints.add(point);
        return this;
    }

    public TrailPointBuilder tick() {
        int trailLength = this.trailLength.get();
        this.trailPoints.forEach(TrailPoint::tick);
        this.trailPoints.removeIf(p -> p.getTimeActive() > trailLength);
        return this;
    }

    public List<Vector4f> build() {
        return this.trailPoints.stream().map(TrailPoint::getMatrixPosition).collect(Collectors.toList());
    }
}

