/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.model.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import pro.komaru.tridot.client.model.item.CustomItemOverrides;

@OnlyIn(value=Dist.CLIENT)
public class LargeItemRenderer {
    public static ModelResourceLocation getModelResourceLocation(String modId, String item) {
        return new ModelResourceLocation(new ResourceLocation(modId, item + "_in_hand"), "inventory");
    }

    public static void bakeModel(Map<ResourceLocation, BakedModel> map, String modId, String item, CustomItemOverrides itemOverrides) {
        ModelResourceLocation modelInventory = new ModelResourceLocation(new ResourceLocation(modId, item), "inventory");
        ModelResourceLocation modelHand = new ModelResourceLocation(new ResourceLocation(modId, item + "_in_hand"), "inventory");
        BakedModel bakedModelDefault = map.get(modelInventory);
        BakedModel bakedModelHand = map.get(modelHand);
        LargeItemModel modelWrapper = new LargeItemModel(bakedModelDefault, bakedModelHand, itemOverrides);
        map.put((ResourceLocation)modelInventory, modelWrapper);
    }

    public static void bakeModel(Map<ResourceLocation, BakedModel> map, String modId, String item) {
        LargeItemRenderer.bakeModel(map, modId, item, new CustomItemOverrides());
    }

    public static class LargeItemModel
    implements BakedModel {
        private final BakedModel bakedModelDefault;
        private final BakedModel bakedModelHand;
        private final CustomItemOverrides itemOverrides;

        public LargeItemModel(BakedModel bakedModelDefault, BakedModel bakedModelHand) {
            this.bakedModelDefault = bakedModelDefault;
            this.bakedModelHand = bakedModelHand;
            this.itemOverrides = new CustomItemOverrides();
        }

        public LargeItemModel(BakedModel bakedModelDefault, BakedModel bakedModelHand, CustomItemOverrides itemOverrides) {
            this.bakedModelDefault = bakedModelDefault;
            this.bakedModelHand = bakedModelHand;
            this.itemOverrides = itemOverrides;
        }

        public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction direction, RandomSource random) {
            return this.bakedModelDefault.m_213637_(state, direction, random);
        }

        public boolean m_7541_() {
            return this.bakedModelDefault.m_7541_();
        }

        public boolean m_7539_() {
            return this.bakedModelDefault.m_7539_();
        }

        public boolean m_7547_() {
            return this.bakedModelDefault.m_7547_();
        }

        public boolean m_7521_() {
            return this.bakedModelDefault.m_7521_();
        }

        public TextureAtlasSprite m_6160_() {
            return this.bakedModelDefault.m_6160_();
        }

        public ItemOverrides m_7343_() {
            return this.itemOverrides;
        }

        public BakedModel applyTransform(ItemDisplayContext context, PoseStack poseStack, boolean applyLeftHandTransform) {
            BakedModel modelToUse = this.bakedModelDefault;
            if (context != ItemDisplayContext.GUI && context != ItemDisplayContext.GROUND && context != ItemDisplayContext.FIXED) {
                modelToUse = this.bakedModelHand;
            }
            return ForgeHooksClient.handleCameraTransforms((PoseStack)poseStack, (BakedModel)modelToUse, (ItemDisplayContext)context, (boolean)applyLeftHandTransform);
        }
    }
}

