/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.render.gui.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.event.TickEvent;
import pro.komaru.tridot.client.render.gui.overlay.OverlayHandler;
import pro.komaru.tridot.client.render.gui.overlay.OverlayInstance;
import pro.komaru.tridot.common.config.ClientConfig;
import pro.komaru.tridot.util.Log;

public class TimedOverlayInstance
implements OverlayInstance {
    private ResourceLocation location;
    private int showTick;
    private int showTime;
    public float fadeIn = 20.0f;
    public float fadeOut = 20.0f;

    @Override
    public void tick(TickEvent.ClientTickEvent event) {
        int totalDuration = (int)(this.fadeIn + (float)this.showTime + this.fadeOut);
        if (((Boolean)ClientConfig.ABILITY_OVERLAY.get()).booleanValue()) {
            if (this.showTick < totalDuration) {
                ++this.showTick;
            } else {
                OverlayHandler.killInstance(this);
            }
        }
    }

    @Override
    public void onDraw(RenderGuiOverlayEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        GuiGraphics gui = event.getGuiGraphics();
        if (((Boolean)ClientConfig.ABILITY_OVERLAY.get()).booleanValue()) {
            if (this.location == null) {
                Log.error(String.valueOf(this) + " Location is null", new Object[0]);
                this.location = new ResourceLocation("missingno");
            }
            gui.m_280168_().m_85836_();
            gui.m_280168_().m_252880_(0.0f, 0.0f, -200.0f);
            int width = mc.m_91268_().m_85445_();
            int height = mc.m_91268_().m_85446_();
            float alpha = this.getAlpha(event);
            float f = 0.1f;
            this.renderOverlay(gui, f, alpha, width, height);
            gui.m_280168_().m_85849_();
        }
    }

    private void renderOverlay(GuiGraphics gui, float f, float alpha, int width, int height) {
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        gui.m_280246_(f * alpha, f * alpha, f * alpha, alpha);
        gui.m_280163_(this.location, 0, 0, 0.0f, 0.0f, 1920, 1080, width, height);
        gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.applyModelViewMatrix();
    }

    private float getAlpha(RenderGuiOverlayEvent.Post event) {
        float alpha;
        float ticks = (float)this.showTick + event.getPartialTick();
        float totalDuration = this.fadeIn + (float)this.showTime + this.fadeOut;
        if (ticks < this.fadeIn) {
            alpha = Mth.m_14036_((float)(ticks / this.fadeIn), (float)0.0f, (float)1.0f);
        } else if (ticks < this.fadeIn + (float)this.showTime) {
            alpha = 1.0f;
        } else if (ticks < totalDuration) {
            float fadeOutProgress = (ticks - (this.fadeIn + (float)this.showTime)) / this.fadeOut;
            alpha = 1.0f - Mth.m_14036_((float)fadeOutProgress, (float)0.0f, (float)1.0f);
        } else {
            alpha = 0.0f;
        }
        return alpha;
    }

    public TimedOverlayInstance setTexture(ResourceLocation location) {
        this.location = location;
        return this;
    }

    public TimedOverlayInstance setShowTime(int time) {
        this.showTime = time;
        return this;
    }

    public TimedOverlayInstance setFadeIn(float time) {
        this.fadeIn = time;
        return this;
    }

    public TimedOverlayInstance setFadeOut(float time) {
        this.fadeOut = time;
        return this;
    }
}

