/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import pro.komaru.tridot.TridotLibClient;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.api.networking.PacketHandler;
import pro.komaru.tridot.client.sound.MusicHandler;
import pro.komaru.tridot.client.sound.MusicModifier;
import pro.komaru.tridot.common.config.CommonConfig;
import pro.komaru.tridot.common.networking.packets.DungeonSoundPacket;
import pro.komaru.tridot.common.registry.TagsRegistry;
import pro.komaru.tridot.common.registry.item.AttributeRegistry;
import pro.komaru.tridot.common.registry.item.armor.AbstractArmorRegistry;
import pro.komaru.tridot.common.registry.item.armor.SuitArmorItem;
import pro.komaru.tridot.common.registry.item.builders.AbstractArmorBuilder;
import pro.komaru.tridot.common.registry.item.types.ConfiguredShield;
import pro.komaru.tridot.util.Tmp;

public class Events {
    public static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    private static final String ARMOR_EFFECTS_TAG = "ArmorEffects";

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onJoinServer(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!event.isCanceled() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.evaluateArmorEffects((Player)player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.isCanceled()) {
            this.evaluateArmorEffects(event.getEntity());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.isCanceled()) {
            this.evaluateArmorEffects(event.getEntity());
        }
    }

    @SubscribeEvent
    public void onEquipmentChanged(LivingEquipmentChangeEvent event) {
        LivingEntity entity = event.getEntity();
        EquipmentSlot slot = event.getSlot();
        if (slot.m_254934_() && entity instanceof Player) {
            Player player = (Player)entity;
            this.evaluateArmorEffects(player);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent e) {
        Player player = e.player;
        if (!e.isCanceled() && !player.m_9236_().m_5776_()) {
            this.evaluateArmorEffects(player);
        }
    }

    @SubscribeEvent
    public void onShieldBlock(ShieldBlockEvent ev) {
        LivingEntity entity = ev.getEntity();
        ItemStack stack = entity.m_21211_();
        Item item = stack.m_41720_();
        if (item instanceof ConfiguredShield) {
            ConfiguredShield shieldItem = (ConfiguredShield)item;
            float armor = shieldItem.blockedPercent / 100.0f;
            armor = shieldItem.onPostBlock(stack, armor);
            float totalMultiplier = Math.max(Math.min(1.0f - armor, 1.0f), 0.0f);
            float reducedDamage = ev.getOriginalBlockedDamage() * totalMultiplier;
            shieldItem.onShieldBlock(ev.getDamageSource(), ev.getOriginalBlockedDamage(), stack, entity);
            ev.setBlockedDamage(reducedDamage);
        }
    }

    public void evaluateArmorEffects(Player player) {
        Set<MobEffect> currentlyApplied = this.getTrackedEffects(player);
        HashSet<MobEffect> newApplied = new HashSet<MobEffect>();
        for (Map.Entry<ArmorMaterial, List<AbstractArmorBuilder.ArmorEffectData>> entry : AbstractArmorRegistry.EFFECTS.entrySet()) {
            ArmorMaterial material = entry.getKey();
            if (!SuitArmorItem.hasCorrectArmorOn(material, player)) continue;
            for (AbstractArmorBuilder.ArmorEffectData effectData : entry.getValue()) {
                if (!effectData.condition().test(player)) continue;
                MobEffect effect = effectData.instance().get().m_19544_();
                newApplied.add(effect);
                if (player.m_21023_(effect)) continue;
                MobEffectInstance instance = effectData.instance().get();
                player.m_7292_(instance);
            }
        }
        for (MobEffect oldEffect : currentlyApplied) {
            if (newApplied.contains(oldEffect) || !player.m_21023_(oldEffect)) continue;
            player.m_21195_(oldEffect);
        }
        this.saveTrackedEffects(player, newApplied);
    }

    public Set<MobEffect> getTrackedEffects(Player player) {
        CompoundTag tag = player.getPersistentData().m_128469_(ARMOR_EFFECTS_TAG);
        HashSet<MobEffect> effects = new HashSet<MobEffect>();
        for (String key : tag.m_128431_()) {
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(key));
            if (effect == null) continue;
            effects.add(effect);
        }
        return effects;
    }

    public void saveTrackedEffects(Player player, Set<MobEffect> effects) {
        CompoundTag tag = new CompoundTag();
        for (MobEffect effect : effects) {
            tag.m_128379_(ForgeRegistries.MOB_EFFECTS.getKey((Object)effect).toString(), true);
        }
        player.getPersistentData().m_128365_(ARMOR_EFFECTS_TAG, (Tag)tag);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = event.getServer();
        if (server.m_129921_() % 100 != 0) {
            return;
        }
        for (Player player : server.m_6846_().m_11314_()) {
            for (MusicModifier modifier : MusicHandler.getModifiers()) {
                MusicModifier.DungeonMusic dungeonMusic;
                if (!(modifier instanceof MusicModifier.DungeonMusic) || !(dungeonMusic = (MusicModifier.DungeonMusic)modifier).isPlayerInStructure(player, (ServerLevel)player.m_9236_()) || TridotLibClient.DUNGEON_MUSIC_INSTANCE != null) continue;
                PacketHandler.sendTo(player, (Object)new DungeonSoundPacket(dungeonMusic.music, player.m_20185_(), player.m_20186_() + (double)(player.m_20206_() / 2.0f), player.m_20189_()));
            }
        }
    }

    @SubscribeEvent
    public void onAttack(AttackEntityEvent event) {
        Entity target = event.getTarget();
        Player attacker = event.getEntity();
        if (!(target instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)target;
        for (Map.Entry<ArmorMaterial, List<AbstractArmorBuilder.HitEffectData>> entry : AbstractArmorRegistry.HIT_EFFECTS.entrySet()) {
            ArmorMaterial material = entry.getKey();
            if (!SuitArmorItem.hasCorrectArmorOn(material, attacker)) {
                return;
            }
            for (AbstractArmorBuilder.HitEffectData effectData : entry.getValue()) {
                float chance = effectData.chance();
                if (!Tmp.rnd.chance(chance) || !effectData.condition().test(attacker)) continue;
                living.m_7292_(effectData.instance().get());
            }
        }
    }

    @SubscribeEvent
    public void disableBlock(ShieldBlockEvent event) {
        Entity entity = event.getDamageSource().m_7640_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            LivingEntity mob = event.getEntity();
            ItemStack weapon = player.m_21205_();
            if (!weapon.m_41619_() && weapon.m_204117_(TagsRegistry.CAN_DISABLE_SHIELD) && mob instanceof Player) {
                Player attacked = (Player)mob;
                attacked.m_36384_(true);
            }
        }
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent e) {
        ItemStack itemStack = e.getItemStack();
        if (itemStack.m_41783_() != null) {
            Utils.Items.addSkinTooltip(itemStack, e.getToolTip());
        }
        if (Utils.isDevelopment) {
            Stream<ResourceLocation> itemTagStream = itemStack.m_204131_().map(TagKey::f_203868_);
            if (Minecraft.m_91087_().f_91066_.f_92125_) {
                BlockItem blockItem;
                Item item;
                if (Screen.m_96637_()) {
                    Item item2;
                    if (!itemStack.m_204131_().toList().isEmpty()) {
                        e.getToolTip().add(Component.m_237119_());
                        e.getToolTip().add(Component.m_237113_((String)("ItemTags: " + String.valueOf(itemTagStream.toList()))).m_130940_(ChatFormatting.DARK_GRAY));
                    }
                    if ((item2 = itemStack.m_41720_()) instanceof BlockItem) {
                        BlockItem blockItem2 = (BlockItem)item2;
                        BlockState blockState = blockItem2.m_40614_().m_49966_();
                        Stream<ResourceLocation> blockTagStream = blockState.m_204343_().map(TagKey::f_203868_);
                        if (!blockState.m_204343_().map(TagKey::f_203868_).toList().isEmpty()) {
                            if (itemStack.m_204131_().toList().isEmpty()) {
                                e.getToolTip().add(Component.m_237119_());
                            }
                            e.getToolTip().add(Component.m_237113_((String)("BlockTags: " + String.valueOf(blockTagStream.toList()))).m_130940_(ChatFormatting.DARK_GRAY));
                        }
                    }
                } else if (!itemStack.m_204131_().toList().isEmpty() || (item = itemStack.m_41720_()) instanceof BlockItem && !(blockItem = (BlockItem)item).m_40614_().m_49966_().m_204343_().toList().isEmpty()) {
                    e.getToolTip().add(Component.m_237119_());
                    e.getToolTip().add(Component.m_237113_((String)"Press [Control] to get tags info").m_130940_(ChatFormatting.GRAY));
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        if (!event.getSource().m_269533_(DamageTypeTags.f_268490_)) {
            float incomingDamage = event.getAmount();
            if (((Boolean)CommonConfig.PERCENT_ARMOR.get()).booleanValue()) {
                if (event.getEntity().m_21051_((Attribute)AttributeRegistry.PERCENT_ARMOR.get()) == null) {
                    return;
                }
                float armor = (float)event.getEntity().m_21133_((Attribute)AttributeRegistry.PERCENT_ARMOR.get()) / 100.0f;
                float totalMultiplier = Math.max(Math.min(1.0f - armor, 1.0f), 0.0f);
                float reducedDamage = incomingDamage * totalMultiplier;
                event.setAmount(reducedDamage);
            }
        }
    }
}

