/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import pro.komaru.tridot.api.command.CommandArgument;
import pro.komaru.tridot.api.command.CommandBuilder;
import pro.komaru.tridot.api.command.CommandPart;
import pro.komaru.tridot.api.command.CommandVariant;
import pro.komaru.tridot.common.commands.parts.CommandArguments;
import pro.komaru.tridot.common.registry.item.skins.ItemSkin;
import pro.komaru.tridot.common.registry.item.skins.SkinRegistryManager;

public class ModCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        CommandArgument targets = CommandArgument.entities("targets");
        CommandArguments skinArg = CommandArguments.skin("skin");
        CommandBuilder skin = new CommandBuilder("skin").permission(p -> p.m_6761_(2));
        CommandBuilder builder = new CommandBuilder("tridot").variants(skin.variants(new CommandVariant(CommandPart.create("canApply"), targets).execute((Command<CommandSourceStack>)((Command)p -> {
            ModCommand.canApply((CommandSourceStack)p.getSource(), targets.getPlayers((CommandContext<CommandSourceStack>)p));
            return 1;
        })), new CommandVariant(CommandPart.create("apply"), targets, skinArg).execute((Command<CommandSourceStack>)((Command)p -> {
            ModCommand.applySkin((CommandSourceStack)p.getSource(), targets.getPlayers((CommandContext<CommandSourceStack>)p), skinArg.getSkin(p, "skin"));
            return 1;
        })), new CommandVariant(CommandPart.create("remove"), targets).execute((Command<CommandSourceStack>)((Command)p -> {
            ModCommand.remove((CommandSourceStack)p.getSource(), targets.getPlayers((CommandContext<CommandSourceStack>)p));
            return 1;
        }))));
        dispatcher.register(builder.permission(p -> p.m_6761_(2)).build());
    }

    private static void applySkin(CommandSourceStack command, Collection<? extends ServerPlayer> targetPlayers, ItemSkin itemSkin) throws CommandSyntaxException {
        for (ServerPlayer serverPlayer : targetPlayers) {
            ItemStack stack = serverPlayer.m_21205_();
            if (stack.m_41619_()) continue;
            if (itemSkin.appliesOn(stack)) {
                itemSkin.apply(stack);
                if (targetPlayers.size() == 1) {
                    command.m_288197_(() -> Component.m_237110_((String)"commands.tridot.skin.applied.single", (Object[])new Object[]{((ServerPlayer)targetPlayers.iterator().next()).m_5446_()}), true);
                    continue;
                }
                command.m_288197_(() -> Component.m_237110_((String)"commands.tridot.skin.applied.multiple", (Object[])new Object[]{targetPlayers.size()}), true);
                continue;
            }
            command.m_81352_((Component)Component.m_237115_((String)"commands.tridot.skin.fail"));
        }
    }

    private static void canApply(CommandSourceStack command, Collection<? extends ServerPlayer> targetPlayers) throws CommandSyntaxException {
        for (ServerPlayer serverPlayer : targetPlayers) {
            ItemStack stack = serverPlayer.m_21205_();
            if (!stack.m_41619_()) {
                ArrayList<String> skinIds = new ArrayList<String>();
                for (ItemSkin skin : SkinRegistryManager.getApplicableSkins(stack)) {
                    skinIds.add(String.valueOf(skin.id()));
                }
                String formattedSkins = String.join((CharSequence)", ", skinIds);
                command.m_288197_(() -> Component.m_237113_((String)formattedSkins), true);
                continue;
            }
            command.m_81352_((Component)Component.m_237115_((String)"commands.tridot.skin.fail"));
        }
    }

    private static void remove(CommandSourceStack command, Collection<? extends ServerPlayer> targetPlayers) throws CommandSyntaxException {
        for (ServerPlayer serverPlayer : targetPlayers) {
            ItemSkin itemSkin;
            ItemStack stack = serverPlayer.m_21205_();
            if (!stack.m_41619_() && (itemSkin = ItemSkin.itemSkin(stack)) != null) {
                CompoundTag nbt = stack.m_41784_();
                nbt.m_128473_("skin");
            }
            if (targetPlayers.size() == 1) {
                command.m_288197_(() -> Component.m_237110_((String)"commands.tridot.skin.remove.single", (Object[])new Object[]{((ServerPlayer)targetPlayers.iterator().next()).m_5446_()}), true);
                continue;
            }
            command.m_288197_(() -> Component.m_237110_((String)"commands.tridot.skin.remove.multiple", (Object[])new Object[]{targetPlayers.size()}), true);
        }
    }
}

