/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.networking.packets;

import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import pro.komaru.tridot.common.networking.packets.ClientPacket;

public abstract class PositionColorClientPacket
extends ClientPacket {
    protected final double x;
    protected final double y;
    protected final double z;
    protected final float r;
    protected final float g;
    protected final float b;
    protected final float a;

    public PositionColorClientPacket(double x, double y, double z, float r, float g, float b, float a) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public PositionColorClientPacket(double x, double y, double z, Color color) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.r = (float)color.getRed() / 255.0f;
        this.g = (float)color.getGreen() / 255.0f;
        this.b = (float)color.getBlue() / 255.0f;
        this.a = 1.0f;
    }

    public PositionColorClientPacket(BlockPos pos, Color color) {
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
        this.r = (float)color.getRed() / 255.0f;
        this.g = (float)color.getGreen() / 255.0f;
        this.b = (float)color.getBlue() / 255.0f;
        this.a = 1.0f;
    }

    public PositionColorClientPacket(Vec3 vec, Color color) {
        this.x = vec.m_7096_();
        this.y = vec.m_7098_();
        this.z = vec.m_7094_();
        this.r = (float)color.getRed() / 255.0f;
        this.g = (float)color.getGreen() / 255.0f;
        this.b = (float)color.getBlue() / 255.0f;
        this.a = 1.0f;
    }

    public PositionColorClientPacket(double x, double y, double z, Color color, float a) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.r = (float)color.getRed() / 255.0f;
        this.g = (float)color.getGreen() / 255.0f;
        this.b = (float)color.getBlue() / 255.0f;
        this.a = a;
    }

    public PositionColorClientPacket(BlockPos pos, Color color, float a) {
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
        this.r = (float)color.getRed() / 255.0f;
        this.g = (float)color.getGreen() / 255.0f;
        this.b = (float)color.getBlue() / 255.0f;
        this.a = a;
    }

    public PositionColorClientPacket(Vec3 vec, Color color, float a) {
        this.x = vec.m_7096_();
        this.y = vec.m_7098_();
        this.z = vec.m_7094_();
        this.r = (float)color.getRed() / 255.0f;
        this.g = (float)color.getGreen() / 255.0f;
        this.b = (float)color.getBlue() / 255.0f;
        this.a = a;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeFloat(this.r);
        buf.writeFloat(this.g);
        buf.writeFloat(this.b);
        buf.writeFloat(this.a);
    }

    public static <T extends PositionColorClientPacket> T decode(PacketProvider<T> provider, FriendlyByteBuf buf) {
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        float r = buf.readFloat();
        float g = buf.readFloat();
        float b = buf.readFloat();
        float a = buf.readFloat();
        return provider.getPacket(x, y, z, r, g, b, a);
    }

    public static interface PacketProvider<T extends PositionColorClientPacket> {
        public T getPacket(double var1, double var3, double var5, float var7, float var8, float var9, float var10);
    }
}

