/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.item.skins;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pro.komaru.tridot.client.gfx.text.DotStyle;
import pro.komaru.tridot.client.model.TridotModels;
import pro.komaru.tridot.client.model.armor.ArmorModel;
import pro.komaru.tridot.common.registry.item.skins.SkinBuilder;
import pro.komaru.tridot.common.registry.item.skins.SkinEntry;
import pro.komaru.tridot.common.registry.item.skins.SkinRegistryManager;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.struct.Structs;
import pro.komaru.tridot.util.struct.data.Seq;
import pro.komaru.tridot.util.struct.func.Boolf;

public class ItemSkin {
    public Seq<SkinEntry> entries = Seq.with();
    public static Col loreCol = Col.fromHex("F9D281");
    public SkinBuilder skinBuilder;

    public ItemSkin(SkinBuilder skinBuilder) {
        this.skinBuilder = skinBuilder;
    }

    public void setupSkinEntries() {
    }

    public boolean appliesOn(ItemStack stack) {
        return this.entries.contains((SkinEntry)((Object)((Boolf<SkinEntry>)e -> e.appliesOn(stack))));
    }

    public ItemStack apply(ItemStack stack) {
        stack.m_41784_().m_128359_("skin", this.skinBuilder.id);
        return stack;
    }

    @Nullable
    public Component getHoverName() {
        return this.skinBuilder.hoverName;
    }

    @Nullable
    public List<MutableComponent> getComponents() {
        return this.skinBuilder.component;
    }

    public static ItemSkin itemSkin(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        return SkinRegistryManager.get(nbt.m_128461_("skin"));
    }

    public Seq<SkinEntry> skinEntries() {
        return this.entries;
    }

    public ResourceLocation id() {
        return new ResourceLocation(this.skinBuilder.id);
    }

    public Col color() {
        return this.skinBuilder.color;
    }

    public String translatedName() {
        return Component.m_237115_((String)("item_skin." + this.id().m_214298_())).getString();
    }

    public String translatedLoreName() {
        return Component.m_237115_((String)("item_skin." + this.id().m_214298_() + ".lore")).getString();
    }

    public Component skinName() {
        return Component.m_237115_((String)this.translatedName()).m_6270_((Style)DotStyle.of().color(this.color()));
    }

    public Component skinComponent() {
        return Component.m_237115_((String)"lore.tridot.skin").m_6270_((Style)DotStyle.of().color(loreCol)).m_130946_(" ").m_7220_(this.skinName());
    }

    @OnlyIn(value=Dist.CLIENT)
    public ArmorModel getArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> _default) {
        return Structs.safeGet(this.entries.find(e -> e.appliesOn(stack)), e -> e.armorModel(entity, stack, slot, _default), () -> TridotModels.EMPTY_ARMOR);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return Structs.safeGet(this.entries.find(e -> e.appliesOn(stack)), e -> e.armorTexture(entity, stack, slot, type), () -> "tridot:textures/models/armor/skin/empty.png");
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getItemModelName(ItemStack stack) {
        return Structs.safeGet(this.entries.find(e -> e.appliesOn(stack)), e -> e.itemModel(stack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean defaultModel(Entity entity) {
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            return player.m_108564_().equals("default");
        }
        return true;
    }
}

