/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.api.level.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.time.LocalDate;
import javax.annotation.Nullable;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.api.level.loot.conditions.LootConditionsRegistry;

public class LocalDateCondition
implements LootItemCondition {
    public final IntRange dayOfMonth;
    public final IntRange month;

    LocalDateCondition(IntRange day, IntRange month) {
        this.dayOfMonth = day;
        this.month = month;
    }

    @NotNull
    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)LootConditionsRegistry.LOCAL_DATE_CONDITION.get();
    }

    public boolean test(LootContext lootContext) {
        LocalDate localdate = LocalDate.now();
        int month = localdate.getDayOfMonth();
        int day = localdate.getMonth().getValue();
        return this.dayOfMonth.m_165028_(lootContext, day) && this.month.m_165028_(lootContext, month);
    }

    public static Builder time(IntRange pDay, IntRange pMonth) {
        return new Builder(pDay, pMonth);
    }

    public static class Builder
    implements LootItemCondition.Builder {
        @Nullable
        private final IntRange day;
        private final IntRange month;

        public Builder(IntRange day, IntRange month) {
            this.day = day;
            this.month = month;
        }

        public LocalDateCondition build() {
            return new LocalDateCondition(this.day, this.month);
        }
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<LocalDateCondition> {
        public void serialize(JsonObject json, LocalDateCondition condition, JsonSerializationContext context) {
            json.add("day_of_month", context.serialize((Object)condition.dayOfMonth));
            json.add("month", context.serialize((Object)condition.month));
        }

        public LocalDateCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            IntRange dayOfMonth = (IntRange)GsonHelper.m_13836_((JsonObject)json, (String)"day_of_month", (JsonDeserializationContext)context, IntRange.class);
            IntRange month = (IntRange)GsonHelper.m_13836_((JsonObject)json, (String)"month", (JsonDeserializationContext)context, IntRange.class);
            return new LocalDateCondition(month, dayOfMonth);
        }
    }
}

