/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.gfx.particle.screen;

import com.mojang.blaze3d.vertex.BufferBuilder;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import org.joml.Vector3d;
import pro.komaru.tridot.client.ClientTick;
import pro.komaru.tridot.client.gfx.particle.TextureSheetScreenParticle;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.client.gfx.particle.data.ScreenSpriteParticleData;
import pro.komaru.tridot.client.gfx.particle.data.SpinParticleData;
import pro.komaru.tridot.client.gfx.particle.options.ScreenParticleOptions;
import pro.komaru.tridot.client.render.TridotRenderTypes;
import pro.komaru.tridot.client.render.gui.particle.ScreenParticleHandler;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.Tmp;

public class GenericScreenParticle
extends TextureSheetScreenParticle {
    public static final Random random = new Random();
    private final TridotRenderTypes.ScreenParticleRenderType renderType;
    public final ParticleEngine.MutableSpriteSet spriteSet;
    protected final ColorParticleData colorData;
    protected final GenericParticleData transparencyData;
    protected final GenericParticleData scaleData;
    public ScreenSpriteParticleData spriteData;
    protected final SpinParticleData spinData;
    protected final Consumer<GenericScreenParticle> actor;
    private final boolean tracksStack;
    private final double stackTrackXOffset;
    private final double stackTrackYOffset;
    private int lifeDelay;
    public float st;
    public float mt;
    public float et;
    public float ss;
    public float ms;
    public float es;
    public float sr;
    public float mr;
    public float er;
    public float randomSpin;
    public float uo;
    public float vo;
    float[] hsv1 = new float[3];
    float[] hsv2 = new float[3];

    public GenericScreenParticle(ClientLevel world, ScreenParticleOptions options, ParticleEngine.MutableSpriteSet spriteSet, double x, double y, double xMotion, double yMotion) {
        super(world, x, y);
        this.renderType = options.renderType;
        this.spriteSet = spriteSet;
        this.colorData = options.colorData;
        this.transparencyData = options.transparencyData;
        this.scaleData = options.scaleData;
        this.spinData = options.spinData;
        this.actor = options.actor;
        this.spriteData = options.spriteData;
        this.tracksStack = options.tracksStack;
        this.stackTrackXOffset = options.stackTrackXOffset;
        this.stackTrackYOffset = options.stackTrackYOffset;
        this.xMotion = xMotion;
        this.yMotion = yMotion;
        this.setLifetime(options.lifetime + random.nextInt(options.additionalLifetime + 1));
        this.roll = this.spinData.spinOffset + this.spinData.startingValue;
        this.randomSpin = GenericScreenParticle.pickRandomValue(0.0f, this.spinData.rsp1, this.spinData.rsp2);
        if (random.nextBoolean()) {
            this.randomSpin = -this.randomSpin;
        }
        this.roll += GenericScreenParticle.pickRandomRollValue(0.0f, this.spinData.rso1, this.spinData.rso2);
        float r1 = GenericScreenParticle.pickRandomValue(this.colorData.r1, this.colorData.rr11, this.colorData.rr12);
        float g1 = GenericScreenParticle.pickRandomValue(this.colorData.g1, this.colorData.rg11, this.colorData.rg12);
        float b1 = GenericScreenParticle.pickRandomValue(this.colorData.b1, this.colorData.rb11, this.colorData.rb12);
        float r2 = GenericScreenParticle.pickRandomValue(this.colorData.r2, this.colorData.rr21, this.colorData.rr22);
        float g2 = GenericScreenParticle.pickRandomValue(this.colorData.g2, this.colorData.rg21, this.colorData.rg22);
        float b2 = GenericScreenParticle.pickRandomValue(this.colorData.b2, this.colorData.rb21, this.colorData.rb21);
        this.st = GenericScreenParticle.pickRandomValue(this.transparencyData.startingValue, this.transparencyData.rs1, this.transparencyData.rs2);
        this.mt = GenericScreenParticle.pickRandomValue(this.transparencyData.middleValue, this.transparencyData.rm1, this.transparencyData.rm2);
        this.et = GenericScreenParticle.pickRandomValue(this.transparencyData.endingValue, this.transparencyData.re1, this.transparencyData.re2);
        this.ss = GenericScreenParticle.pickRandomValue(this.scaleData.startingValue, this.scaleData.rs1, this.scaleData.rs2);
        this.ms = GenericScreenParticle.pickRandomValue(this.scaleData.middleValue, this.scaleData.rm1, this.scaleData.rm2);
        this.es = GenericScreenParticle.pickRandomValue(this.scaleData.endingValue, this.scaleData.re1, this.scaleData.re2);
        this.sr = GenericScreenParticle.pickRandomValue(this.spinData.startingValue, this.spinData.rs1, this.spinData.rs2);
        this.mr = GenericScreenParticle.pickRandomValue(this.spinData.middleValue, this.spinData.rm1, this.spinData.rm2);
        this.er = GenericScreenParticle.pickRandomValue(this.spinData.endingValue, this.spinData.re1, this.spinData.re2);
        this.uo = random.nextFloat();
        this.vo = random.nextFloat();
        this.spriteData.init(this);
        Tmp.c1.set(r1, g1, b1);
        this.hsv1 = Tmp.c1.toHsv(this.hsv1);
        Tmp.c2.set(r2, g2, b2);
        this.hsv2 = Tmp.c2.toHsv(this.hsv2);
        this.uo = random.nextFloat();
        this.vo = random.nextFloat();
        this.updateTraits();
    }

    public void pickSprite(int spriteIndex) {
        if (spriteIndex < this.spriteSet.f_107406_.size() && spriteIndex >= 0) {
            this.setSprite((TextureAtlasSprite)this.spriteSet.f_107406_.get(spriteIndex));
        }
    }

    public static float pickRandomValue(float value, float value1, float value2) {
        if (value1 >= 0.0f && value2 >= 0.0f) {
            return value1 != value2 ? random.nextFloat(Math.min(value1, value2), Math.max(value1, value2)) : value1;
        }
        return value;
    }

    public static float pickRandomRollValue(float value, float value1, float value2) {
        if (value1 != 0.0f || value2 != 0.0f) {
            return value1 != value2 ? random.nextFloat(Math.min(value1, value2), Math.max(value1, value2)) : value1;
        }
        return value;
    }

    public void pickColor(float coeff) {
        Col col = Col.HSVtoRGB(this.hsv1[0], this.hsv1[1] * 100.0f, this.hsv1[2] * 100.0f);
        Col col2 = Col.HSVtoRGB(this.hsv2[0], this.hsv2[1] * 100.0f, this.hsv2[2] * 100.0f);
        col.lerp(col2, coeff);
        this.setColor(col.r, col.g, col.b);
    }

    public float getCurve(float multiplier) {
        return Mth.m_14036_((float)((float)this.age * multiplier / (float)this.lifetime), (float)0.0f, (float)1.0f);
    }

    protected void updateTraits() {
        this.pickColor(this.colorData.colorCurveEasing.apply(this.colorData.getProgress(this.age, this.lifetime)));
        this.quadSize = this.scaleData.getValue(this.age, this.lifetime, this.ss, this.ms, this.es);
        this.alpha = this.transparencyData.getValue(this.age, this.lifetime, this.st, this.mt, this.et);
        this.oRoll = this.roll;
        this.roll = this.roll + this.spinData.getValue(this.age, this.lifetime, this.sr, this.mr, this.er) + this.randomSpin;
        if (this.actor != null) {
            this.actor.accept(this);
        }
    }

    @Override
    public void render(BufferBuilder bufferBuilder) {
        if (this.lifeDelay > 0) {
            return;
        }
        this.spriteData.renderTick(this, ClientTick.partialTicks);
        if (this.tracksStack) {
            this.x = (double)ScreenParticleHandler.currentItemX + this.stackTrackXOffset + this.xMoved;
            this.y = (double)ScreenParticleHandler.currentItemY + this.stackTrackYOffset + this.yMoved;
        }
        super.render(bufferBuilder);
    }

    public void updateRenderTraits(float partialTicks) {
        float time = (float)this.age + partialTicks;
        this.pickColor(this.colorData.colorCurveEasing.apply(this.colorData.getProgress(time, this.lifetime)));
        this.quadSize = this.scaleData.getValue(time, this.lifetime, this.ss, this.ms, this.es);
        this.alpha = this.transparencyData.getValue(time, this.lifetime, this.st, this.mt, this.et);
    }

    @Override
    public void tick() {
        if (this.lifeDelay > 0) {
            --this.lifeDelay;
            return;
        }
        this.spriteData.tick(this);
        this.updateTraits();
        super.tick();
    }

    @Override
    public float getU0() {
        return this.spriteData.getU0(this);
    }

    @Override
    public float getU1() {
        return this.spriteData.getU1(this);
    }

    @Override
    public float getV0() {
        return this.spriteData.getV0(this);
    }

    @Override
    public float getV1() {
        return this.spriteData.getV1(this);
    }

    @Override
    public TridotRenderTypes.ScreenParticleRenderType getRenderType() {
        return this.renderType;
    }

    public void setParticleSpeed(Vector3d speed) {
        this.setParticleSpeed(speed.x, speed.y);
    }
}

