/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.gfx.postprocess;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EffectInstance;
import pro.komaru.tridot.client.gfx.postprocess.PostProcessInstance;
import pro.komaru.tridot.client.gfx.postprocess.ShaderDataBuffer;
import pro.komaru.tridot.util.Log;

public abstract class PostProcessInstanceData {
    public static final Minecraft minecraft = Minecraft.m_91087_();
    public final List<PostProcessInstance> instances = new ArrayList<PostProcessInstance>(this.getMaxInstances());
    public final ShaderDataBuffer dataBuffer = new ShaderDataBuffer();

    public abstract int getMaxInstances();

    public abstract int getDataSizePerInstance();

    public void init() {
        this.dataBuffer.generate((long)this.getMaxInstances() * (long)this.getDataSizePerInstance());
    }

    @Nullable
    public PostProcessInstance addInstance(PostProcessInstance instance) {
        if (this.instances.size() >= this.getMaxInstances()) {
            Log.warn("Failed to add shader instance to " + String.valueOf(this) + ": reached max instance count of " + this.getMaxInstances(), new Object[0]);
            return null;
        }
        this.instances.add(instance);
        return instance;
    }

    public void beforeProcess(PoseStack viewModelStack) {
        for (int i = this.instances.size() - 1; i >= 0; --i) {
            PostProcessInstance instance = this.instances.get(i);
            instance.update(minecraft.m_91297_());
            if (!instance.isRemoved()) continue;
            this.instances.remove(i);
        }
        if (this.instances.isEmpty()) {
            return;
        }
        float[] data = new float[this.instances.size() * this.getDataSizePerInstance()];
        for (int ins = 0; ins < this.instances.size(); ++ins) {
            PostProcessInstance instance = this.instances.get(ins);
            int offset = ins * this.getDataSizePerInstance();
            instance.writeDataToBuffer((index, d) -> {
                if (index >= this.getDataSizePerInstance() || index < 0) {
                    throw new IndexOutOfBoundsException((int)index);
                }
                data[offset + index.intValue()] = d.floatValue();
            });
        }
        this.dataBuffer.upload(data);
    }

    public void setDataBufferUniform(EffectInstance effectInstance, String bufferName, String countName) {
        this.dataBuffer.apply(effectInstance, bufferName);
        effectInstance.m_108960_(countName).m_142617_(this.instances.size());
    }

    public boolean isEmpty() {
        return this.instances.isEmpty();
    }
}

