/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.render.screenshake;

import net.minecraft.client.Camera;
import net.minecraft.util.Mth;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;
import pro.komaru.tridot.util.math.Interp;
import pro.komaru.tridot.util.phys.Vec3;

public class ScreenshakeInstance {
    public int progress;
    public final int duration;
    public float intensity1;
    public float intensity2;
    public float intensity3;
    public Interp intensityCurveStartEasing = Interp.linear;
    public Interp intensityCurveEndEasing = Interp.linear;
    public boolean isNormalize = true;
    public boolean isRotation = true;
    public boolean isPosition = false;
    public boolean isVector = false;
    public boolean isFov = false;
    public boolean isFovNormalize = false;
    public Vec3 vector = Vec3.zero();
    public static final ArcRandom random = Tmp.rnd;

    public ScreenshakeInstance(int duration) {
        this.duration = duration;
    }

    public ScreenshakeInstance intensity(float intensity) {
        return this.intensity(intensity, intensity);
    }

    public ScreenshakeInstance intensity(float intensity1, float intensity2) {
        return this.intensity(intensity1, intensity2, intensity2);
    }

    public ScreenshakeInstance intensity(float intensity1, float intensity2, float intensity3) {
        this.intensity1 = intensity1;
        this.intensity2 = intensity2;
        this.intensity3 = intensity3;
        return this;
    }

    public ScreenshakeInstance interp(Interp interp) {
        return this.interp(interp, interp);
    }

    public ScreenshakeInstance interp(Interp intensityCurveStartEasing, Interp intensityCurveEndEasing) {
        this.intensityCurveStartEasing = intensityCurveStartEasing;
        this.intensityCurveEndEasing = intensityCurveEndEasing;
        return this;
    }

    public ScreenshakeInstance normalize(boolean normalize) {
        this.isNormalize = normalize;
        return this;
    }

    public ScreenshakeInstance rot(boolean rotation) {
        this.isRotation = rotation;
        return this;
    }

    public ScreenshakeInstance pos(boolean position) {
        this.isPosition = position;
        return this;
    }

    public ScreenshakeInstance vec(boolean vector) {
        this.isVector = vector;
        return this;
    }

    public ScreenshakeInstance vec(Vec3 vector) {
        this.vector = vector;
        return this;
    }

    public ScreenshakeInstance randVec() {
        double angleA = random.nextDouble() * Math.PI * 2.0;
        double angleB = random.nextDouble() * Math.PI * 2.0;
        float x = (float)(Math.cos(angleA) * Math.cos(angleB));
        float y = (float)(Math.sin(angleA) * Math.cos(angleB));
        float z = (float)Math.sin(angleB);
        this.vector = new Vec3(x, y, z);
        return this;
    }

    public ScreenshakeInstance fov(boolean fov) {
        this.isFov = fov;
        return this;
    }

    public ScreenshakeInstance normalizeFov(boolean fovNormalize) {
        this.isFovNormalize = fovNormalize;
        return this;
    }

    public float updateIntensity(Camera camera) {
        ++this.progress;
        float percentage = (float)this.progress / (float)this.duration;
        if (this.intensity2 != this.intensity3) {
            float v = percentage >= 0.5f ? (percentage - 0.5f) / 0.5f : percentage / 0.5f;
            return Mth.m_14179_((float)this.intensityCurveEndEasing.apply(v), (float)this.intensity2, (float)this.intensity1);
        }
        return Mth.m_14179_((float)this.intensityCurveStartEasing.apply(percentage), (float)this.intensity1, (float)this.intensity2);
    }
}

