/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.item.builders;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;

public abstract class AbstractArmorBuilder<T extends ArmorMaterial> {
    public String name;
    public float headPercent = 20.0f;
    public float chestPercent = 35.0f;
    public float leggingsPercent = 25.0f;
    public float bootsPercent = 20.0f;
    public float headProtectionAmount;
    public float chestplateProtectionAmount;
    public float leggingsProtectionAmount;
    public float bootsProtectionAmount;
    public float toughness;
    public float knockbackResistance;
    public int enchantmentValue;
    public int[] durability = new int[]{11, 16, 16, 13};
    public int durabilityMultiplier;
    public SoundEvent equipSound = SoundEvents.f_11677_;
    public Supplier<Ingredient> repairIngredient;
    public List<ArmorEffectData> data;
    public List<HitEffectData> hitData;
    public float headAtrPercent = 20.0f;
    public float chestAtrPercent = 35.0f;
    public float leggingsAtrPercent = 25.0f;
    public float bootsAtrPercent = 20.0f;
    public Multimap<Supplier<Attribute>, AttributeData> attributeMap = HashMultimap.create();

    public AbstractArmorBuilder(String name) {
        this.name = name;
    }

    public AbstractArmorBuilder<T> addAttrs(Multimap<Supplier<Attribute>, AttributeData> map) {
        this.attributeMap.putAll(map);
        return this;
    }

    public AbstractArmorBuilder<T> setAttrs(Multimap<Supplier<Attribute>, AttributeData> map) {
        this.attributeMap = map;
        return this;
    }

    public AbstractArmorBuilder<T> addAttr(Supplier<Attribute> attribute, AttributeData mod) {
        this.attributeMap.put(attribute, (Object)mod);
        return this;
    }

    public AbstractArmorBuilder<T> hitEffects(List<HitEffectData> data) {
        this.hitData = data;
        return this;
    }

    public AbstractArmorBuilder<T> effects(List<ArmorEffectData> data) {
        this.data = data;
        return this;
    }

    public AbstractArmorBuilder<T> mul(int durabilityMul) {
        this.durabilityMultiplier = durabilityMul;
        return this;
    }

    public AbstractArmorBuilder<T> durability(int head, int chest, int leggings, int boots) {
        this.durability = new int[]{head, chest, leggings, boots};
        return this;
    }

    public AbstractArmorBuilder<T> protection(float percent) {
        float head = percent * this.headPercent / 100.0f;
        float chest = percent * this.chestPercent / 100.0f;
        float leggings = percent * this.leggingsPercent / 100.0f;
        float boots = percent * this.bootsPercent / 100.0f;
        float remainder = percent - (head + chest + leggings + boots);
        this.headProtectionAmount = head;
        this.chestplateProtectionAmount = chest += remainder;
        this.leggingsProtectionAmount = leggings;
        this.bootsProtectionAmount = boots;
        return this;
    }

    public AbstractArmorBuilder<T> atrDistribution(float head, float chest, float leggings, float boots) {
        this.headAtrPercent = head;
        this.chestAtrPercent = chest;
        this.leggingsAtrPercent = leggings;
        this.bootsAtrPercent = boots;
        return this;
    }

    public AbstractArmorBuilder<T> distribution(float head, float chest, float leggings, float boots) {
        this.headPercent = head;
        this.chestPercent = chest;
        this.leggingsPercent = leggings;
        this.bootsPercent = boots;
        return this;
    }

    public AbstractArmorBuilder<T> protection(float head, float chest, float leggings, float boots) {
        this.headProtectionAmount = head;
        this.chestplateProtectionAmount = chest;
        this.leggingsProtectionAmount = leggings;
        this.bootsProtectionAmount = boots;
        return this;
    }

    public AbstractArmorBuilder<T> enchantValue(int value) {
        this.enchantmentValue = value;
        return this;
    }

    public AbstractArmorBuilder<T> sound(SoundEvent sound) {
        this.equipSound = sound;
        return this;
    }

    public AbstractArmorBuilder<T> toughness(float value) {
        this.toughness = value;
        return this;
    }

    public AbstractArmorBuilder<T> knockbackRes(float value) {
        this.knockbackResistance = value;
        return this;
    }

    public AbstractArmorBuilder<T> ingredient(Supplier<Ingredient> value) {
        this.repairIngredient = value;
        return this;
    }

    public abstract T build();

    public record AttributeData(float value, AttributeModifier.Operation operation) {
    }

    public record HitEffectData(Supplier<MobEffectInstance> instance, Predicate<Player> condition, float chance) {
        public static final Predicate<Player> ALWAYS_TRUE = player -> true;

        public static HitEffectData createData(Supplier<MobEffect> effectSupplier) {
            return new HitEffectData(() -> new MobEffectInstance((MobEffect)effectSupplier.get(), 120), ALWAYS_TRUE, 1.0f);
        }

        public static HitEffectData createData(Supplier<MobEffectInstance> instance, Predicate<Player> condition, float chance) {
            return new HitEffectData(instance, condition, chance);
        }

        public static HitEffectData createData(Supplier<MobEffectInstance> instance, Predicate<Player> condition) {
            return new HitEffectData(instance, condition, 1.0f);
        }
    }

    public record ArmorEffectData(Supplier<MobEffectInstance> instance, Predicate<Player> condition) {
        public static final Predicate<Player> ALWAYS_TRUE = player -> true;
        public static final int INFINITE_DURATION = -1;

        public static ArmorEffectData createData(Supplier<MobEffect> effectSupplier) {
            return new ArmorEffectData(() -> new MobEffectInstance((MobEffect)effectSupplier.get(), -1), ALWAYS_TRUE);
        }

        public static ArmorEffectData createData(Supplier<MobEffectInstance> instance, Predicate<Player> condition) {
            return new ArmorEffectData(instance, condition);
        }
    }
}

