/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.item.types;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfiguredShield
extends ShieldItem {
    public boolean infiniteUse = true;
    public float blockedPercent = 100.0f;
    public int useDuration;
    public int cooldownTicks = 135;

    public ConfiguredShield(Item.Properties pProperties) {
        super(pProperties);
    }

    public ConfiguredShield(float defPercent, Item.Properties pProperties) {
        this(pProperties);
        this.blockedPercent = defPercent;
    }

    public ConfiguredShield(float defPercent, int useDuration, Item.Properties pProperties) {
        this(pProperties);
        this.blockedPercent = defPercent;
        this.useDuration = useDuration;
        this.infiniteUse = false;
    }

    public ConfiguredShield(float defPercent, int useDuration, int cooldown, Item.Properties pProperties) {
        this(pProperties);
        this.blockedPercent = defPercent;
        this.useDuration = useDuration;
        this.cooldownTicks = cooldown;
        this.infiniteUse = false;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_7373_(pStack, pLevel, pTooltip, pFlag);
        pTooltip.add((Component)Component.m_237110_((String)"tooltip.tridot.shield.block", (Object[])new Object[]{String.format("%.1f%%", Float.valueOf(this.blockedPercent))}).m_130940_(ChatFormatting.GRAY));
        pTooltip.add((Component)Component.m_237110_((String)"tooltip.tridot.shield.time", (Object[])new Object[]{this.formatDuration(this.useDuration)}).m_130940_(ChatFormatting.GRAY));
        if (!pStack.m_41720_().m_41465_()) {
            pTooltip.add((Component)Component.m_237119_());
            pTooltip.add((Component)Component.m_237115_((String)"item.unbreakable").m_130940_(ChatFormatting.BLUE));
        }
    }

    public Component formatDuration(int useDuration) {
        if (this.infiniteUse) {
            return Component.m_237115_((String)"effect.duration.infinite");
        }
        int i = Mth.m_14143_((float)useDuration);
        return Component.m_237113_((String)StringUtil.m_14404_((int)i));
    }

    public int m_8105_(ItemStack pStack) {
        return this.infiniteUse ? 72000 : this.useDuration;
    }

    public void onShieldDisable(ItemStack itemStack, Level level, Player player) {
    }

    public float onPostBlock(ItemStack stack, float armor) {
        return armor;
    }

    public void onShieldBlock(DamageSource source, float pAmount, ItemStack itemStack, LivingEntity entity) {
    }

    @NotNull
    public ItemStack m_5922_(ItemStack itemStack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.infiniteUse) {
                player.m_9236_().m_247517_(null, player.m_20183_(), SoundEvents.f_12347_, SoundSource.PLAYERS);
                itemStack.m_41622_((int)((float)itemStack.m_41776_() * 0.075f), (LivingEntity)player, p1 -> p1.m_21190_(player.m_7655_()));
                for (Item item : ForgeRegistries.ITEMS) {
                    if (!(item instanceof ConfiguredShield)) continue;
                    player.m_36335_().m_41524_(item, this.cooldownTicks);
                    this.onShieldDisable(itemStack, level, player);
                    player.m_36384_(false);
                }
            }
        }
        return super.m_5922_(itemStack, level, entity);
    }
}

