/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.util.file;

import java.io.File;
import java.util.function.Supplier;
import pro.komaru.tridot.util.file.Files;
import pro.komaru.tridot.util.struct.func.Cons2Func;
import pro.komaru.tridot.util.struct.func.FilePredicateFunc;

public class FilePredicate {
    protected FilePredicate old;
    protected String next;
    protected Cons2Func<FilePredicate, String, File> predicate;

    public static FilePredicate ofStatic(final Supplier<FilePredicate> supp) {
        return new FilePredicate(){
            {
                this.old = null;
                this.next = null;
                this.predicate = (arg_0, arg_1) -> 1.lambda$new$0((Supplier)supp, arg_0, arg_1);
            }

            private static /* synthetic */ File lambda$new$0(Supplier supp2, FilePredicate o, String n) {
                return ((FilePredicate)supp2.get()).get();
            }
        };
    }

    public static FilePredicate ofStatic(final File path) {
        return new FilePredicate(){
            {
                this.old = null;
                this.next = null;
                this.predicate = (o, n) -> path;
            }
        };
    }

    public static FilePredicate ofPredicate(final FilePredicate oldPredicate, final String nextDir) {
        return new FilePredicate(){
            {
                this.old = oldPredicate;
                this.next = nextDir;
                this.predicate = (o, n) -> new File(oldPredicate.get(), nextDir);
            }
        };
    }

    public static FilePredicateFunc ofPredicate(String next) {
        return pred -> FilePredicate.ofPredicate(pred, next);
    }

    public static FilePredicateFunc ofPredicate(FilePredicateFunc old, String next) {
        return pred -> FilePredicate.ofPredicate(old.get(pred), next);
    }

    public FilePredicate next(String next) {
        return FilePredicate.ofPredicate(this, next);
    }

    public File get() {
        File f = this.predicate.get(this.old, this.next);
        if (Files.ext(f.getName()).isBlank()) {
            f.mkdir();
        }
        return f;
    }
}

