/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.util.math;

import pro.komaru.tridot.util.math.Interp;
import pro.komaru.tridot.util.math.MthConst;
import pro.komaru.tridot.util.struct.data.Seq;

public class Mathf {
    public static final int[] signs;
    public static final int[] zeroOne;
    public static final boolean[] booleans;
    public static final float PI;
    public static final float pi;
    public static final float halfPi;
    public static final float PI2;
    public static final float E;
    public static final float radiansToDegrees;
    public static final float radDeg;
    public static final float degreesToRadians;
    public static final float degRad;
    private static final int sinBits = 14;
    private static final int sinMask = 16383;
    private static final int sinCount = 16384;
    private static final float[] sinTable;
    private static final float radFull;
    private static final float degFull = 360.0f;
    private static final float radToIndex;
    private static final float degToIndex = 45.511112f;

    public static double dst(double x, double y, double z, double x2, double y2, double z2) {
        double dx = x - x2;
        double dy = y - y2;
        double dz = z - z2;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static float lerp(float from, float to, float dst) {
        return (to - from) * Mathf.clamp(dst) + from;
    }

    public static float lerpf(float from, float to, float dst) {
        return (to - from) * dst + from;
    }

    public static int clamp(int value, int min, int max) {
        return Math.max(Math.min(value, max), min);
    }

    public static long clamp(long value, long min, long max) {
        return Math.max(Math.min(value, max), min);
    }

    public static float clamp(float value, float min, float max) {
        return Math.max(Math.min(value, max), min);
    }

    public static double clamp(double value, double min, double max) {
        return Math.max(Math.min(value, max), min);
    }

    public static float clamp(float value) {
        return Mathf.clamp(value, 0.0f, 1.0f);
    }

    public static float toFixed(float val, int points) {
        int pow = Mathf.powTen(points);
        return (float)Math.round(val * (float)pow) / (float)pow;
    }

    public static int powTen(int pow) {
        return (int)Math.pow(10.0, pow);
    }

    public static float sin(float radians) {
        return sinTable[(int)(radians * radToIndex) & 0x3FFF];
    }

    public static float cos(float radians) {
        return sinTable[(int)((radians + PI / 2.0f) * radToIndex) & 0x3FFF];
    }

    public static float slope(float fin) {
        return 1.0f - Math.abs(fin - 0.5f) * 2.0f;
    }

    public static float catmullrom(Seq<Float> points, int cur, int next, float t) {
        int p0Index = Math.max(cur - 1, 0);
        int p1Index = Math.max(cur, 0);
        int p2Index = Math.min(next, points.size - 1);
        int p3Index = Math.min(next + 1, points.size - 1);
        float p0 = points.get(p0Index).floatValue();
        float p1 = points.get(p1Index).floatValue();
        float p2 = points.get(p2Index).floatValue();
        float p3 = points.get(p3Index).floatValue();
        float t2 = t * t;
        float t3 = t2 * t;
        return 0.5f * ((-t3 + 2.0f * t2 - t) * p0 + (3.0f * t3 - 5.0f * t2 + 2.0f) * p1 + (-3.0f * t3 + 4.0f * t2 + t) * p2 + (t3 - t2) * p3);
    }

    public static float catmullrom(float p0, float p1, float p2, float p3, float t) {
        float t2 = t * t;
        float t3 = t2 * t;
        return 0.5f * ((-t3 + 2.0f * t2 - t) * p0 + (3.0f * t3 - 5.0f * t2 + 2.0f) * p1 + (-3.0f * t3 + 4.0f * t2 + t) * p2 + (t3 - t2) * p3);
    }

    public static float catmullromLength(float p0, float p1, float p2, float p3, int steps) {
        float length = 0.0f;
        float prevValue = Mathf.catmullrom(p0, p1, p2, p3, 0.0f);
        for (int i = 1; i <= steps; ++i) {
            float t = (float)i / (float)steps;
            float currentValue = Mathf.catmullrom(p0, p1, p2, p3, t);
            length += Math.abs(currentValue - prevValue);
            prevValue = currentValue;
        }
        return length;
    }

    public static float catmullromLength(Seq<Float> points, int cur, int next, int steps) {
        int p0Index = Math.max(cur - 1, 0);
        int p1Index = Math.max(cur, 0);
        int p2Index = Math.min(next, points.size - 1);
        int p3Index = Math.min(next + 1, points.size - 1);
        float p0 = points.get(p0Index).floatValue();
        float p1 = points.get(p1Index).floatValue();
        float p2 = points.get(p2Index).floatValue();
        float p3 = points.get(p3Index).floatValue();
        return Mathf.catmullromLength(p0, p1, p2, p3, steps);
    }

    public static float interpLength(Interp f, float a, float b, int steps) {
        float length = 0.0f;
        float stepSize = (b - a) / (float)steps;
        for (int i = 0; i < steps; ++i) {
            float x1 = a + (float)i * stepSize;
            float x2 = x1 + stepSize;
            float df_dx = (f.apply(x2) - f.apply(x1)) / stepSize;
            length += (float)(Math.sqrt(1.0f + df_dx * df_dx) * (double)stepSize);
        }
        return length;
    }

    static {
        int i;
        signs = new int[]{-1, 1};
        zeroOne = new int[]{0, 1};
        booleans = new boolean[]{true, false};
        pi = PI = MthConst.pi;
        halfPi = PI / 2.0f;
        PI2 = MthConst.tau;
        E = MthConst.e;
        radDeg = radiansToDegrees = 1.0f / MthConst.rad;
        degRad = degreesToRadians = MthConst.rad;
        sinTable = new float[16384];
        radFull = PI * 2.0f;
        radToIndex = 16384.0f / radFull;
        for (i = 0; i < 16384; ++i) {
            Mathf.sinTable[i] = (float)Math.sin(((float)i + 0.5f) / 16384.0f * radFull);
        }
        for (i = 0; i < 360; i += 90) {
            Mathf.sinTable[(int)((float)i * 45.511112f) & 0x3FFF] = (float)Math.sin((float)i * degreesToRadians);
        }
        Mathf.sinTable[0] = 0.0f;
        Mathf.sinTable[4096] = 1.0f;
        Mathf.sinTable[8192] = 0.0f;
        Mathf.sinTable[12288] = -1.0f;
    }
}

