/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.util.phys;

import java.io.Serializable;
import net.minecraft.nbt.CompoundTag;
import pro.komaru.tridot.util.comps.phys.Pos2;
import pro.komaru.tridot.util.comps.phys.X;
import pro.komaru.tridot.util.comps.phys.Y;
import pro.komaru.tridot.util.math.Interp;

public class Vec2
implements Pos2,
Serializable {
    public float x;
    public float y;

    public Vec2(float x, float y) {
        this.set(x, y);
    }

    public Vec2(Pos2 pos) {
        this.set(pos);
    }

    public Vec2() {
        this.set(0.0f, 0.0f);
    }

    public Vec2 cpy() {
        return new Vec2(this);
    }

    @Override
    public float x() {
        return this.x;
    }

    @Override
    public Vec2 x(float value) {
        this.x = value;
        return this;
    }

    @Override
    public float y() {
        return this.y;
    }

    @Override
    public Vec2 y(float value) {
        this.y = value;
        return this;
    }

    public <XY extends X & Y> Vec2 add(XY xy) {
        return this.add(xy, xy);
    }

    public Vec2 add(X x, Y y) {
        return this.add(x.x(), y.y());
    }

    public Vec2 add(float x, float y) {
        this.set(this.x() + x, this.y() + y);
        return this;
    }

    public <XY extends X & Y> Vec2 sub(XY xy) {
        return this.sub(xy, xy);
    }

    public Vec2 sub(X x, Y y) {
        return this.sub(x.x(), y.y());
    }

    public Vec2 sub(float x, float y) {
        return this.add(-x, -y);
    }

    public Vec2 set(Pos2 other) {
        return this.set(other.x(), other.y());
    }

    public Vec2 set(float x, float y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public Vec2 scale(float scl) {
        return this.scale(scl, scl);
    }

    public <XY extends X & Y> Vec2 scale(XY xy) {
        return this.scale(xy, xy);
    }

    public Vec2 scale(X x, Y y) {
        return this.scale(x.x(), y.y());
    }

    public Vec2 scale(float x, float y) {
        this.set(this.x() * x, this.y() * y);
        return this;
    }

    public float len2() {
        return this.x() * this.x() + this.y() * this.y();
    }

    public float len() {
        return (float)Math.sqrt(this.len2());
    }

    public Vec2 nor() {
        return this.scale(1.0f / this.len());
    }

    public net.minecraft.world.phys.Vec2 mcVec() {
        return new net.minecraft.world.phys.Vec2(this.x(), this.y());
    }

    public CompoundTag toNbtVec() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("x", this.x());
        nbt.m_128350_("y", this.y());
        return nbt;
    }

    public Vec2 fromNbtVec(CompoundTag nbt) {
        return this.set(nbt.m_128457_("x"), nbt.m_128457_("y"));
    }

    public Vec2 lerp(Pos2 pos, float progress, Interp interp) {
        float x = interp.apply(progress, this.x(), pos.x());
        float y = interp.apply(progress, this.y(), pos.y());
        return this.set(x, y);
    }

    public Vec2 rotate(float degrees) {
        float radians = (float)Math.toRadians(degrees);
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        float x = this.x();
        float y = this.y();
        this.set(x * cos - y * sin, x * sin + y * cos);
        return this;
    }

    public float angle() {
        return (float)Math.toDegrees(Math.atan2(this.y(), this.x()));
    }

    public float angleBetween(Pos2 other) {
        return other.cpypos().vec().sub(this).angle();
    }

    public float cross(Pos2 other) {
        return this.x() * other.y() - this.y() * other.x();
    }

    public Vec2 rotationFix() {
        if (this.x() > 180.0f) {
            this.x(this.x() - 360.0f);
        }
        if (this.y() > 180.0f) {
            this.y(this.y() - 360.0f);
        }
        return this;
    }

    public float dst(Pos2 b) {
        return this.cpy().sub(b).len();
    }

    public float dst2(Pos2 b) {
        return this.cpy().sub(b).len2();
    }

    public boolean posEquals(Pos2 b) {
        return b.x() == this.x() && b.y() == this.y();
    }

    public void constrain(Vec2 target, float targetDist, boolean less, boolean greater) {
        Vec2 delta = target.cpy().sub(this);
        float dst = delta.len();
        if (less && dst < targetDist) {
            return;
        }
        if (greater && dst > targetDist) {
            return;
        }
        if (dst == 0.0f) {
            this.add(targetDist, 0.0f);
            return;
        }
        float scale = targetDist / dst;
        float newX = target.x() + delta.x() * scale;
        float newY = target.y() + delta.y() * scale;
        this.set(newX, newY);
    }

    public void constrain2(Vec2 b, float targetDist, boolean less, boolean greater) {
        Vec2 delta = b.cpy().sub(this);
        float dst = delta.len();
        if (less && dst < targetDist) {
            return;
        }
        if (greater && dst > targetDist) {
            return;
        }
        if (dst == 0.0f) {
            return;
        }
        float diff = (dst - targetDist) / dst / 2.0f;
        float offsetX = delta.x() * diff;
        float offsetY = delta.y() * diff;
        this.add(offsetX, offsetY);
        b.sub(offsetX, offsetY);
    }
}

