/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.bettervillage.compat;

import com.jtorleonstudios.bettervillage.Main;
import com.jtorleonstudios.bettervillage.compat.CompatMetaData;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface ICompatProcessor {
    public static void apply(@NotNull MinecraftServer server) {
        RegistryAccess.Frozen manager = server.registryAccess();
        Registry pools = manager.lookupOrThrow(Registries.TEMPLATE_POOL);
        Optional plainsPool = pools.get(ResourceLocation.parse((String)"minecraft:village/plains/houses"));
        List plainsStructurePoolElementCounts = plainsPool.map(i -> ICompatProcessor.getPoolElementCounts((StructureTemplatePool)i.value())).orElseGet(ArrayList::new);
        ObjectArrayList plainsStructurePoolElement = plainsPool.map(i -> ICompatProcessor.getPoolElements((StructureTemplatePool)i.value())).orElseGet(ObjectArrayList::of);
        Optional desertPool = pools.get(ResourceLocation.parse((String)"minecraft:village/desert/houses"));
        List desertStructurePoolElementCounts = desertPool.map(i -> ICompatProcessor.getPoolElementCounts((StructureTemplatePool)i.value())).orElseGet(ArrayList::new);
        ObjectArrayList desertStructurePoolElement = desertPool.map(i -> ICompatProcessor.getPoolElements((StructureTemplatePool)i.value())).orElseGet(ObjectArrayList::of);
        Optional snowyPool = pools.get(ResourceLocation.parse((String)"minecraft:village/snowy/houses"));
        List snowyStructurePoolElementCounts = snowyPool.map(i -> ICompatProcessor.getPoolElementCounts((StructureTemplatePool)i.value())).orElseGet(ArrayList::new);
        ObjectArrayList snowyStructurePoolElement = snowyPool.map(i -> ICompatProcessor.getPoolElements((StructureTemplatePool)i.value())).orElseGet(ObjectArrayList::of);
        Optional savannaPool = pools.get(ResourceLocation.parse((String)"minecraft:village/savanna/houses"));
        List savannaStructurePoolElementCounts = savannaPool.map(i -> ICompatProcessor.getPoolElementCounts((StructureTemplatePool)i.value())).orElseGet(ArrayList::new);
        ObjectArrayList savannaStructurePoolElement = savannaPool.map(i -> ICompatProcessor.getPoolElements((StructureTemplatePool)i.value())).orElseGet(ObjectArrayList::of);
        Optional taigaPool = pools.get(ResourceLocation.parse((String)"minecraft:village/taiga/houses"));
        List taigaStructurePoolElementCounts = taigaPool.map(i -> ICompatProcessor.getPoolElementCounts((StructureTemplatePool)i.value())).orElseGet(ArrayList::new);
        ObjectArrayList taigaStructurePoolElement = taigaPool.map(i -> ICompatProcessor.getPoolElements((StructureTemplatePool)i.value())).orElseGet(ObjectArrayList::of);
        plainsPool.ifPresent(i -> ICompatProcessor.setPool((StructureTemplatePool)i.value(), plainsStructurePoolElementCounts, (ObjectArrayList<StructurePoolElement>)plainsStructurePoolElement));
        desertPool.ifPresent(i -> ICompatProcessor.setPool((StructureTemplatePool)i.value(), desertStructurePoolElementCounts, (ObjectArrayList<StructurePoolElement>)desertStructurePoolElement));
        snowyPool.ifPresent(i -> ICompatProcessor.setPool((StructureTemplatePool)i.value(), snowyStructurePoolElementCounts, (ObjectArrayList<StructurePoolElement>)snowyStructurePoolElement));
        savannaPool.ifPresent(i -> ICompatProcessor.setPool((StructureTemplatePool)i.value(), savannaStructurePoolElementCounts, (ObjectArrayList<StructurePoolElement>)savannaStructurePoolElement));
        taigaPool.ifPresent(i -> ICompatProcessor.setPool((StructureTemplatePool)i.value(), taigaStructurePoolElementCounts, (ObjectArrayList<StructurePoolElement>)taigaStructurePoolElement));
    }

    private static void poolReplacementProcess(StructureTemplatePool pool, List<Pair<StructurePoolElement, Integer>> elementCounts, List<StructurePoolElement> element, CompatMetaData compatMetaData, String[] sourcePoolCompat) {
        if (pool != null && !elementCounts.isEmpty()) {
            for (String structurePathId : sourcePoolCompat) {
                int countRemovedStructuredWeight = 0;
                elementCounts.removeIf(currentPair -> ((StructurePoolElement)currentPair.getFirst()).toString().contains(structurePathId));
                Iterator<StructurePoolElement> iteratorElement = element.iterator();
                while (iteratorElement.hasNext()) {
                    StructurePoolElement currentElement = iteratorElement.next();
                    if (!currentElement.toString().contains(structurePathId)) continue;
                    iteratorElement.remove();
                    ++countRemovedStructuredWeight;
                }
                if (compatMetaData.isReplaceStructures() && countRemovedStructuredWeight > 0) {
                    StructurePoolElement piece = (StructurePoolElement)StructurePoolElement.legacy((String)("bettervillage_" + structurePathId)).apply(StructureTemplatePool.Projection.RIGID);
                    for (int i = 0; i < countRemovedStructuredWeight; ++i) {
                        element.add(piece);
                    }
                    elementCounts.add((Pair<StructurePoolElement, Integer>)new Pair((Object)piece, (Object)countRemovedStructuredWeight));
                    Main.LOGGER.info(String.format("Replaced structure of %s mod for compatibility between Better Villages and %<s. (Structure weight defined by the mod %<s is set to %d, you can change the weight in the configuration of the concerned mod)", compatMetaData.getModName(), countRemovedStructuredWeight));
                    continue;
                }
                Main.LOGGER.info(String.format("Deleted structure of %s mod for compatibility between Better Villages and %<s. (Better Villages include the structures by default)", compatMetaData.getModName()));
            }
        }
    }

    private static void setPool(StructureTemplatePool pool, List<Pair<StructurePoolElement, Integer>> poolElementCounts, ObjectArrayList<StructurePoolElement> poolElement) {
        if (pool != null && !poolElementCounts.isEmpty() && !poolElement.isEmpty()) {
            pool.templates = poolElement;
            pool.rawTemplates = poolElementCounts;
        }
    }

    private static ObjectArrayList<StructurePoolElement> getPoolElements(StructureTemplatePool pool) {
        return pool == null ? new ObjectArrayList() : pool.templates;
    }

    @Contract(value="_ -> new")
    @NotNull
    private static ArrayList<Pair<StructurePoolElement, Integer>> getPoolElementCounts(StructureTemplatePool pool) {
        return pool == null ? new ArrayList<Pair<StructurePoolElement, Integer>>() : new ArrayList(pool.rawTemplates);
    }
}

