/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.thief.Register;
import io.github.mortuusars.thief.advancement.trigger.VillagerGiftTrigger;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatFormatter;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.slf4j.Logger;

public class Thief {
    public static final String ID = "thief";
    public static final Logger LOGGER = LogUtils.getLogger();

    public static void init() {
        Blocks.init();
        BlockEntityTypes.init();
        EntityTypes.init();
        Items.init();
        DataComponents.init();
        ItemSubPredicates.init();
        MenuTypes.init();
        RecipeSerializers.init();
        SoundEvents.init();
        ArgumentTypes.init();
    }

    public static ResourceLocation resource(String path) {
        return new ResourceLocation(ID, path);
    }

    public static class Blocks {
        static void init() {
        }
    }

    public static class BlockEntityTypes {
        static void init() {
        }
    }

    public static class EntityTypes {
        static void init() {
        }
    }

    public static class Items {
        static void init() {
        }
    }

    public static class DataComponents {
        static void init() {
        }
    }

    public static class ItemSubPredicates {
        public static void init() {
        }
    }

    public static class MenuTypes {
        static void init() {
        }
    }

    public static class RecipeSerializers {
        static void init() {
        }
    }

    public static class SoundEvents {
        private static Supplier<SoundEvent> register(String category, String key) {
            Preconditions.checkState((category != null && !category.isEmpty() ? 1 : 0) != 0, (Object)"'category' should not be empty.");
            Preconditions.checkState((key != null && !key.isEmpty() ? 1 : 0) != 0, (Object)"'key' should not be empty.");
            String path = category + "." + key;
            return Register.soundEvent(path, () -> SoundEvent.m_262824_((ResourceLocation)Thief.resource(path)));
        }

        static void init() {
        }
    }

    public static class ArgumentTypes {
        public static void init() {
        }
    }

    public static class Registries {
    }

    public static class Tags {

        public static class Structures {
            public static final TagKey<Structure> PROTECTED = TagKey.m_203882_((ResourceKey)net.minecraft.core.registries.Registries.f_256944_, (ResourceLocation)Thief.resource("protected"));
        }

        public static class EntityTypes {
            public static final TagKey<EntityType<?>> WITNESSES = TagKey.m_203882_((ResourceKey)net.minecraft.core.registries.Registries.f_256939_, (ResourceLocation)Thief.resource("witnesses"));
            public static final TagKey<EntityType<?>> GUARDS = TagKey.m_203882_((ResourceKey)net.minecraft.core.registries.Registries.f_256939_, (ResourceLocation)Thief.resource("guards"));
        }

        public static class Blocks {
            public static final TagKey<Block> BREAK_PROTECTED_LIGHT = TagKey.m_203882_((ResourceKey)net.minecraft.core.registries.Registries.f_256747_, (ResourceLocation)Thief.resource("break_protected/light"));
            public static final TagKey<Block> BREAK_PROTECTED_MEDIUM = TagKey.m_203882_((ResourceKey)net.minecraft.core.registries.Registries.f_256747_, (ResourceLocation)Thief.resource("break_protected/medium"));
            public static final TagKey<Block> BREAK_PROTECTED_HEAVY = TagKey.m_203882_((ResourceKey)net.minecraft.core.registries.Registries.f_256747_, (ResourceLocation)Thief.resource("break_protected/heavy"));
            public static final TagKey<Block> INTERACT_PROTECTED_LIGHT = TagKey.m_203882_((ResourceKey)net.minecraft.core.registries.Registries.f_256747_, (ResourceLocation)Thief.resource("interact_protected/light"));
            public static final TagKey<Block> INTERACT_PROTECTED_MEDIUM = TagKey.m_203882_((ResourceKey)net.minecraft.core.registries.Registries.f_256747_, (ResourceLocation)Thief.resource("interact_protected/medium"));
            public static final TagKey<Block> INTERACT_PROTECTED_HEAVY = TagKey.m_203882_((ResourceKey)net.minecraft.core.registries.Registries.f_256747_, (ResourceLocation)Thief.resource("interact_protected/heavy"));
        }

        public static class Items {
            public static final TagKey<Item> VILLAGER_GIFTS = TagKey.m_203882_((ResourceKey)net.minecraft.core.registries.Registries.f_256913_, (ResourceLocation)Thief.resource("villager_gifts"));
        }
    }

    public static class LootTables {
    }

    public static class CriteriaTriggers {
        public static VillagerGiftTrigger VILLAGER_GIFT = new VillagerGiftTrigger();

        public static void register() {
            net.minecraft.advancements.CriteriaTriggers.m_10595_((CriterionTrigger)VILLAGER_GIFT);
        }
    }

    public static class Stats {
        private static final Map<ResourceLocation, StatFormatter> STATS = new HashMap<ResourceLocation, StatFormatter>();
        public static final ResourceLocation CAUGHT_ON_VILLAGE_LIGHT_THEFTS = Stats.register(Thief.resource("caught_at_light_thefts_in_village"), StatFormatter.f_12873_);
        public static final ResourceLocation CAUGHT_ON_VILLAGE_MEDIUM_THEFTS = Stats.register(Thief.resource("caught_at_medium_thefts_in_village"), StatFormatter.f_12873_);
        public static final ResourceLocation CAUGHT_ON_VILLAGE_HEAVY_THEFTS = Stats.register(Thief.resource("caught_at_heavy_thefts_in_village"), StatFormatter.f_12873_);

        private static ResourceLocation register(ResourceLocation location, StatFormatter formatter) {
            STATS.put(location, formatter);
            return location;
        }

        public static void register() {
            STATS.forEach((location, formatter) -> {
                Registry.m_122965_((Registry)BuiltInRegistries.f_256771_, (ResourceLocation)location, (Object)location);
                net.minecraft.stats.Stats.f_12988_.m_12899_(location, formatter);
            });
        }
    }
}

