/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.advancement.trigger;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.mortuusars.thief.Thief;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class VillagerGiftTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public static final ResourceLocation ID = Thief.resource("villager_gift");

    @NotNull
    public ResourceLocation m_7295_() {
        return ID;
    }

    @NotNull
    protected TriggerInstance createInstance(JsonObject json, @NotNull ContextAwarePredicate predicate, @NotNull DeserializationContext deserializationContext) {
        EntityPredicate entityPredicate = EntityPredicate.m_36614_((JsonElement)json.get("entity"));
        ItemPredicate itemPredicate = ItemPredicate.m_45051_((JsonElement)json.get("gift"));
        return new TriggerInstance(predicate, entityPredicate, itemPredicate);
    }

    public void trigger(ServerPlayer player, LivingEntity entity, ItemStack gift) {
        this.m_66234_(player, triggerInstance -> triggerInstance.matches(player, entity, gift));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final EntityPredicate entityPredicate;
        private final ItemPredicate itemPredicate;

        public TriggerInstance(ContextAwarePredicate predicate, EntityPredicate entityPredicate, ItemPredicate itemPredicate) {
            super(ID, predicate);
            this.entityPredicate = entityPredicate;
            this.itemPredicate = itemPredicate;
        }

        public boolean matches(ServerPlayer player, LivingEntity entity, ItemStack gift) {
            return !(!this.entityPredicate.equals(EntityPredicate.f_36550_) && !this.entityPredicate.m_36611_(player, (Entity)entity) || !this.itemPredicate.equals(ItemPredicate.f_45028_) && !this.itemPredicate.m_45049_(gift));
        }

        @NotNull
        public JsonObject m_7683_(@NotNull SerializationContext conditions) {
            JsonObject jsonobject = super.m_7683_(conditions);
            jsonobject.add("entity", this.entityPredicate.m_36606_());
            jsonobject.add("gift", this.itemPredicate.m_45048_());
            return jsonobject;
        }
    }
}

