/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.api.witness;

import io.github.mortuusars.thief.Thief;
import io.github.mortuusars.thief.api.witness.WitnessReactionHandler;
import io.github.mortuusars.thief.world.Crime;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.npc.Villager;

public class WitnessReaction {
    private static final List<WitnessReactionHandler> handlers = new ArrayList<WitnessReactionHandler>();

    public static void register(WitnessReactionHandler handler) {
        handlers.add(handler);
    }

    public static boolean handle(ServerLevel serverLevel, Crime crime, LivingEntity witness, LivingEntity criminal) {
        for (WitnessReactionHandler handler : handlers) {
            boolean result = handler.handle(serverLevel, crime, witness, criminal);
            if (!result) continue;
            return true;
        }
        return false;
    }

    static {
        WitnessReaction.register((level, crime, witness, criminal) -> {
            if (witness instanceof Villager) {
                Villager villager = (Villager)witness;
                villager.m_35518_();
                level.m_8670_((ReputationEventType)crime, (Entity)criminal, (ReputationEventHandler)villager);
                level.m_7605_((Entity)villager, (byte)13);
                return true;
            }
            return false;
        });
        WitnessReaction.register((level, crime, witness, criminal) -> {
            if (witness.m_6095_().m_204039_(Thief.Tags.EntityTypes.GUARDS) && witness instanceof NeutralMob) {
                NeutralMob neutralMob = (NeutralMob)witness;
                if (crime.shouldGuardsAttack(level, witness, criminal) && witness.m_6779_(criminal) && neutralMob.m_5448_() == null) {
                    neutralMob.m_6710_(criminal);
                    return true;
                }
            }
            return false;
        });
    }
}

