/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.event;

import com.mojang.brigadier.CommandDispatcher;
import io.github.mortuusars.thief.Config;
import io.github.mortuusars.thief.Thief;
import io.github.mortuusars.thief.command.ThiefCommand;
import io.github.mortuusars.thief.world.Reputation;
import io.github.mortuusars.thief.world.Witness;
import io.github.mortuusars.thief.world.stealth.Stealth;
import java.util.List;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;

public class CommonEvents {
    private static long lastGiftSoundPlayedAt = -1L;

    public static InteractionResult onEntityInteracted(Player player, InteractionHand hand, Entity target) {
        ServerPlayer serverPlayer;
        block9: {
            block8: {
                if (hand != InteractionHand.MAIN_HAND || !(player instanceof ServerPlayer)) break block8;
                serverPlayer = (ServerPlayer)player;
                if (target instanceof Villager) break block9;
            }
            return InteractionResult.PASS;
        }
        Villager villager = (Villager)target;
        ItemStack item = player.m_21120_(hand);
        if ((!((Boolean)Config.Common.REQUIRES_SNEAK.get()).booleanValue() || player.m_36341_()) && CommonEvents.canGift(serverPlayer, villager, item)) {
            ItemStack gift = item.m_41620_(1);
            int minorPositiveRep = villager.m_35517_().m_26195_(player.m_20148_(), gossipType -> gossipType == GossipType.MINOR_POSITIVE);
            if (minorPositiveRep < 20) {
                villager.m_35517_().m_26191_(player.m_20148_(), GossipType.MINOR_POSITIVE, ((Integer)Config.Common.GIFTS_MINOR_POSITIVE_INCREASE.get()).intValue());
            }
            villager.m_35517_().m_148175_(player.m_20148_(), GossipType.MINOR_NEGATIVE, ((Integer)Config.Common.GIFTS_MINOR_NEGATIVE_REDUCTION.get()).intValue());
            if (villager.m_6274_().m_21954_(Activity.f_37984_) && villager.m_35532_(player) > -60) {
                villager.m_6274_().m_21889_(Activity.f_37979_);
            }
            player.m_9236_().m_7605_((Entity)villager, (byte)14);
            if (player.m_9236_().m_46467_() - lastGiftSoundPlayedAt > 10L) {
                player.m_9236_().m_6269_(null, (Entity)villager, SoundEvents.f_12504_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                lastGiftSoundPlayedAt = player.m_9236_().m_46467_();
            }
            Thief.CriteriaTriggers.VILLAGER_GIFT.trigger(serverPlayer, (LivingEntity)villager, gift);
            return InteractionResult.SUCCESS;
        }
        if (!Reputation.fromValue(villager, (LivingEntity)player).canTrade()) {
            villager.m_35518_();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean canGift(ServerPlayer player, Villager villager, ItemStack item) {
        if (!((Boolean)Config.Common.GIFTS_ENABLED.get()).booleanValue()) {
            return false;
        }
        if (!item.m_204117_(Thief.Tags.Items.VILLAGER_GIFTS)) {
            return false;
        }
        int minorPositiveRep = villager.m_35517_().m_26195_(player.m_20148_(), gossipType -> gossipType == GossipType.MINOR_POSITIVE);
        int minorNegativeRep = villager.m_35517_().m_26195_(player.m_20148_(), gossipType -> gossipType == GossipType.MINOR_NEGATIVE);
        return minorPositiveRep < 20 || minorNegativeRep < 0;
    }

    public static void onPlayerTick(Player player) {
        if (ThiefCommand.showNoticeDistanceAndWitnesses && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.m_9236_().m_46467_() % 3L == 0L) {
                List<LivingEntity> witnesses = Witness.getWitnesses((LivingEntity)player);
                for (LivingEntity witness : witnesses) {
                    witness.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 4));
                }
                double radius = (double)((Integer)Config.Common.WITNESS_MAX_DISTANCE.get()).intValue() * Stealth.getVisibility((LivingEntity)serverPlayer);
                int particles = 64;
                for (int i = 0; i < particles; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)particles;
                    double x = player.m_20185_() + radius * Math.cos(angle);
                    double z = player.m_20189_() + radius * Math.sin(angle);
                    double y = player.m_20186_() + 1.0;
                    serverPlayer.m_284548_().m_8624_(serverPlayer, (ParticleOptions)ParticleTypes.f_123813_, true, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection environment) {
        ThiefCommand.register(dispatcher);
    }
}

