/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.world;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.thief.Config;
import io.github.mortuusars.thief.Thief;
import io.github.mortuusars.thief.api.witness.WitnessReaction;
import io.github.mortuusars.thief.world.PotentialCrime;
import io.github.mortuusars.thief.world.Reputation;
import io.github.mortuusars.thief.world.Witness;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public enum Crime implements ReputationEventType
{
    LIGHT("light"),
    MEDIUM("medium"),
    HEAVY("heavy");

    private static final Logger LOGGER;
    private final String name;

    private Crime(String name) {
        this.name = name;
    }

    public static boolean isInProtectedStructure(ServerLevel level, BlockPos pos) {
        return level.m_215010_().m_220491_(pos, Thief.Tags.Structures.PROTECTED).m_73603_();
    }

    public String getName() {
        return this.name;
    }

    public int getMajorNegativeChange() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> (Integer)Config.Common.PUNISHMENT_LIGHT_MAJOR_NEGATIVE.get();
            case 1 -> (Integer)Config.Common.PUNISHMENT_MEDIUM_MAJOR_NEGATIVE.get();
            case 2 -> (Integer)Config.Common.PUNISHMENT_HEAVY_MAJOR_NEGATIVE.get();
        };
    }

    public int getMinorNegativeChange() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> (Integer)Config.Common.PUNISHMENT_LIGHT_MINOR_NEGATIVE.get();
            case 1 -> (Integer)Config.Common.PUNISHMENT_MEDIUM_MINOR_NEGATIVE.get();
            case 2 -> (Integer)Config.Common.PUNISHMENT_HEAVY_MINOR_NEGATIVE.get();
        };
    }

    public ResourceLocation getStat() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> Thief.Stats.CAUGHT_ON_VILLAGE_LIGHT_THEFTS;
            case 1 -> Thief.Stats.CAUGHT_ON_VILLAGE_MEDIUM_THEFTS;
            case 2 -> Thief.Stats.CAUGHT_ON_VILLAGE_HEAVY_THEFTS;
        };
    }

    public boolean isOverGuardAttackThreshold() {
        return ((PotentialCrime)((Object)Config.Common.GUARD_ATTACK_THRESHOLD.get())).getCrime().map(crime -> this.ordinal() >= crime.ordinal()).orElse(false);
    }

    public boolean shouldGuardsAttack(ServerLevel level, LivingEntity witness, LivingEntity criminal) {
        return this.isOverGuardAttackThreshold() && !Reputation.averageFromCrowd(criminal, Witness.getWitnesses(criminal)).ignores(this);
    }

    public String toString() {
        return this.name;
    }

    public Outcome commit(ServerLevel level, LivingEntity criminal, BlockPos crimeTargetPosition) {
        if (((Boolean)Config.Common.HERO_OF_THE_VILLAGE_CAN_STEAL.get()).booleanValue() && criminal.m_21023_(MobEffects.f_19595_)) {
            return Outcome.NONE;
        }
        if (((Boolean)Config.Common.CRIME_ONLY_IN_PROTECTED_STRUCTURE.get()).booleanValue() && !Crime.isInProtectedStructure(level, crimeTargetPosition)) {
            return Outcome.NONE;
        }
        List<LivingEntity> witnesses = Witness.getWitnesses(criminal);
        if (witnesses.isEmpty()) {
            return Outcome.NONE;
        }
        Reputation reputation = Reputation.averageFromCrowd(criminal, witnesses);
        if (reputation.ignores(this)) {
            return Outcome.NONE;
        }
        for (LivingEntity witness : witnesses) {
            WitnessReaction.handle(level, this, witness, criminal);
        }
        if (criminal instanceof Player) {
            Player player = (Player)criminal;
            player.m_5661_((Component)Component.m_237115_((String)("gui.thief.crime_commited." + this.getName())), true);
            player.m_36220_(this.getStat());
        }
        LOGGER.debug("{} with average reputation '{}', has commited a {} crime and was seen by {} witnesses.", new Object[]{criminal.m_7755_(), reputation.getName(), this.getName(), witnesses.size()});
        return new Outcome(true, witnesses);
    }

    public static PotentialCrime fromBlockStateBreaking(ServerPlayer player, BlockPos pos, BlockState state) {
        if (state.m_204336_(Thief.Tags.Blocks.BREAK_PROTECTED_LIGHT)) {
            return PotentialCrime.LIGHT;
        }
        if (state.m_204336_(Thief.Tags.Blocks.BREAK_PROTECTED_MEDIUM)) {
            return PotentialCrime.MEDIUM;
        }
        if (state.m_204336_(Thief.Tags.Blocks.BREAK_PROTECTED_HEAVY)) {
            return PotentialCrime.HEAVY;
        }
        return PotentialCrime.NONE;
    }

    public static PotentialCrime fromBlockStateInteracting(ServerPlayer player, BlockPos pos, BlockState state) {
        if (state.m_204336_(Thief.Tags.Blocks.INTERACT_PROTECTED_LIGHT)) {
            return PotentialCrime.LIGHT;
        }
        if (state.m_204336_(Thief.Tags.Blocks.INTERACT_PROTECTED_MEDIUM)) {
            return PotentialCrime.MEDIUM;
        }
        if (state.m_204336_(Thief.Tags.Blocks.INTERACT_PROTECTED_HEAVY)) {
            return PotentialCrime.HEAVY;
        }
        return PotentialCrime.NONE;
    }

    static {
        LOGGER = LogUtils.getLogger();
    }

    public record Outcome(boolean punished, List<LivingEntity> witnesses) {
        public static final Outcome NONE = new Outcome(false, Collections.emptyList());
    }
}

