/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief;

import io.github.mortuusars.thief.world.PotentialCrime;
import io.github.mortuusars.thief.world.Reputation;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {

    public static class Client {
        public static final ForgeConfigSpec SPEC;
        public static final ForgeConfigSpec.BooleanValue SHOW_VILLAGER_REPUTATION_TOOLTIP;

        static {
            ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
            SHOW_VILLAGER_REPUTATION_TOOLTIP = builder.comment(new String[]{" Tooltip with reputation info will be shown when looking at a Villager while holding an item tagged as '#thief:villager_gifts'.", " Default: true."}).define("show_villager_reputation_tooltip", true);
            SPEC = builder.build();
        }
    }

    public static class Common {
        public static final ForgeConfigSpec SPEC;
        public static final ForgeConfigSpec.BooleanValue CRIME_FOR_BREAKING_PROTECTED_BLOCKS;
        public static final ForgeConfigSpec.BooleanValue CRIME_FOR_INTERACTING_WITH_PROTECTED_BLOCKS;
        public static final ForgeConfigSpec.EnumValue<PotentialCrime> CRIME_FOR_KICKING_VILLAGER_OUT_OF_BED;
        public static final ForgeConfigSpec.EnumValue<PotentialCrime> CRIME_FOR_SLEEPING_IN_VILLAGERS_BED;
        public static final ForgeConfigSpec.BooleanValue CRIME_ONLY_IN_PROTECTED_STRUCTURE;
        public static final ForgeConfigSpec.IntValue WITNESS_MAX_DISTANCE;
        public static final ForgeConfigSpec.IntValue WITNESS_ALWAYS_NOTICE_DISTANCE;
        public static final ForgeConfigSpec.EnumValue<Reputation> TRADE_REPUTATION_THRESHOLD;
        public static final ForgeConfigSpec.EnumValue<PotentialCrime> GUARD_ATTACK_THRESHOLD;
        public static final ForgeConfigSpec.IntValue PUNISHMENT_LIGHT_MAJOR_NEGATIVE;
        public static final ForgeConfigSpec.IntValue PUNISHMENT_LIGHT_MINOR_NEGATIVE;
        public static final ForgeConfigSpec.IntValue PUNISHMENT_MEDIUM_MAJOR_NEGATIVE;
        public static final ForgeConfigSpec.IntValue PUNISHMENT_MEDIUM_MINOR_NEGATIVE;
        public static final ForgeConfigSpec.IntValue PUNISHMENT_HEAVY_MAJOR_NEGATIVE;
        public static final ForgeConfigSpec.IntValue PUNISHMENT_HEAVY_MINOR_NEGATIVE;
        public static final ForgeConfigSpec.BooleanValue GIFTS_ENABLED;
        public static final ForgeConfigSpec.IntValue GIFTS_MINOR_POSITIVE_INCREASE;
        public static final ForgeConfigSpec.IntValue GIFTS_MINOR_NEGATIVE_REDUCTION;
        public static final ForgeConfigSpec.BooleanValue REQUIRES_SNEAK;
        public static final ForgeConfigSpec.BooleanValue HERO_OF_THE_VILLAGE_CAN_STEAL;
        public static final ForgeConfigSpec.IntValue HERO_MAJOR_POSITIVE_INCREASE;
        public static final ForgeConfigSpec.IntValue HERO_MINOR_POSITIVE_INCREASE;
        public static final ForgeConfigSpec.BooleanValue FIX_SHIFT_CLICK_TRADE_REPUTATION;

        static {
            ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
            builder.push("crime");
            CRIME_FOR_BREAKING_PROTECTED_BLOCKS = builder.comment(new String[]{" Breaking protected blocks (#thief:break_protected/<level>) in protected structure (#thief:protected) is considered a crime.", " Default: true"}).define("breaking_protected_blocks", true);
            CRIME_FOR_INTERACTING_WITH_PROTECTED_BLOCKS = builder.comment(new String[]{" Interacting with protected blocks (#thief:interact_protected/<level>) in protected structure (#thief:protected) is considered a crime.", " Default: true"}).define("interacting_with_protected_blocks", true);
            CRIME_FOR_KICKING_VILLAGER_OUT_OF_BED = builder.comment(new String[]{" Crime severity for kicking a villager out of bed.", " Default: LIGHT"}).defineEnum("kicking_villager_out_of_bed", (Enum)PotentialCrime.LIGHT);
            CRIME_FOR_SLEEPING_IN_VILLAGERS_BED = builder.comment(new String[]{" Crime severity for sleeping in a bed that belongs to a villager.", " Default: MEDIUM"}).defineEnum("sleeping_in_villagers_bed", (Enum)PotentialCrime.MEDIUM);
            CRIME_ONLY_IN_PROTECTED_STRUCTURE = builder.comment(new String[]{" Check for crimes only in #thief:protected structures. If disabled, whole world is 'protected'.", " Default: true."}).define("crime_only_in_protected_structures", true);
            builder.pop();
            builder.push("witness");
            WITNESS_MAX_DISTANCE = builder.comment(" Max distance (in blocks) at which an entity can notice a crime.").defineInRange("max_notice_distance", 32, 1, 64);
            WITNESS_ALWAYS_NOTICE_DISTANCE = builder.comment(" Distance (in blocks) at which an entity always notices a crime, even through blocks. This value is halved when entity is sleeping.").defineInRange("always_notice_distance", 6, 0, 64);
            builder.pop();
            builder.push("punishment");
            TRADE_REPUTATION_THRESHOLD = builder.comment(new String[]{" Minimum reputation level needed for a villager to trade with the player. Anything lower will prevent the trade.", " Default: DISTRUSTED"}).defineEnum("trade_reputation_threshold", (Enum)Reputation.DISTRUSTED);
            GUARD_ATTACK_THRESHOLD = builder.comment(new String[]{" Minimum crime severity at which guards (#thief:guards) will attack the player, if not already attacking something else. Set to NONE to disable.", " Default: MEDIUM"}).defineEnum("guard_attack_threshold", (Enum)PotentialCrime.MEDIUM);
            builder.push("reputation");
            PUNISHMENT_LIGHT_MAJOR_NEGATIVE = builder.comment(" [LIGHT] Value added to 'Major Negative' reputation gossip.").defineInRange("light_major_change", 0, 0, GossipType.MAJOR_NEGATIVE.f_26275_);
            PUNISHMENT_LIGHT_MINOR_NEGATIVE = builder.comment(" [LIGHT] Value added to 'Minor Negative' reputation gossip.").defineInRange("light_minor_change", 15, 0, GossipType.MINOR_NEGATIVE.f_26275_);
            PUNISHMENT_MEDIUM_MAJOR_NEGATIVE = builder.comment(" [MEDIUM] Value added to 'Major Negative' reputation gossip.").defineInRange("medium_major_change", 5, 0, GossipType.MAJOR_NEGATIVE.f_26275_);
            PUNISHMENT_MEDIUM_MINOR_NEGATIVE = builder.comment(" [MEDIUM] Value added to 'Minor Negative' reputation gossip.").defineInRange("medium_minor_change", 25, 0, GossipType.MINOR_NEGATIVE.f_26275_);
            PUNISHMENT_HEAVY_MAJOR_NEGATIVE = builder.comment(" [HEAVY] Value added to 'Major Negative' reputation gossip.").defineInRange("heavy_major_change", 20, 0, GossipType.MAJOR_NEGATIVE.f_26275_);
            PUNISHMENT_HEAVY_MINOR_NEGATIVE = builder.comment(" [HEAVY] Value added to 'Minor Negative' reputation gossip.").defineInRange("heavy_minor_change", 50, 0, GossipType.MINOR_NEGATIVE.f_26275_);
            builder.pop();
            builder.pop();
            builder.push("gifts");
            GIFTS_ENABLED = builder.comment(new String[]{" Villagers accept gifts (#thief:villager_gifts) that will improve player's reputation with them. Just use the item on a Villager.", " Default: true"}).define("enabled", true);
            GIFTS_MINOR_POSITIVE_INCREASE = builder.comment(new String[]{" 'Minor Positive' reputation increase per gift.", " Default: 2"}).defineInRange("minor_positive_increase", 2, 0, GossipType.MINOR_POSITIVE.f_26275_);
            GIFTS_MINOR_NEGATIVE_REDUCTION = builder.comment(new String[]{" 'Minor Negative' reputation reduction per gift.", " Default: 5"}).defineInRange("minor_negative_reduction", 5, 0, GossipType.MINOR_NEGATIVE.f_26275_);
            REQUIRES_SNEAK = builder.comment(new String[]{" Giving gifts requires 'sneak' to be held.", " Default: true"}).define("requires_sneak", true);
            builder.pop();
            builder.push("hero_of_the_village");
            HERO_OF_THE_VILLAGE_CAN_STEAL = builder.comment(new String[]{" Players with 'Hero of the Village' buff can steal without consequences.", " Default: true"}).define("hero_can_steal", true);
            HERO_MAJOR_POSITIVE_INCREASE = builder.comment(new String[]{" 'Major Positive' reputation increase with nearby villagers when raid is defeated.", " Default: 2"}).defineInRange("major_positive_increase", 2, 0, GossipType.MAJOR_POSITIVE.f_26275_);
            HERO_MINOR_POSITIVE_INCREASE = builder.comment(new String[]{" 'Minor Positive' reputation increase with nearby villagers when raid is defeated.", " Default: 25"}).defineInRange("minor_positive_increase", 25, 0, GossipType.MINOR_POSITIVE.f_26275_);
            builder.pop();
            builder.push("misc");
            FIX_SHIFT_CLICK_TRADE_REPUTATION = builder.comment(new String[]{" Fix villager trade reputation (gossip) not applying properly when using shift+click to trade (shift+clicking is considered one trade operation, instead of many).", " Default: true."}).define("fix_shift_click_villager_trading_reputation", true);
            builder.pop();
            SPEC = builder.build();
        }
    }
}

