/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.client;

import io.github.mortuusars.thief.Config;
import io.github.mortuusars.thief.Thief;
import io.github.mortuusars.thief.network.Packets;
import io.github.mortuusars.thief.network.packet.serverbound.QueryVillagerReputationC2SP;
import io.github.mortuusars.thief.world.Reputation;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class VillagerReputationTooltip {
    private static int lastVillagerId = -1;
    private static long lastRequestTime = -1L;
    private static int lastReputation = 0;
    private static int lastGossipsVillagerId = -1;
    private static int lastMajorNegative;
    private static int lastMinorNegative;
    private static int lastMinorPositive;
    private static int lastMajorPositive;
    private static int lastTrading;

    public static void render(GuiGraphics guiGraphics, float partialTicks) {
        EntityHitResult entityHitResult;
        HitResult hitResult;
        if (!((Boolean)Config.Client.SHOW_VILLAGER_REPUTATION_TOOLTIP.get()).booleanValue()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null || minecraft.f_91074_ == null || minecraft.f_91074_.m_5833_() || minecraft.f_91080_ != null || !minecraft.f_91074_.m_21205_().m_204117_(Thief.Tags.Items.VILLAGER_GIFTS) || !((hitResult = minecraft.f_91077_) instanceof EntityHitResult) || !((hitResult = (entityHitResult = (EntityHitResult)hitResult).m_82443_()) instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)hitResult;
        long gameTime = minecraft.f_91073_.m_46467_();
        if (gameTime - lastRequestTime > 5L) {
            Packets.sendToServer(new QueryVillagerReputationC2SP(villager.m_19879_(), Minecraft.m_91087_().f_91066_.f_92125_));
            lastRequestTime = gameTime;
        }
        if (lastVillagerId != villager.m_19879_()) {
            return;
        }
        Reputation reputation = Reputation.fromValue(lastReputation);
        MutableComponent name = reputation.getLocalizedNameWithColor();
        if (Minecraft.m_91087_().f_91066_.f_92125_) {
            name.m_130946_(" (" + lastReputation + ")");
        }
        ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
        lines.add(Component.m_237110_((String)"gui.thief.reputation", (Object[])new Object[]{name}).m_7532_());
        lines.addAll(Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)reputation.getLocalizedDescription(), 170));
        if (Minecraft.m_91087_().f_91066_.f_92125_ && lastGossipsVillagerId == villager.m_19879_()) {
            lines.add(Component.m_237115_((String)"gui.thief.gossips").m_7532_());
            lines.add(Component.m_237110_((String)"gui.thief.gossips.major_negative", (Object[])new Object[]{"\u00a78" + lastMajorNegative}).m_7532_());
            lines.add(Component.m_237110_((String)"gui.thief.gossips.minor_negative", (Object[])new Object[]{"\u00a78" + lastMinorNegative}).m_7532_());
            lines.add(Component.m_237110_((String)"gui.thief.gossips.minor_positive", (Object[])new Object[]{"\u00a78" + lastMinorPositive}).m_7532_());
            lines.add(Component.m_237110_((String)"gui.thief.gossips.major_positive", (Object[])new Object[]{"\u00a78" + lastMajorPositive}).m_7532_());
            lines.add(Component.m_237110_((String)"gui.thief.gossips.trading", (Object[])new Object[]{"\u00a78" + lastTrading}).m_7532_());
        }
        int x = minecraft.m_91268_().m_85445_() / 2 + 8;
        int y = minecraft.m_91268_().m_85446_() / 2 - (int)((float)lines.size() / 2.0f * 9.0f);
        guiGraphics.m_280245_(minecraft.f_91062_, lines, x, y + 10);
    }

    public static void updateReputation(int villagerId, int reputation) {
        lastVillagerId = villagerId;
        lastReputation = reputation;
    }

    public static void updateGossips(int villagerId, int majorNegative, int minorNegative, int minorPositive, int majorPositive, int trading) {
        lastGossipsVillagerId = villagerId;
        lastMajorNegative = majorNegative;
        lastMinorNegative = minorNegative;
        lastMinorPositive = minorPositive;
        lastMajorPositive = majorPositive;
        lastTrading = trading;
    }
}

