/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.mortuusars.thief.world.Crime;
import io.github.mortuusars.thief.world.Reputation;
import io.github.mortuusars.thief.world.Witness;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;

public class ThiefCommand {
    public static boolean showNoticeDistanceAndWitnesses = false;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"thief").requires(stack -> stack.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"debug").then(Commands.m_82127_((String)"is_in_protected_structure").executes(ThiefCommand::isInProtectedStructure))).then(Commands.m_82127_((String)"show_notice_distance_and_witnesses").executes(ThiefCommand::showNoticeDistance))).then(Commands.m_82127_((String)"show_witness_reputation").executes(ThiefCommand::showWitnessReputation)))).then(Commands.m_82127_((String)"commit_crime").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"light").executes(context -> ThiefCommand.commitCrime((CommandContext<CommandSourceStack>)context, Crime.LIGHT)))).then(Commands.m_82127_((String)"medium").executes(context -> ThiefCommand.commitCrime((CommandContext<CommandSourceStack>)context, Crime.MEDIUM)))).then(Commands.m_82127_((String)"heavy").executes(context -> ThiefCommand.commitCrime((CommandContext<CommandSourceStack>)context, Crime.HEAVY))))));
    }

    private static int isInProtectedStructure(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Is in '#thief:protected' structure: " + Crime.isInProtectedStructure(((CommandSourceStack)context.getSource()).m_81372_(), player.m_20183_()))), true);
        return 0;
    }

    private static int showNoticeDistance(CommandContext<CommandSourceStack> context) {
        if (showNoticeDistanceAndWitnesses) {
            showNoticeDistanceAndWitnesses = false;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Turned off thief notice distance showing."), true);
        } else {
            showNoticeDistanceAndWitnesses = true;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Showing thief notice distance."), true);
        }
        return 0;
    }

    private static int showWitnessReputation(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        if (player.m_7500_() || player.m_5833_()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"You need to be in survival mode to be noticed by others."), true);
            return 0;
        }
        List<Villager> villagers = Witness.getWitnesses((LivingEntity)player).stream().filter(entity -> entity instanceof Villager).map(entity -> (Villager)entity).toList();
        if (villagers.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"No witnesses."), true);
            return 0;
        }
        int averageValue = Reputation.averageValueFromVillagers((LivingEntity)player, villagers);
        Reputation reputation = Reputation.fromValue(averageValue);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Average reputation of " + villagers.size() + " witnesses is: ")).m_7220_((Component)reputation.getLocalizedNameWithColor()).m_7220_((Component)Component.m_237113_((String)(" (" + averageValue + ")")).m_130948_(Style.f_131099_.m_178520_(reputation.getColor()))), true);
        return 0;
    }

    private static int commitCrime(CommandContext<CommandSourceStack> context, Crime crime) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        Crime.Outcome outcome = crime.commit(player.m_284548_(), (LivingEntity)player, player.m_20183_());
        if (outcome.punished()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)(player.m_6302_() + " has commited " + crime.getName() + " crime with " + outcome.witnesses().size() + " witnesses.")).m_130940_(ChatFormatting.RED), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)(player.m_6302_() + " has commited " + crime.getName() + " crime, but no one saw that.")).m_130940_(ChatFormatting.RED), true);
        }
        return 0;
    }
}

