/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.world;

import io.github.mortuusars.thief.Config;
import io.github.mortuusars.thief.Thief;
import io.github.mortuusars.thief.world.stealth.Stealth;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class Witness {
    public static List<LivingEntity> getWitnesses(LivingEntity criminal) {
        Player player;
        if (criminal instanceof Player && ((player = (Player)criminal).m_7500_() || player.m_5833_())) {
            return Collections.emptyList();
        }
        double visibility = Stealth.getVisibility(criminal);
        int radius = (Integer)Config.Common.WITNESS_MAX_DISTANCE.get();
        AABB crimeScene = new AABB(criminal.m_20183_()).m_82377_((double)radius, (double)((float)radius * 0.5f), (double)radius);
        return criminal.m_9236_().m_45976_(LivingEntity.class, crimeScene).stream().filter(e -> Witness.isWitness(criminal, e, visibility)).toList();
    }

    public static <T extends LivingEntity> List<T> getWitnesses(LivingEntity criminal, Class<T> entityClass) {
        Player player;
        if (criminal instanceof Player && ((player = (Player)criminal).m_7500_() || player.m_5833_())) {
            return Collections.emptyList();
        }
        double visibility = Stealth.getVisibility(criminal);
        int radius = (Integer)Config.Common.WITNESS_MAX_DISTANCE.get();
        AABB crimeScene = new AABB(criminal.m_20183_()).m_82377_((double)radius, (double)((float)radius * 0.5f), (double)radius);
        return criminal.m_9236_().m_45976_(entityClass, crimeScene).stream().filter(e -> Witness.isWitness(criminal, e, visibility)).toList();
    }

    public static boolean isWitness(LivingEntity criminal, LivingEntity entity, double visibility) {
        if (!entity.m_6095_().m_204039_(Thief.Tags.EntityTypes.WITNESSES)) {
            return false;
        }
        float distance = entity.m_20270_((Entity)criminal);
        if ((double)distance <= (double)((Integer)Config.Common.WITNESS_ALWAYS_NOTICE_DISTANCE.get()).intValue() / 2.0) {
            return true;
        }
        if (entity.m_5803_()) {
            return false;
        }
        if (distance <= (float)((Integer)Config.Common.WITNESS_ALWAYS_NOTICE_DISTANCE.get()).intValue()) {
            return true;
        }
        if ((double)distance > (double)((Integer)Config.Common.WITNESS_MAX_DISTANCE.get()).intValue() * visibility) {
            return false;
        }
        return entity.m_142582_((Entity)criminal);
    }
}

