/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.thief.Register;
import io.github.mortuusars.thief.advancement.trigger.VillagerGiftTrigger;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatFormatter;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.slf4j.Logger;

public class Thief {
    public static final String ID = "thief";
    public static final Logger LOGGER = LogUtils.getLogger();

    public static void init() {
        Blocks.init();
        BlockEntityTypes.init();
        EntityTypes.init();
        Items.init();
        DataComponents.init();
        Stats.init();
        CriteriaTriggers.init();
        ItemSubPredicates.init();
        MenuTypes.init();
        RecipeSerializers.init();
        SoundEvents.init();
        ArgumentTypes.init();
    }

    public static ResourceLocation resource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }

    public static class Blocks {
        static void init() {
        }
    }

    public static class BlockEntityTypes {
        static void init() {
        }
    }

    public static class EntityTypes {
        static void init() {
        }
    }

    public static class Items {
        static void init() {
        }
    }

    public static class DataComponents {
        static void init() {
        }
    }

    public static class Stats {
        public static final Supplier<ResourceLocation> CAUGHT_ON_VILLAGE_LIGHT_THEFTS = Register.stat(Thief.resource("caught_at_light_thefts_in_village"), StatFormatter.DEFAULT);
        public static final Supplier<ResourceLocation> CAUGHT_ON_VILLAGE_MEDIUM_THEFTS = Register.stat(Thief.resource("caught_at_medium_thefts_in_village"), StatFormatter.DEFAULT);
        public static final Supplier<ResourceLocation> CAUGHT_ON_VILLAGE_HEAVY_THEFTS = Register.stat(Thief.resource("caught_at_heavy_thefts_in_village"), StatFormatter.DEFAULT);

        public static void init() {
        }
    }

    public static class CriteriaTriggers {
        public static Supplier<VillagerGiftTrigger> VILLAGER_GIFT = Register.criterionTrigger("villager_gift", VillagerGiftTrigger::new);

        public static void init() {
        }
    }

    public static class ItemSubPredicates {
        public static void init() {
        }
    }

    public static class MenuTypes {
        static void init() {
        }
    }

    public static class RecipeSerializers {
        static void init() {
        }
    }

    public static class SoundEvents {
        private static Supplier<SoundEvent> register(String category, String key) {
            Preconditions.checkState((category != null && !category.isEmpty() ? 1 : 0) != 0, (Object)"'category' should not be empty.");
            Preconditions.checkState((key != null && !key.isEmpty() ? 1 : 0) != 0, (Object)"'key' should not be empty.");
            String path = category + "." + key;
            return Register.soundEvent(path, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)Thief.resource(path)));
        }

        static void init() {
        }
    }

    public static class ArgumentTypes {
        public static void init() {
        }
    }

    public static class Registries {
    }

    public static class Tags {

        public static class Structures {
            public static final TagKey<Structure> PROTECTED = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.STRUCTURE, (ResourceLocation)Thief.resource("protected"));
        }

        public static class EntityTypes {
            public static final TagKey<EntityType<?>> KILLING_PROTECTED_LIGHT = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.ENTITY_TYPE, (ResourceLocation)Thief.resource("killing_protected/light"));
            public static final TagKey<EntityType<?>> KILLING_PROTECTED_MEDIUM = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.ENTITY_TYPE, (ResourceLocation)Thief.resource("killing_protected/medium"));
            public static final TagKey<EntityType<?>> KILLING_PROTECTED_HEAVY = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.ENTITY_TYPE, (ResourceLocation)Thief.resource("killing_protected/heavy"));
            public static final TagKey<EntityType<?>> WITNESSES = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.ENTITY_TYPE, (ResourceLocation)Thief.resource("witnesses"));
            public static final TagKey<EntityType<?>> GUARDS = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.ENTITY_TYPE, (ResourceLocation)Thief.resource("guards"));
        }

        public static class Blocks {
            public static final TagKey<Block> BREAK_PROTECTED_LIGHT = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.BLOCK, (ResourceLocation)Thief.resource("break_protected/light"));
            public static final TagKey<Block> BREAK_PROTECTED_MEDIUM = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.BLOCK, (ResourceLocation)Thief.resource("break_protected/medium"));
            public static final TagKey<Block> BREAK_PROTECTED_HEAVY = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.BLOCK, (ResourceLocation)Thief.resource("break_protected/heavy"));
            public static final TagKey<Block> INTERACT_PROTECTED_LIGHT = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.BLOCK, (ResourceLocation)Thief.resource("interact_protected/light"));
            public static final TagKey<Block> INTERACT_PROTECTED_MEDIUM = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.BLOCK, (ResourceLocation)Thief.resource("interact_protected/medium"));
            public static final TagKey<Block> INTERACT_PROTECTED_HEAVY = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.BLOCK, (ResourceLocation)Thief.resource("interact_protected/heavy"));
        }

        public static class Items {
            public static final TagKey<Item> VILLAGER_GIFTS = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.ITEM, (ResourceLocation)Thief.resource("villager_gifts"));
        }
    }

    public static class LootTables {
    }
}

