/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.api.witness;

import io.github.mortuusars.thief.Thief;
import io.github.mortuusars.thief.api.witness.WitnessReactionHandler;
import io.github.mortuusars.thief.world.Crime;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.npc.Villager;

public class WitnessReaction {
    private static final List<WitnessReactionHandler> handlers = new ArrayList<WitnessReactionHandler>();

    public static void register(WitnessReactionHandler handler) {
        handlers.add(handler);
    }

    public static boolean handle(ServerLevel serverLevel, Crime crime, LivingEntity witness, LivingEntity criminal) {
        for (WitnessReactionHandler handler : handlers) {
            boolean result = handler.handle(serverLevel, crime, witness, criminal);
            if (!result) continue;
            return true;
        }
        return false;
    }

    static {
        WitnessReaction.register((level, crime, witness, criminal) -> {
            if (witness instanceof Villager) {
                Villager villager = (Villager)witness;
                villager.setUnhappy();
                level.onReputationEvent((ReputationEventType)crime, (Entity)criminal, (ReputationEventHandler)villager);
                level.broadcastEntityEvent((Entity)villager, (byte)13);
                return true;
            }
            return false;
        });
        WitnessReaction.register((level, crime, witness, criminal) -> {
            if (witness.getType().is(Thief.Tags.EntityTypes.GUARDS) && witness instanceof NeutralMob) {
                NeutralMob neutralMob = (NeutralMob)witness;
                if (crime.shouldGuardsAttack(level, witness, criminal) && witness.canAttack(criminal) && neutralMob.getTarget() == null) {
                    neutralMob.setTarget(criminal);
                    for (int i = 0; i < 5; ++i) {
                        double d = witness.getRandom().nextGaussian() * 0.02;
                        double e = witness.getRandom().nextGaussian() * 0.02;
                        double f = witness.getRandom().nextGaussian() * 0.02;
                        level.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, witness.getRandomX(1.0), witness.getRandomY() + 1.0, witness.getRandomZ(1.0), 5, d, e, f, 0.01);
                    }
                    return true;
                }
            }
            return false;
        });
    }
}

