/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.client;

import io.github.mortuusars.thief.Config;
import io.github.mortuusars.thief.Thief;
import io.github.mortuusars.thief.network.Packets;
import io.github.mortuusars.thief.network.packet.serverbound.QueryVillagerReputationC2SP;
import io.github.mortuusars.thief.world.Reputation;
import java.util.ArrayList;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class VillagerReputationTooltip {
    private static int lastVillagerId = -1;
    private static long lastRequestTime = -1L;
    private static int lastReputation = 0;
    private static int lastGossipsVillagerId = -1;
    private static int lastMajorNegative;
    private static int lastMinorNegative;
    private static int lastMinorPositive;
    private static int lastMajorPositive;
    private static int lastTrading;

    public static void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        EntityHitResult entityHitResult;
        HitResult hitResult;
        if (!((Boolean)Config.Client.VILLAGER_REPUTATION_TOOLTIP_ENABLED.get()).booleanValue()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.options.hideGui || minecraft.level == null || minecraft.player == null || minecraft.player.isSpectator() || minecraft.screen != null || !((hitResult = minecraft.hitResult) instanceof EntityHitResult) || !((hitResult = (entityHitResult = (EntityHitResult)hitResult).getEntity()) instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)hitResult;
        if (((Boolean)Config.Client.VILLAGER_REPUTATION_TOOLTIP_REQUIRES_GIFT.get()).booleanValue() && !minecraft.player.getMainHandItem().is(Thief.Tags.Items.VILLAGER_GIFTS)) {
            return;
        }
        long gameTime = minecraft.level.getGameTime();
        if (gameTime - lastRequestTime > 5L) {
            Packets.sendToServer(new QueryVillagerReputationC2SP(villager.getId(), Minecraft.getInstance().options.advancedItemTooltips));
            lastRequestTime = gameTime;
        }
        if (lastVillagerId != villager.getId()) {
            return;
        }
        Reputation reputation = Reputation.fromValue(lastReputation);
        MutableComponent name = reputation.getLocalizedNameWithColor();
        if (Minecraft.getInstance().options.advancedItemTooltips) {
            name.append(" (" + lastReputation + ")");
        }
        ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
        lines.add(Component.translatable((String)"gui.thief.reputation", (Object[])new Object[]{name}).getVisualOrderText());
        lines.addAll(Minecraft.getInstance().font.split((FormattedText)reputation.getLocalizedDescription(), 170));
        if (Minecraft.getInstance().options.advancedItemTooltips && lastGossipsVillagerId == villager.getId()) {
            lines.add(Component.translatable((String)"gui.thief.gossips").getVisualOrderText());
            lines.add(Component.translatable((String)"gui.thief.gossips.major_negative", (Object[])new Object[]{"\u00a78" + lastMajorNegative}).getVisualOrderText());
            lines.add(Component.translatable((String)"gui.thief.gossips.minor_negative", (Object[])new Object[]{"\u00a78" + lastMinorNegative}).getVisualOrderText());
            lines.add(Component.translatable((String)"gui.thief.gossips.minor_positive", (Object[])new Object[]{"\u00a78" + lastMinorPositive}).getVisualOrderText());
            lines.add(Component.translatable((String)"gui.thief.gossips.major_positive", (Object[])new Object[]{"\u00a78" + lastMajorPositive}).getVisualOrderText());
            lines.add(Component.translatable((String)"gui.thief.gossips.trading", (Object[])new Object[]{"\u00a78" + lastTrading}).getVisualOrderText());
        }
        int x = minecraft.getWindow().getGuiScaledWidth() / 2 + 8;
        int y = minecraft.getWindow().getGuiScaledHeight() / 2 - (int)((float)lines.size() / 2.0f * 9.0f);
        guiGraphics.renderTooltip(minecraft.font, lines, x, y + 10);
    }

    public static void updateReputation(int villagerId, int reputation) {
        lastVillagerId = villagerId;
        lastReputation = reputation;
    }

    public static void updateGossips(int villagerId, int majorNegative, int minorNegative, int minorPositive, int majorPositive, int trading) {
        lastGossipsVillagerId = villagerId;
        lastMajorNegative = majorNegative;
        lastMinorNegative = minorNegative;
        lastMinorPositive = minorPositive;
        lastMajorPositive = majorPositive;
        lastTrading = trading;
    }
}

