/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.mortuusars.thief.world.Crime;
import io.github.mortuusars.thief.world.Reputation;
import io.github.mortuusars.thief.world.Witness;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;

public class ThiefCommand {
    public static boolean showNoticeDistanceAndWitnesses = false;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"thief").requires(stack -> stack.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"debug").then(Commands.literal((String)"is_in_protected_structure").executes(ThiefCommand::isInProtectedStructure))).then(Commands.literal((String)"show_notice_distance_and_witnesses").executes(ThiefCommand::showNoticeDistance))).then(Commands.literal((String)"show_witness_reputation").executes(ThiefCommand::showWitnessReputation)))).then(Commands.literal((String)"commit_crime").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.literal((String)"light").executes(context -> ThiefCommand.commitCrime((CommandContext<CommandSourceStack>)context, Crime.LIGHT)))).then(Commands.literal((String)"medium").executes(context -> ThiefCommand.commitCrime((CommandContext<CommandSourceStack>)context, Crime.MEDIUM)))).then(Commands.literal((String)"heavy").executes(context -> ThiefCommand.commitCrime((CommandContext<CommandSourceStack>)context, Crime.HEAVY))))));
    }

    private static int isInProtectedStructure(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Is in '#thief:protected' structure: " + Crime.isInProtectedStructure(((CommandSourceStack)context.getSource()).getLevel(), player.blockPosition()))), true);
        return 0;
    }

    private static int showNoticeDistance(CommandContext<CommandSourceStack> context) {
        if (showNoticeDistanceAndWitnesses) {
            showNoticeDistanceAndWitnesses = false;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Turned off thief notice distance showing."), true);
        } else {
            showNoticeDistanceAndWitnesses = true;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Showing thief notice distance."), true);
        }
        return 0;
    }

    private static int showWitnessReputation(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        if (player.isCreative() || player.isSpectator()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"You need to be in survival mode to be noticed by others."), true);
            return 0;
        }
        List<Villager> villagers = Witness.getWitnesses((LivingEntity)player).stream().filter(entity -> entity instanceof Villager).map(entity -> (Villager)entity).toList();
        if (villagers.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"No witnesses."), true);
            return 0;
        }
        int averageValue = Reputation.averageValueFromVillagers((LivingEntity)player, villagers);
        Reputation reputation = Reputation.fromValue(averageValue);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Average reputation of " + villagers.size() + " witnesses is: ")).append((Component)reputation.getLocalizedNameWithColor()).append((Component)Component.literal((String)(" (" + averageValue + ")")).withColor(reputation.getColor())), true);
        return 0;
    }

    private static int commitCrime(CommandContext<CommandSourceStack> context, Crime crime) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Crime.Outcome outcome = crime.commit(player.serverLevel(), (LivingEntity)player, player.blockPosition());
        if (outcome.punished()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)(player.getScoreboardName() + " has commited " + crime.getName() + " crime with " + outcome.witnesses().size() + " witnesses.")).withStyle(ChatFormatting.RED), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)(player.getScoreboardName() + " has commited " + crime.getName() + " crime, but no one saw that.")).withStyle(ChatFormatting.RED), true);
        }
        return 0;
    }
}

