/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.event;

import com.mojang.brigadier.CommandDispatcher;
import io.github.mortuusars.thief.Config;
import io.github.mortuusars.thief.Thief;
import io.github.mortuusars.thief.command.ThiefCommand;
import io.github.mortuusars.thief.world.Reputation;
import io.github.mortuusars.thief.world.Witness;
import io.github.mortuusars.thief.world.stealth.Stealth;
import java.util.List;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;

public class CommonEvents {
    private static long lastGiftSoundPlayedAt = -1L;

    public static InteractionResult onEntityInteracted(Player player, InteractionHand hand, Entity target) {
        ServerPlayer serverPlayer;
        block8: {
            block7: {
                if (hand != InteractionHand.MAIN_HAND || !(player instanceof ServerPlayer)) break block7;
                serverPlayer = (ServerPlayer)player;
                if (target instanceof Villager) break block8;
            }
            return InteractionResult.PASS;
        }
        Villager villager = (Villager)target;
        ItemStack item = player.getItemInHand(hand);
        if ((!((Boolean)Config.Server.REQUIRES_SNEAK.get()).booleanValue() || player.isSecondaryUseActive()) && CommonEvents.canGift(serverPlayer, villager, item)) {
            ItemStack gift = item.split(1);
            villager.getGossips().add(player.getUUID(), GossipType.MINOR_POSITIVE, ((Integer)Config.Server.GIFTS_MINOR_POSITIVE_INCREASE.get()).intValue());
            villager.getGossips().remove(player.getUUID(), GossipType.MINOR_NEGATIVE, ((Integer)Config.Server.GIFTS_MINOR_NEGATIVE_REDUCTION.get()).intValue());
            if (villager.getBrain().isActive(Activity.PANIC) && villager.getPlayerReputation(player) > -60) {
                villager.getBrain().setActiveActivityIfPossible(Activity.IDLE);
            }
            player.level().broadcastEntityEvent((Entity)villager, (byte)14);
            if (player.level().getGameTime() - lastGiftSoundPlayedAt > 10L) {
                player.level().playSound(null, (Entity)villager, SoundEvents.VILLAGER_CELEBRATE, SoundSource.NEUTRAL, 1.0f, 1.0f);
                lastGiftSoundPlayedAt = player.level().getGameTime();
            }
            Thief.CriteriaTriggers.VILLAGER_GIFT.get().trigger(serverPlayer, (LivingEntity)villager, gift);
            return InteractionResult.SUCCESS;
        }
        if (!Reputation.fromValue(villager, (LivingEntity)player).canTrade()) {
            villager.setUnhappy();
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        return InteractionResult.PASS;
    }

    public static boolean canGift(ServerPlayer player, Villager villager, ItemStack item) {
        if (!((Boolean)Config.Server.GIFTS_ENABLED.get()).booleanValue()) {
            return false;
        }
        if (!item.is(Thief.Tags.Items.VILLAGER_GIFTS)) {
            return false;
        }
        int minorPositiveRep = villager.getGossips().getReputation(player.getUUID(), gossipType -> gossipType == GossipType.MINOR_POSITIVE);
        int minorNegativeRep = villager.getGossips().getReputation(player.getUUID(), gossipType -> gossipType == GossipType.MINOR_NEGATIVE);
        return minorPositiveRep < GossipType.MINOR_POSITIVE.max || minorNegativeRep < 0;
    }

    public static void onPlayerTick(Player player) {
        if (ThiefCommand.showNoticeDistanceAndWitnesses && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.level().getGameTime() % 3L == 0L) {
                List<LivingEntity> witnesses = Witness.getWitnesses((LivingEntity)player);
                for (LivingEntity witness : witnesses) {
                    witness.addEffect(new MobEffectInstance(MobEffects.GLOWING, 4));
                }
                double radius = (double)((Integer)Config.Server.WITNESS_MAX_DISTANCE.get()).intValue() * Stealth.getVisibility((LivingEntity)serverPlayer);
                int particles = 64;
                for (int i = 0; i < particles; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)particles;
                    double x = player.getX() + radius * Math.cos(angle);
                    double z = player.getZ() + radius * Math.sin(angle);
                    double y = player.getY() + 1.0;
                    serverPlayer.serverLevel().sendParticles(serverPlayer, (ParticleOptions)ParticleTypes.EXPLOSION, true, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection environment) {
        ThiefCommand.register(dispatcher);
    }
}

